/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.base.utils.loaders;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.common.base.utils.json.JsonDeserializers;
import com.nukateam.ntgl.common.data.config.CustomAmmo;
import com.nukateam.ntgl.common.util.annotation.Validator;
import java.io.InvalidObjectException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ntgl")
public class CustomAmmoLoader
extends SimpleJsonResourceReloadListener {
    private static CustomAmmoLoader instance;
    private Map<ResourceLocation, CustomAmmo> customAmmoMap = new HashMap<ResourceLocation, CustomAmmo>();

    public CustomAmmoLoader() {
        super(JsonDeserializers.GSON_INSTANCE, "custom_ammo");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objects, ResourceManager manager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        objects.forEach((resourceLocation, object) -> {
            try {
                CustomAmmo customAmmo = (CustomAmmo)JsonDeserializers.GSON_INSTANCE.fromJson(object, CustomAmmo.class);
                if (customAmmo != null && Validator.isValidObject(customAmmo)) {
                    builder.put(resourceLocation, (Object)customAmmo);
                } else {
                    Ntgl.LOGGER.error("Couldn't load data file {} as it is missing or malformed", resourceLocation);
                }
            }
            catch (InvalidObjectException e) {
                Ntgl.LOGGER.error("Missing required properties for {}", resourceLocation);
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
        this.customAmmoMap = builder.build();
    }

    public void writeCustomAmmo(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.customAmmoMap.size());
        this.customAmmoMap.forEach((id, gun) -> {
            buffer.m_130085_(id);
            buffer.m_130079_(gun.serializeNBT());
        });
    }

    public static ImmutableMap<ResourceLocation, CustomAmmo> readCustomAmmo(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        if (size > 0) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < size; ++i) {
                ResourceLocation id = buffer.m_130281_();
                CustomAmmo customAmmo = new CustomAmmo();
                customAmmo.deserializeNBT(buffer.m_130260_());
                builder.put((Object)id, (Object)customAmmo);
            }
            return builder.build();
        }
        return ImmutableMap.of();
    }

    @SubscribeEvent
    public static void addReloadListenerEvent(AddReloadListenerEvent event) {
        CustomAmmoLoader customGunLoader = new CustomAmmoLoader();
        event.addListener((PreparableReloadListener)customGunLoader);
        instance = customGunLoader;
    }

    @Nullable
    public static CustomAmmoLoader get() {
        return instance;
    }
}

