/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.base.utils;

import com.mrcrayfish.framework.api.sync.SyncedDataKey;
import com.mrcrayfish.framework.network.message.IMessage;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.common.base.DelayedTask;
import com.nukateam.ntgl.common.base.holders.LoadingType;
import com.nukateam.ntgl.common.data.config.gun.Gun;
import com.nukateam.ntgl.common.foundation.init.ModSyncedDataKeys;
import com.nukateam.ntgl.common.foundation.item.GunItem;
import com.nukateam.ntgl.common.network.PacketHandler;
import com.nukateam.ntgl.common.network.message.S2CMessageReload;
import com.nukateam.ntgl.common.util.helpers.context.IAmmoContext;
import com.nukateam.ntgl.common.util.util.GunData;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import com.nukateam.ntgl.common.util.util.LivingEntityUtils;
import com.nukateam.ntgl.common.util.util.StackUtils;
import com.nukateam.ntgl.modules.enchantment.GunEnchantmentHelper;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="ntgl")
public class ReloadTracker {
    private static final Map<LivingEntity, ReloadTracker> RELOAD_TRACKER_MAP = new WeakHashMap<LivingEntity, ReloadTracker>();
    private final int startTick;
    private final LivingEntity shooter;
    private int slot = 0;
    private final HumanoidArm arm;
    private final ItemStack stack;
    private final GunItem gunItem;
    private final Gun gun;
    public int reloadTick;
    public boolean isStart = false;
    public boolean isEnd = false;

    private ReloadTracker(LivingEntity entity, HumanoidArm arm) {
        this.startTick = entity.f_19797_;
        this.arm = arm;
        this.stack = entity.m_21120_(LivingEntityUtils.getInteractionHand(arm));
        this.gunItem = (GunItem)this.stack.m_41720_();
        this.gun = this.gunItem.getModifiedGun(this.stack);
        this.shooter = entity;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.slot = arm == HumanoidArm.RIGHT ? player.m_150109_().f_35977_ : 40;
        }
        GunData data = new GunData(this.stack, entity);
        this.reloadTick = GunModifierHelper.getReloadTime(data);
        LoadingType loadingType = GunModifierHelper.getLoadingType(data);
        if (loadingType == LoadingType.PER_CARTRIDGE) {
            ModSyncedDataKeys.RELOAD_START.setValue((Entity)entity, (Object)true);
            this.reloadTick = GunModifierHelper.getReloadStart(data);
            this.isStart = true;
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        try {
            if (event.phase == TickEvent.Phase.START && !event.player.m_9236_().f_46443_) {
                Player player = event.player;
                ReloadTracker.handTick((LivingEntity)player);
            }
        }
        catch (Exception e) {
            Ntgl.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        try {
            if (event.phase == TickEvent.Phase.START) {
                for (LivingEntity entity : RELOAD_TRACKER_MAP.keySet()) {
                    if (entity instanceof Player) continue;
                    ReloadTracker.handTick(entity);
                }
            }
        }
        catch (Exception e) {
            Ntgl.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        MinecraftServer server = event.getEntity().m_20194_();
        if (server != null) {
            server.execute(() -> RELOAD_TRACKER_MAP.remove(event.getEntity()));
        }
    }

    private boolean isSameWeapon(LivingEntity entity) {
        if (this.arm == HumanoidArm.RIGHT) {
            return !this.stack.m_41619_() && entity.m_21205_() == this.stack;
        }
        return !this.stack.m_41619_() && entity.m_21206_() == this.stack;
    }

    private boolean isWeaponFull() {
        GunData data = new GunData(this.stack, this.shooter);
        return Gun.getAmmo(this.stack) >= GunEnchantmentHelper.getAmmoCapacity(data);
    }

    private boolean hasNoAmmo(LivingEntity player) {
        return Gun.hasNoAmmo(player, this.stack);
    }

    private boolean canReload(Player player) {
        int deltaTicks = player.f_19797_ - this.startTick;
        int interval = GunEnchantmentHelper.getReloadInterval(this.stack);
        return deltaTicks > 0 && deltaTicks % interval == 0;
    }

    private static void addOrDropStack(Player player, ItemStack usedMagazine) {
        if (!player.m_36356_(usedMagazine)) {
            player.m_36176_(usedMagazine, false);
        }
    }

    private static void handTick(LivingEntity entity) {
        if (((Boolean)ModSyncedDataKeys.RELOADING_RIGHT.getValue((Entity)entity)).booleanValue()) {
            ReloadTracker.handTick(entity, HumanoidArm.RIGHT);
        } else if (((Boolean)ModSyncedDataKeys.RELOADING_LEFT.getValue((Entity)entity)).booleanValue()) {
            ReloadTracker.handTick(entity, HumanoidArm.LEFT);
        } else if (RELOAD_TRACKER_MAP.containsKey(entity)) {
            RELOAD_TRACKER_MAP.remove(entity);
        }
    }

    private static void handTick(LivingEntity shooter, HumanoidArm arm) {
        if (ReloadTracker.addTracker(shooter, arm)) {
            return;
        }
        ReloadTracker tracker = RELOAD_TRACKER_MAP.get(shooter);
        GunData data = new GunData(tracker.stack, shooter);
        LoadingType loadingType = GunModifierHelper.getLoadingType(data);
        Gun gun = tracker.gun;
        boolean isSameWeapon = !tracker.isSameWeapon(shooter);
        boolean isWeaponFull = tracker.isWeaponFull();
        boolean hasNoAmmo = tracker.hasNoAmmo(shooter);
        if (isSameWeapon || !tracker.isEnd && (isWeaponFull || hasNoAmmo)) {
            RELOAD_TRACKER_MAP.remove(shooter);
            SyncedDataKey<LivingEntity, Boolean> reloadKey = ReloadTracker.getReloadKey(arm);
            reloadKey.setValue((Entity)shooter, (Object)false);
        } else if (loadingType == LoadingType.MAGAZINE) {
            if (tracker.reloadTick > 0) {
                --tracker.reloadTick;
            }
            if (tracker.reloadTick == 0) {
                tracker.reloadMagazine(shooter);
                ReloadTracker.stopReloading(shooter, gun, arm);
            }
        } else if (loadingType == LoadingType.PER_CARTRIDGE) {
            if (tracker.reloadTick > 0) {
                --tracker.reloadTick;
            }
            if (tracker.reloadTick == 0) {
                if (tracker.isStart) {
                    ReloadTracker.resetTracker(tracker, data);
                    tracker.isStart = false;
                    ModSyncedDataKeys.RELOAD_START.setValue((Entity)shooter, (Object)false);
                } else {
                    tracker.addCartridge(shooter);
                    if (tracker.isWeaponFull() || tracker.hasNoAmmo(shooter)) {
                        if (tracker.isEnd) {
                            ModSyncedDataKeys.RELOAD_END.setValue((Entity)shooter, (Object)false);
                            ReloadTracker.stopReloading(shooter, gun, arm);
                        } else {
                            tracker.isEnd = true;
                            ModSyncedDataKeys.RELOAD_END.setValue((Entity)shooter, (Object)true);
                            tracker.reloadTick = GunModifierHelper.getReloadEnd(data);
                        }
                    } else {
                        ReloadTracker.resetTracker(tracker, data);
                    }
                }
            }
        }
    }

    private void reloadMagazine(LivingEntity player) {
        GunData data = new GunData(this.stack, player);
        if (GunStateHelper.getAmmoConfig(data).isMagazineMode()) {
            this.addMagazine(player);
        } else {
            this.addAmmo(player);
        }
    }

    private void addCartridge(LivingEntity entity) {
        this.addAmmo(entity, this.gun.getGeneral().getReloadAmount());
    }

    private void addAmmo(LivingEntity entity) {
        GunData data = new GunData(this.stack, entity);
        int amount = GunModifierHelper.getMaxAmmo(data);
        while (this.isNotReloaded(entity)) {
            this.addAmmo(entity, amount);
        }
    }

    private void addAmmo(LivingEntity entity, int amount) {
        IAmmoContext context = Gun.findAmmo(entity, this.stack);
        ItemStack ammo = context.stack();
        if (!ammo.m_41619_()) {
            CompoundTag tag = this.stack.m_41783_();
            amount = Math.min(ammo.m_41613_(), amount);
            if (tag != null) {
                GunData data = new GunData(this.stack, this.shooter);
                int maxAmmo = GunEnchantmentHelper.getAmmoCapacity(data);
                amount = Math.min(amount, maxAmmo - tag.m_128451_("AmmoCount"));
                tag.m_128405_("AmmoCount", tag.m_128451_("AmmoCount") + amount);
            }
            context.shrink(amount);
        }
    }

    private boolean isNotReloaded(LivingEntity entity) {
        GunData data = new GunData(this.stack, entity);
        ResourceLocation ammoItem = GunStateHelper.getAmmoId(data);
        CompoundTag tag = this.stack.m_41783_();
        return !Gun.findAmmo(entity, this.stack).stack().m_41619_() && tag.m_128451_("AmmoCount") < GunEnchantmentHelper.getAmmoCapacity(data);
    }

    private void addMagazine(LivingEntity entity) {
        GunData data = new GunData(this.stack, entity);
        ResourceLocation ammoId = GunStateHelper.getAmmoId(data);
        IAmmoContext context = Gun.findMagazine(entity, this.stack);
        ItemStack ammo = context.stack();
        if (!ammo.m_41619_()) {
            int amount = StackUtils.getDurability(ammo);
            CompoundTag tag = this.stack.m_41783_();
            amount = Math.min(GunModifierHelper.getMaxAmmo(data), amount);
            if (tag != null) {
                int maxAmmo = GunEnchantmentHelper.getAmmoCapacity(data);
                int currentAmmo = tag.m_128451_("AmmoCount");
                if (currentAmmo > 0) {
                    ItemStack usedMagazine = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(ammoId));
                    StackUtils.setDurability(usedMagazine, currentAmmo);
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        ReloadTracker.addOrDropStack(player, usedMagazine);
                    }
                }
                tag.m_128405_("AmmoCount", amount);
            }
            context.shrink(1);
        }
    }

    private static void resetTracker(ReloadTracker tracker, GunData data) {
        tracker.reloadTick = GunModifierHelper.getReloadTime(data);
    }

    public static void startReloading(LivingEntity entity, HumanoidArm arm) {
        SyncedDataKey<LivingEntity, Boolean> reloadKey = ReloadTracker.getReloadKey(arm);
        reloadKey.setValue((Entity)entity, (Object)true);
        ReloadTracker.addTracker(entity, arm);
    }

    private static SyncedDataKey<LivingEntity, Boolean> getReloadKey(HumanoidArm arm) {
        SyncedDataKey<LivingEntity, Boolean> reloadKey = arm == HumanoidArm.RIGHT ? ModSyncedDataKeys.RELOADING_RIGHT : ModSyncedDataKeys.RELOADING_LEFT;
        return reloadKey;
    }

    private static boolean addTracker(LivingEntity entity, HumanoidArm arm) {
        Item gunItem;
        SyncedDataKey<LivingEntity, Boolean> reloadKey = ReloadTracker.getReloadKey(arm);
        Item item = gunItem = arm == HumanoidArm.RIGHT ? entity.m_21205_().m_41720_() : entity.m_21206_().m_41720_();
        if (!RELOAD_TRACKER_MAP.containsKey(entity)) {
            if (!(gunItem instanceof GunItem)) {
                reloadKey.setValue((Entity)entity, (Object)false);
                return true;
            }
            RELOAD_TRACKER_MAP.put(entity, new ReloadTracker(entity, arm));
        }
        return false;
    }

    private static void stopReloading(LivingEntity entity, Gun gun, HumanoidArm arm) {
        SyncedDataKey<LivingEntity, Boolean> reloadKey = ReloadTracker.getReloadKey(arm);
        RELOAD_TRACKER_MAP.remove(entity);
        reloadKey.setValue((Entity)entity, (Object)false);
        LivingEntity finalPlayer = entity;
        DelayedTask.runAfter(4, () -> gun.playCockSound(finalPlayer));
        ItemStack oppositeStack = LivingEntityUtils.getItemInHand(entity, arm.m_20828_());
        GunData data = new GunData(oppositeStack, entity);
        if (arm == HumanoidArm.RIGHT && oppositeStack.m_41720_() instanceof GunItem && !GunModifierHelper.isWeaponFull(data)) {
            PacketHandler.getPlayChannel().sendToPlayer(() -> (ServerPlayer)entity, (IMessage)new S2CMessageReload(true, arm.m_20828_()));
        }
    }
}

