/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.base.utils;

import com.nukateam.ntgl.common.base.holders.ProjectileType;
import com.nukateam.ntgl.common.foundation.entity.ProjectileEntity;
import com.nukateam.ntgl.common.foundation.init.Projectiles;
import com.nukateam.ntgl.common.util.interfaces.IProjectileFactory;
import com.nukateam.ntgl.common.util.util.GunData;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class ProjectileManager {
    private static ProjectileManager instance = null;
    private final IProjectileFactory DEFAULT_FACTORY = (worldIn, entity, weapon, item, modifiedGun) -> new ProjectileEntity((EntityType<? extends Entity>)((EntityType)Projectiles.PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun);
    private final Map<ResourceLocation, IProjectileFactory> projectileForAmmoFactories = new HashMap<ResourceLocation, IProjectileFactory>();
    private final Map<ResourceLocation, IProjectileFactory> projectileForTypeFactories = new HashMap<ResourceLocation, IProjectileFactory>();

    public static ProjectileManager getInstance() {
        if (instance == null) {
            instance = new ProjectileManager();
        }
        return instance;
    }

    public void registerFactory(ProjectileType ammo, IProjectileFactory factory) {
        this.projectileForTypeFactories.put(ammo.getId(), factory);
    }

    public void registerFactory(Item ammo, IProjectileFactory factory) {
        this.projectileForAmmoFactories.put(ForgeRegistries.ITEMS.getKey((Object)ammo), factory);
    }

    public IProjectileFactory getFactory(GunData data) {
        ResourceLocation item = GunStateHelper.getAmmoId(data);
        ProjectileType projectileType = GunStateHelper.getAmmoConfig(data).getProjectile();
        IProjectileFactory factory = this.projectileForAmmoFactories.get(item);
        if (this.projectileForAmmoFactories.containsKey(item)) {
            return this.projectileForAmmoFactories.get(item);
        }
        factory = this.projectileForTypeFactories.get(projectileType.getId());
        if (factory != null) {
            return factory;
        }
        return this.DEFAULT_FACTORY;
    }
}

