/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.base;

import com.google.common.collect.ImmutableMap;
import com.nukateam.ntgl.common.base.ConfigUtils;
import com.nukateam.ntgl.common.foundation.item.IConfigConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.Validate;

@Mod.EventBusSubscriber(modid="ntgl")
public abstract class NetworkManager<T extends IConfigConsumer, Y extends INBTSerializable<CompoundTag>>
extends SimplePreparableReloadListener<Map<T, Y>> {
    private Map<ResourceLocation, Y> registeredGuns = new HashMap<ResourceLocation, Y>();

    protected abstract Boolean check(Item var1);

    protected abstract Class<Y> getConfigClass();

    protected abstract String getPath();

    protected Map<T, Y> prepare(ResourceManager manager, ProfilerFiller profiler) {
        return ConfigUtils.getConfigMap(manager, this::check, this.getConfigClass(), this.getPath());
    }

    protected void apply(Map<T, Y> objects, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        objects.forEach((configProvider, gun) -> {
            Item item = (Item)configProvider;
            Validate.notNull((Object)ForgeRegistries.ITEMS.getKey((Object)item));
            builder.put((Object)ForgeRegistries.ITEMS.getKey((Object)item), gun);
            configProvider.setConfig(new Supplier<INBTSerializable>((INBTSerializable)gun));
        });
        this.registeredGuns = builder.build();
    }

    public static class Supplier<S extends INBTSerializable<CompoundTag>> {
        private final S config;

        Supplier(S config) {
            this.config = config;
        }

        public S getConfig() {
            return this.config;
        }
    }
}

