/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.util.pose;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.nukateam.ntgl.Config;
import com.nukateam.ntgl.client.util.pose.AimPose;
import com.nukateam.ntgl.client.util.pose.LimbPose;
import com.nukateam.ntgl.client.util.pose.WeaponPose;
import com.nukateam.ntgl.common.base.holders.GripType;
import mod.azure.azurelib.core.animatable.model.CoreGeoBone;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

public class MiniGunPose
extends WeaponPose {
    @Override
    protected AimPose getUpPose() {
        AimPose pose = new AimPose();
        pose.getIdle().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(10.0f, 0.0f, 0.0f)).setRightArm(new LimbPose().setRotationAngleX(-100.0f).setRotationAngleY(-45.0f).setRotationAngleZ(0.0f).setRotationPointY(2.0f)).setLeftArm(new LimbPose().setRotationAngleX(-150.0f).setRotationAngleY(40.0f).setRotationAngleZ(-10.0f).setRotationPointY(1.0f));
        return pose;
    }

    @Override
    protected AimPose getForwardPose() {
        AimPose pose = new AimPose();
        pose.getIdle().setRenderYawOffset(45.0f).setRightArm(new LimbPose().setRotationAngleX(-15.0f).setRotationAngleY(-45.0f).setRotationAngleZ(0.0f).setRotationPointY(2.0f)).setLeftArm(new LimbPose().setRotationAngleX(-45.0f).setRotationAngleY(30.0f).setRotationAngleZ(0.0f).setRotationPointY(2.0f));
        return pose;
    }

    @Override
    protected AimPose getDownPose() {
        AimPose pose = new AimPose();
        pose.getIdle().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(-30.0f, 0.0f, 0.0f)).setItemTranslate(new Vector3f(0.0f, 0.0f, 1.0f)).setRightArm(new LimbPose().setRotationAngleX(0.0f).setRotationAngleY(-45.0f).setRotationAngleZ(0.0f).setRotationPointY(1.0f)).setLeftArm(new LimbPose().setRotationAngleX(-25.0f).setRotationAngleY(30.0f).setRotationAngleZ(15.0f).setRotationPointY(4.0f));
        return pose;
    }

    @Override
    protected boolean hasAimPose() {
        return false;
    }

    @Override
    public void applyHumanoidModelRotation(LivingEntity entity, ModelPart rightArm, ModelPart leftArm, ModelPart head, InteractionHand hand, float aimProgress) {
        if (hand == InteractionHand.OFF_HAND) {
            return;
        }
        if (((Boolean)Config.CLIENT.display.oldAnimations.get()).booleanValue()) {
            boolean right = Minecraft.m_91087_().f_91066_.m_232107_().m_231551_() == HumanoidArm.RIGHT ? hand == InteractionHand.MAIN_HAND : hand == InteractionHand.OFF_HAND;
            ModelPart mainArm = right ? rightArm : leftArm;
            ModelPart secondaryArm = right ? leftArm : rightArm;
            mainArm.f_104203_ = (float)Math.toRadians(-15.0);
            mainArm.f_104204_ = (float)Math.toRadians(-45.0) * (right ? 1.0f : -1.0f);
            mainArm.f_104205_ = (float)Math.toRadians(0.0);
            secondaryArm.f_104203_ = (float)Math.toRadians(-45.0);
            secondaryArm.f_104204_ = (float)Math.toRadians(30.0) * (right ? 1.0f : -1.0f);
            secondaryArm.f_104205_ = (float)Math.toRadians(0.0);
        } else {
            super.applyHumanoidModelRotation(entity, rightArm, leftArm, head, hand, aimProgress);
        }
    }

    @Override
    public void applyGeoModelRotation(LivingEntity entity, CoreGeoBone rightArm, CoreGeoBone leftArm, CoreGeoBone head, InteractionHand interactionHand) {
        rightArm.setRotX((float)Math.toRadians(15.0));
        rightArm.setRotY((float)Math.toRadians(45.0));
        rightArm.setRotZ((float)Math.toRadians(0.0));
        leftArm.setRotX((float)Math.toRadians(45.0));
        leftArm.setRotY((float)Math.toRadians(-30.0));
        leftArm.setRotZ((float)Math.toRadians(0.0));
    }

    public static boolean rightHandIsMain(InteractionHand hand) {
        return Minecraft.m_91087_().f_91066_.m_232107_().m_231551_() == HumanoidArm.RIGHT ? hand == InteractionHand.MAIN_HAND : hand == InteractionHand.OFF_HAND;
    }

    @Override
    public void applyEntityPreRender(LivingEntity entity, InteractionHand hand, float aimProgress, PoseStack poseStack, MultiBufferSource buffer) {
        if (((Boolean)Config.CLIENT.display.oldAnimations.get()).booleanValue()) {
            boolean right = MiniGunPose.rightHandIsMain(hand);
            entity.f_20884_ = entity.f_19859_ + 45.0f * (right ? 1.0f : -1.0f);
            entity.f_20883_ = entity.m_146908_() + 45.0f * (right ? 1.0f : -1.0f);
        } else {
            super.applyEntityPreRender(entity, hand, aimProgress, poseStack, buffer);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyHeldItemTransforms(LivingEntity entity, InteractionHand hand, float aimProgress, PoseStack poseStack, MultiBufferSource buffer) {
        poseStack.m_85837_(-0.4375, 0.1875, -1.25);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(67.0f));
        super.applyHeldItemTransforms(entity, hand, aimProgress, poseStack, buffer);
    }

    @Override
    public boolean applyOffhandTransforms(LivingEntity entity, HumanoidModel<LivingEntity> model, ItemStack stack, PoseStack poseStack, float partialTicks) {
        return GripType.applyBackTransforms(entity, poseStack);
    }

    @Override
    public boolean canApplySprintingAnimation() {
        return false;
    }
}

