/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.util.handler;

import com.nukateam.ntgl.Config;
import com.nukateam.ntgl.client.util.handler.AimingHandler;
import com.nukateam.ntgl.client.util.handler.ShootingHandler;
import com.nukateam.ntgl.common.data.config.gun.Gun;
import com.nukateam.ntgl.common.event.GunFireEvent;
import com.nukateam.ntgl.common.foundation.item.GunItem;
import com.nukateam.ntgl.common.util.util.GunData;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RecoilHandler {
    private static RecoilHandler instance;
    public float lastRandPitch = 0.0f;
    public float lastRandYaw = 0.0f;
    private Random random = new Random();
    private double gunRecoilNormal;
    private double gunRecoilAngle;
    private float gunRecoilRandom;
    private float cameraRecoil;
    private float progressCameraRecoil;

    public static RecoilHandler get() {
        if (instance == null) {
            instance = new RecoilHandler();
        }
        return instance;
    }

    private RecoilHandler() {
    }

    @SubscribeEvent
    public void onGunFire(GunFireEvent.Post event) {
        if (!event.isClient()) {
            return;
        }
        if (!((Boolean)Config.SERVER.enableCameraRecoil.get()).booleanValue()) {
            return;
        }
        ItemStack heldItem = event.getStack();
        GunItem gunItem = (GunItem)heldItem.m_41720_();
        Gun modifiedGun = gunItem.getModifiedGun(heldItem);
        GunData data = new GunData(heldItem, event.getEntity());
        float recoilModifier = 1.0f - GunModifierHelper.getRecoilModifier(data);
        recoilModifier = (float)((double)recoilModifier * this.getAdsRecoilReduction(modifiedGun));
        this.cameraRecoil = modifiedGun.getGeneral().getRecoilAngle() * recoilModifier;
        this.progressCameraRecoil = 0.0f;
        this.gunRecoilRandom = this.random.nextFloat();
        this.lastRandPitch = this.random.nextFloat();
        this.lastRandYaw = this.random.nextFloat();
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.END || this.cameraRecoil <= 0.0f) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        if (!((Boolean)Config.SERVER.enableCameraRecoil.get()).booleanValue()) {
            return;
        }
        float recoilAmount = this.cameraRecoil * mc.m_91297_() * 0.15f;
        float startProgress = this.progressCameraRecoil / this.cameraRecoil;
        float endProgress = (this.progressCameraRecoil + recoilAmount) / this.cameraRecoil;
        float pitch = mc.f_91074_.m_146909_();
        if (startProgress < 0.2f) {
            mc.f_91074_.m_146926_(pitch - (endProgress - startProgress) / 0.2f * this.cameraRecoil);
        } else {
            mc.f_91074_.m_146926_(pitch + (endProgress - startProgress) / 0.8f * this.cameraRecoil);
        }
        this.progressCameraRecoil += recoilAmount;
        if (this.progressCameraRecoil >= this.cameraRecoil) {
            this.cameraRecoil = 0.0f;
            this.progressCameraRecoil = 0.0f;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderOverlay(RenderHandEvent event) {
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        ItemStack heldItem = event.getItemStack();
        Item item = heldItem.m_41720_();
        if (!(item instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)item;
        Gun modifiedGun = gunItem.getModifiedGun(heldItem);
        float cooldown = ShootingHandler.get().getCooldownPercent((LivingEntity)Minecraft.m_91087_().f_91074_, event.getHand());
        float recoilDurationOffset = modifiedGun.getGeneral().getRecoilDurationOffset();
        float f = cooldown = cooldown >= recoilDurationOffset ? (cooldown - recoilDurationOffset) / (1.0f - recoilDurationOffset) : 0.0f;
        if ((double)cooldown >= 0.8) {
            float amount = (1.0f - cooldown) / 0.2f;
            this.gunRecoilNormal = 1.0f - (amount -= 1.0f) * amount * amount * amount;
        } else {
            float amount = cooldown / 0.8f;
            this.gunRecoilNormal = (double)amount < 0.5 ? (double)(2.0f * amount * amount) : (double)(-1.0f + (4.0f - 2.0f * amount) * amount);
        }
        this.gunRecoilAngle = modifiedGun.getGeneral().getRecoilAngle();
    }

    public double getAdsRecoilReduction(Gun gun) {
        return 1.0 - (double)gun.getGeneral().getRecoilAdsReduction() * AimingHandler.get().getNormalisedAdsProgress();
    }

    public double getGunRecoilNormal() {
        return this.gunRecoilNormal;
    }

    public double getGunRecoilAngle() {
        return this.gunRecoilAngle;
    }

    public float getGunRecoilRandom() {
        return this.gunRecoilRandom;
    }
}

