/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.render.renderers.projectiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.nukateam.ntgl.client.util.util.render.RenderUtils;
import com.nukateam.ntgl.common.foundation.entity.TeslaProjectile;
import com.nukateam.ntgl.common.util.data.Rgba;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class TeslaProjectileRenderer
extends EntityRenderer<TeslaProjectile> {
    public static ResourceLocation texture = new ResourceLocation("ntgl", "textures/fx/tesla.png");
    private final float laserRadius = 0.01f;
    private final float laserGlowRadius = 0.011f;
    private static final int MIN_ANGLE = -45;
    private static final int MAX_ANGLE = 45;
    static final double offset = 0.5;

    public TeslaProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public ResourceLocation getTextureLocation(TeslaProjectile entity) {
        return texture;
    }

    public boolean shouldRender(TeslaProjectile pLivingEntity, Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
        return true;
    }

    public void render(TeslaProjectile projectile, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        this.renderLightning(projectile, partialTicks, poseStack, bufferSource, true);
        this.renderLightning(projectile, partialTicks, poseStack, bufferSource, false);
    }

    private void renderLightning(TeslaProjectile projectile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, boolean isVertical) {
        float prog = (float)projectile.f_19797_ / (float)projectile.getLife();
        double fadingValue = Math.sin(Math.sqrt(prog) * Math.PI);
        float radius = (float)((double)0.01f * fadingValue * 2.0);
        float glowRadius = (float)((double)0.011f * fadingValue * 2.0);
        float distance = projectile.getDistance();
        int count = (int)Math.round((double)distance / 0.5);
        Vec3 playerPos = projectile.getEndVec();
        Vec3 laserPos = projectile.getStartVec();
        Vec3 pos = playerPos.m_82546_(laserPos);
        poseStack.m_85836_();
        pos = pos.m_82541_();
        float yPos = (float)Math.acos(pos.f_82480_);
        float xzPos = (float)Math.atan2(pos.f_82481_, pos.f_82479_);
        int side = projectile.isRightHand() ? -1 : 1;
        poseStack.m_252781_(Axis.f_252436_.m_252977_((1.5707964f - xzPos) * 57.295776f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(yPos * 57.295776f));
        poseStack.m_85837_((double)side * 0.25, 0.0, 0.0);
        float angleX = projectile.angle;
        int flag = 1;
        float length = distance / (float)count;
        for (int i = 0; i <= count; ++i) {
            poseStack.m_85836_();
            if (flag > 0) {
                angleX = TeslaProjectileRenderer.getRandomAngle();
            }
            double radiansX = (double)angleX * Math.PI / 180.0;
            double offsetZ = (double)length * Math.sin(Math.abs(radiansX)) * (double)(-flag);
            double offsetY = (double)length * Math.cos(Math.abs(radiansX));
            if (isVertical) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(angleX * (float)flag));
                if (angleX < 0.0f) {
                    offsetZ = -offsetZ;
                }
                poseStack.m_85837_(0.0, 0.0, offsetZ / 2.0);
            } else {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(angleX * (float)flag));
                if (angleX > 0.0f) {
                    offsetZ = -offsetZ;
                }
                poseStack.m_85837_(offsetZ / 2.0, 0.0, 0.0);
            }
            long gameTime = projectile.m_9236_().m_46467_();
            boolean yOffset = false;
            Rgba color = new Rgba(1.0f, 1.0f, 1.0f, 1.0f);
            RenderUtils.renderBeam(poseStack, bufferSource, texture, partialTicks, 1.0f, gameTime, (float)yOffset - 0.1f, (float)((double)length + 0.1), color, radius, glowRadius);
            poseStack.m_85849_();
            poseStack.m_85837_(0.0, offsetY, 0.0);
            flag = -flag;
        }
        poseStack.m_85849_();
    }

    public static int getRandomAngle() {
        return ThreadLocalRandom.current().nextInt(-45, 46);
    }
}

