/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.render.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.nukateam.ntgl.client.event.GunHudEvent;
import com.nukateam.ntgl.client.render.hud.GunHudCache;
import com.nukateam.ntgl.client.util.util.render.Figures;
import com.nukateam.ntgl.common.base.holders.AmmoType;
import com.nukateam.ntgl.common.base.holders.FireMode;
import com.nukateam.ntgl.common.base.holders.FuelType;
import com.nukateam.ntgl.common.base.utils.FuelUtils;
import com.nukateam.ntgl.common.data.config.gun.Gun;
import com.nukateam.ntgl.common.foundation.item.AmmoBoxItem;
import com.nukateam.ntgl.common.foundation.item.GunItem;
import com.nukateam.ntgl.common.util.util.GunData;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class GunHud
implements IGuiOverlay {
    public static final float COUNTER_SCALE = 0.9f;
    public static final int INVENTORY_AMMO_COUNT_COLOR = 0xAAAAAA;
    public static final int DEFAULT_AMMO_COLOR = 0xFFFFFF;
    public static final int LOW_AMMO_COLOR = 0xFF5555;
    public static final Colors DEFAULT_COLORS = new Colors(0xFFFFFF, 0xAAAAAA, 0xFFFFFF, 0xFF5555);
    protected static final DecimalFormat CURRENT_AMMO_FORMAT = new DecimalFormat("000");
    protected static final DecimalFormat INVENTORY_AMMO_FORMAT = new DecimalFormat("0000");
    private static final int ICON_X = 115;
    private static final int OFFHAND_X_OFFSET = 110;
    private static final int BAR_WIDTH = 35;
    private static final int BAR_HEIGHT = 6;
    private static final int BAR_START_X = 70;
    private static final int BAR_START_Y = 57;
    protected static final Map<InteractionHand, GunHudCache> cache = Map.of(InteractionHand.MAIN_HAND, new GunHudCache(InteractionHand.MAIN_HAND), InteractionHand.OFF_HAND, new GunHudCache(InteractionHand.OFF_HAND));
    protected final Minecraft minecraft = Minecraft.m_91087_();
    private Colors colors = DEFAULT_COLORS;
    public static final IGuiOverlay AMMO_HUD = new GunHud();

    public void setHudColor(Colors hudColor) {
        this.colors = hudColor;
    }

    public void resetHudColor() {
        this.colors = DEFAULT_COLORS;
    }

    public static int toRgba(int rgb) {
        int alpha = 255;
        return alpha << 24 | rgb;
    }

    public static float[] rgbToFloatRgba(int rgb) {
        float red = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float green = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float blue = (float)(rgb & 0xFF) / 255.0f;
        return new float[]{red, green, blue, 1.0f};
    }

    public void render(ForgeGui gui, GuiGraphics graphics, float partialTick, int width, int height) {
        if (this.minecraft.f_91074_ == null) {
            return;
        }
        LocalPlayer player = this.minecraft.f_91074_;
        GunHud.cache.forEach((hand, cache) -> {
            int x;
            ItemStack heldItem = player.m_21120_(hand);
            int n = x = hand == InteractionHand.OFF_HAND ? 110 : width;
            if (heldItem.m_41720_() instanceof GunItem && GunHud.shouldRender(hand, player)) {
                this.updateCache((GunHudCache)cache, player, heldItem);
                if (!MinecraftForge.EVENT_BUS.post((Event)new GunHudEvent(this, (InteractionHand)hand, graphics, (GunHudCache)cache, GunHudEvent.Phase.START))) {
                    this.renderAmmoCounter(graphics, (GunHudCache)cache, heldItem, x, height);
                    MinecraftForge.EVENT_BUS.post((Event)new GunHudEvent(this, (InteractionHand)hand, graphics, (GunHudCache)cache, GunHudEvent.Phase.END));
                }
            }
        });
    }

    private static boolean shouldRender(InteractionHand hand, LocalPlayer player) {
        return hand == InteractionHand.MAIN_HAND || GunModifierHelper.canRenderInOffhand((LivingEntity)player);
    }

    protected void renderAmmoCounter(GuiGraphics graphics, GunHudCache handCache, ItemStack stack, int x, int y) {
        if (!GunModifierHelper.shouldRenderHud(new GunData(stack, (LivingEntity)this.minecraft.f_91074_))) {
            return;
        }
        String currentAmmoCountText = CURRENT_AMMO_FORMAT.format(handCache.ammoCount);
        PoseStack poseStack = graphics.m_280168_();
        this.renderCurrentAmmo(graphics, handCache, x - 70, y - 43, poseStack, currentAmmoCountText);
        Figures.drawLine(graphics, x - 70, y - 30, 27, 2, GunHud.toRgba(this.colors.hud));
        this.renderInventoryAmmo(graphics, handCache, x - 67, y - 26, poseStack, this.minecraft.f_91062_);
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float[] iconColor = GunHud.rgbToFloatRgba(this.colors.hud);
        RenderSystem.setShaderColor((float)iconColor[0], (float)iconColor[1], (float)iconColor[2], (float)iconColor[3]);
        this.renderFireModeIcon(graphics, handCache, x, y, currentAmmoCountText);
        this.renderAmmoTypeIcon(graphics, handCache, x, y, currentAmmoCountText);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderFuelCounters(graphics, stack, x - 70, y - 57);
    }

    protected void renderFuelCounters(GuiGraphics graphics, ItemStack stack, int x, int y) {
        GunData gunData = new GunData(stack, (LivingEntity)this.minecraft.f_91074_);
        Set<FuelType> allFuel = GunModifierHelper.getFuelTypes(gunData);
        int barOffsetY = 0;
        for (FuelType fuelType : allFuel) {
            this.renderFuelCounter(graphics, stack, fuelType, x, y - barOffsetY);
            barOffsetY += 18;
        }
    }

    protected void renderFuelCounter(GuiGraphics graphics, ItemStack stack, FuelType fuelType, int x, int y) {
        GunData gunData = new GunData(stack, (LivingEntity)this.minecraft.f_91074_);
        float fuelPercent = FuelUtils.getFuelPercent(stack, fuelType, gunData);
        this.renderIcon(graphics, fuelType.getIcon(), x - 18, y - 4);
        Figures.drawBar(graphics, x, y, 35, 6, fuelPercent);
    }

    protected void renderCurrentAmmo(GuiGraphics graphics, GunHudCache handCache, int x, int y, PoseStack poseStack, String currentAmmoCountText) {
        int ammoCountColor = (double)handCache.ammoCount < (double)handCache.maxAmmoCount * 0.25 ? this.colors.lowAmmo : this.colors.currentAmmo;
        poseStack.m_85836_();
        float scale = 1.5f;
        poseStack.m_85841_(scale, scale, 1.0f);
        graphics.drawString(this.minecraft.f_91062_, currentAmmoCountText, (float)x / scale, (float)y / scale, ammoCountColor, true);
        poseStack.m_85849_();
    }

    protected void renderInventoryAmmo(GuiGraphics graphics, GunHudCache handCache, int x, int y, PoseStack poseStack, Font font) {
        String inventoryAmmoCountText = INVENTORY_AMMO_FORMAT.format(handCache.inventoryAmmoCount);
        poseStack.m_85836_();
        poseStack.m_85841_(0.9f, 0.9f, 1.0f);
        graphics.drawString(font, inventoryAmmoCountText, (float)x / 0.9f, (float)y / 0.9f, this.colors.inventoryAmmo, true);
        poseStack.m_85849_();
    }

    protected void renderFireModeIcon(GuiGraphics graphics, GunHudCache handCache, int width, int height, String currentAmmoCountText) {
        FireMode fireMode = handCache.fireMode;
        ResourceLocation icon = fireMode.getIcon();
        double textWidth = (double)this.minecraft.f_91062_.m_92895_(currentAmmoCountText) * 1.5;
        int x = (int)((double)(width - this.getIconX(handCache, textWidth)) + textWidth);
        this.renderIcon(graphics, icon, x, height - 46);
    }

    protected void renderAmmoTypeIcon(GuiGraphics graphics, GunHudCache handCache, int width, int height, String currentAmmoCountText) {
        AmmoType ammoType = handCache.ammoType;
        ResourceLocation icon = ammoType.getIcon();
        double textWidth = (double)this.minecraft.f_91062_.m_92895_(currentAmmoCountText) * 1.5;
        int x = (int)((double)(width - this.getIconX(handCache, textWidth)) + textWidth);
        this.renderIcon(graphics, icon, x, height - 32);
    }

    protected void renderIcon(GuiGraphics graphics, ResourceLocation icon, int x, int y) {
        graphics.m_280163_(icon, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    protected int getIconX(GunHudCache handCache, double textWidth) {
        if (handCache.hand == InteractionHand.OFF_HAND) {
            return 115 - (int)textWidth - 20;
        }
        return 115;
    }

    protected void updateCache(GunHudCache handCache, LocalPlayer player, ItemStack stack) {
        if (System.currentTimeMillis() - handCache.checkAmmoTimestamp > 200L) {
            GunData data = new GunData(stack, (LivingEntity)player);
            handCache.checkAmmoTimestamp = System.currentTimeMillis();
            handCache.maxAmmoCount = GunModifierHelper.getMaxAmmo(data);
            handCache.fireMode = GunStateHelper.getFireMode(data);
            handCache.ammoType = GunStateHelper.getAmmoType(data);
            handCache.ammoCount = Gun.getAmmo(stack);
            handCache.inventoryAmmoCount = !player.m_7500_() ? this.getInventoryAmmoCount(stack, player.m_150109_()) : 9999;
        }
    }

    protected int getInventoryAmmoCount(ItemStack stack, Inventory inventory) {
        int inventoryAmmoCount = 0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            GunData gunData = new GunData(stack, (LivingEntity)this.minecraft.f_91074_);
            ItemStack inventoryStack = inventory.m_8020_(i);
            Item inventoryItem = inventoryStack.m_41720_();
            if (GunStateHelper.isCurrentAmmo(gunData, inventoryItem)) {
                inventoryAmmoCount += inventoryStack.m_41613_();
                continue;
            }
            if (!(inventoryItem instanceof AmmoBoxItem)) continue;
            AmmoBoxItem iAmmoBox = (AmmoBoxItem)inventoryItem;
            Item currentAmmo = GunStateHelper.getAmmoItem(gunData);
            inventoryAmmoCount += iAmmoBox.getAmmoCount(inventoryStack, currentAmmo);
        }
        return inventoryAmmoCount;
    }

    public record Colors(int hud, int inventoryAmmo, int currentAmmo, int lowAmmo) {
    }
}

