/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.core.other;

import com.teamabnormals.caverns_and_chasms.core.other.tags.CCBiomeTags;
import com.teamabnormals.caverns_and_chasms.core.registry.CCBiomeModifierTypes;
import com.teamabnormals.caverns_and_chasms.core.registry.CCEntityTypes;
import com.teamabnormals.caverns_and_chasms.core.registry.CCFeatures;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;

public class CCBiomeModifiers {
    public static void bootstrap(BootstapContext<BiomeModifier> context) {
        CCBiomeModifiers.addSpawn(context, "mime", CCBiomeTags.HAS_MIME, new MobSpawnSettings.SpawnerData((EntityType)CCEntityTypes.MIME.get(), 100, 1, 1));
        CCBiomeModifiers.addSpawn(context, "glare", CCBiomeTags.HAS_GLARE, new MobSpawnSettings.SpawnerData((EntityType)CCEntityTypes.GLARE.get(), 20, 1, 1));
        CCBiomeModifiers.addSpawn(context, "lost_goat", CCBiomeTags.HAS_LOST_GOAT, new MobSpawnSettings.SpawnerData((EntityType)CCEntityTypes.LOST_GOAT.get(), 1, 1, 1));
        CCBiomeModifiers.addFeature(context, "base_ores", (TagKey<Biome>)BiomeTags.f_215817_, GenerationStep.Decoration.UNDERGROUND_ORES, CCFeatures.CCPlacedFeatures.ORE_GOLD_AND_SILVER_LOWER, CCFeatures.CCPlacedFeatures.ORE_SPINEL_BURIED);
        CCBiomeModifiers.addFeature(context, "spinel_ore", CCBiomeTags.HAS_SPINEL_ORE, GenerationStep.Decoration.UNDERGROUND_ORES, CCFeatures.CCPlacedFeatures.ORE_SPINEL);
        CCBiomeModifiers.addFeature(context, "silver_ore", CCBiomeTags.HAS_SILVER_ORE, GenerationStep.Decoration.UNDERGROUND_ORES, CCFeatures.CCPlacedFeatures.ORE_SILVER_BURIED_WITH_GOLD);
        CCBiomeModifiers.addFeatureBlacklisted(context, "gold_ore", CCBiomeTags.HAS_SILVER_ORE, (TagKey<Biome>)BiomeTags.f_215817_, GenerationStep.Decoration.UNDERGROUND_ORES, CCFeatures.CCPlacedFeatures.ORE_GOLD_BURIED_WITH_SILVER);
        CCBiomeModifiers.addFeature(context, "extra_silver_ore", CCBiomeTags.HAS_EXTRA_SILVER_ORE, GenerationStep.Decoration.UNDERGROUND_ORES, CCFeatures.CCPlacedFeatures.ORE_SILVER_EXTRA);
        CCBiomeModifiers.addFeature(context, "soul_silver_ore", CCBiomeTags.HAS_SOUL_SILVER_ORE, GenerationStep.Decoration.UNDERGROUND_ORES, CCFeatures.CCPlacedFeatures.ORE_SILVER_SOUL);
        CCBiomeModifiers.addFeature(context, "rocky_dirt", CCBiomeTags.HAS_ROCKY_DIRT, GenerationStep.Decoration.UNDERGROUND_ORES, CCFeatures.CCPlacedFeatures.ORE_ROCKY_DIRT);
        CCBiomeModifiers.addFeature(context, "fragile_stone", CCBiomeTags.HAS_FRAGILE_STONE, GenerationStep.Decoration.UNDERGROUND_ORES, CCFeatures.CCPlacedFeatures.ORE_FRAGILE_STONE, CCFeatures.CCPlacedFeatures.ORE_FRAGILE_STONE_BURIED);
        CCBiomeModifiers.removeFeature(context, "gold_ore", (TagKey<Biome>)BiomeTags.f_215817_, GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.f_195338_, OrePlacements.f_195339_);
        CCBiomeModifiers.removeFeature(context, "dirt_ore", CCBiomeTags.HAS_ROCKY_DIRT, GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.f_195323_);
    }

    @SafeVarargs
    private static void removeFeature(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, GenerationStep.Decoration step, ResourceKey<PlacedFeature> ... features) {
        CCBiomeModifiers.register(context, "remove_feature/" + name, () -> new ForgeBiomeModifiers.RemoveFeaturesBiomeModifier((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(biomes), CCBiomeModifiers.featureSet(context, features), Set.of(step)));
    }

    @SafeVarargs
    private static void addFeature(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, GenerationStep.Decoration step, ResourceKey<PlacedFeature> ... features) {
        CCBiomeModifiers.register(context, "add_feature/" + name, () -> new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(biomes), CCBiomeModifiers.featureSet(context, features), step));
    }

    @SafeVarargs
    private static void addFeatureBlacklisted(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, TagKey<Biome> blacklistedBiomes, GenerationStep.Decoration step, ResourceKey<PlacedFeature> ... features) {
        CCBiomeModifiers.register(context, "add_feature/" + name, () -> new CCBiomeModifierTypes.BlacklistedAddFeaturesBiomeModifier((HolderSet<Biome>)context.m_255420_(Registries.f_256952_).m_254956_(biomes), (HolderSet<Biome>)context.m_255420_(Registries.f_256952_).m_254956_(blacklistedBiomes), CCBiomeModifiers.featureSet(context, features), step));
    }

    private static void addSpawn(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, MobSpawnSettings.SpawnerData ... spawns) {
        CCBiomeModifiers.register(context, "add_spawn/" + name, () -> new ForgeBiomeModifiers.AddSpawnsBiomeModifier((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(biomes), List.of(spawns)));
    }

    private static void addSpawnBlackListed(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, TagKey<Biome> blacklistedBiomes, MobSpawnSettings.SpawnerData ... spawns) {
        CCBiomeModifiers.register(context, "add_spawn/" + name, () -> new CCBiomeModifierTypes.BlacklistedAddSpawnsBiomeModifier((HolderSet<Biome>)context.m_255420_(Registries.f_256952_).m_254956_(biomes), (HolderSet<Biome>)context.m_255420_(Registries.f_256952_).m_254956_(blacklistedBiomes), List.of(spawns)));
    }

    private static void removeSpawn(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, EntityType<?> ... types) {
        CCBiomeModifiers.register(context, "remove_spawn/" + name, () -> new ForgeBiomeModifiers.RemoveSpawnsBiomeModifier((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(biomes), (HolderSet)HolderSet.m_205800_(Stream.of(types).map(type -> (Holder)ForgeRegistries.ENTITY_TYPES.getHolder(type).get()).collect(Collectors.toList()))));
    }

    private static void register(BootstapContext<BiomeModifier> context, String name, Supplier<? extends BiomeModifier> modifier) {
        context.m_255272_(ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("caverns_and_chasms", name)), (Object)modifier.get());
    }

    @SafeVarargs
    private static HolderSet<PlacedFeature> featureSet(BootstapContext<?> context, ResourceKey<PlacedFeature> ... features) {
        return HolderSet.m_205800_(Stream.of(features).map(placedFeatureKey -> context.m_255420_(Registries.f_256988_).m_255043_(placedFeatureKey)).collect(Collectors.toList()));
    }
}

