/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.common.entity;

import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.caverns_and_chasms.core.other.CCDataProcessors;
import com.teamabnormals.caverns_and_chasms.core.registry.CCParticleTypes;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;

public interface ControllableGolem {
    default public boolean canBeTuningForkControlled(Player player) {
        return true;
    }

    default public void onTuningForkControlStart(Player player) {
    }

    default public void onTuningForkControlEnd(Player player) {
    }

    default public void tungingForkControlTick() {
        Mob mob = (Mob)this;
        if (mob.m_9236_().m_5776_() && mob.m_6084_() && mob.f_19797_ % 20 == 0) {
            RandomSource random = mob.m_217043_();
            mob.m_9236_().m_7106_((ParticleOptions)CCParticleTypes.GOLEM_NOTE.get(), mob.m_20185_() + random.m_188500_() * 0.8 - 0.4, mob.m_20188_() + random.m_188500_() * 0.8 - 0.4, mob.m_20189_() + random.m_188500_() * 0.8 - 0.4, 0.0, 0.0, 0.0);
        }
    }

    default public boolean shouldMoveToTuningForkPos(BlockPos pos, Player player) {
        return true;
    }

    default public boolean shouldAttackTuningForkTarget(LivingEntity target, Player player) {
        return false;
    }

    default public void setBeingTuningForkControlled(boolean controlled) {
        IDataManager data = (IDataManager)this;
        data.setValue(CCDataProcessors.IS_BEING_CONTROLLED, (Object)controlled);
    }

    default public boolean isBeingTuningForkControlled() {
        return (Boolean)((IDataManager)this).getValue(CCDataProcessors.IS_BEING_CONTROLLED);
    }

    default public void setTuningForkPos(BlockPos pos) {
        ((IDataManager)this).setValue(CCDataProcessors.TUNING_FORK_POS, pos != null ? Optional.of(pos) : Optional.empty());
    }

    default public BlockPos getTuningForkPos() {
        IDataManager data = (IDataManager)this;
        if (((Optional)data.getValue(CCDataProcessors.TUNING_FORK_POS)).isPresent()) {
            return (BlockPos)((Optional)data.getValue(CCDataProcessors.TUNING_FORK_POS)).get();
        }
        return null;
    }

    default public void setTuningForkTarget(LivingEntity target) {
        ((IDataManager)this).setValue(CCDataProcessors.TUNING_FORK_TARGET_UUID, target != null ? Optional.of(target.m_20148_()) : Optional.empty());
    }

    default public boolean isTuningForkTarget(LivingEntity target) {
        IDataManager data = (IDataManager)this;
        if (((Optional)data.getValue(CCDataProcessors.TUNING_FORK_TARGET_UUID)).isPresent()) {
            return target.m_20148_() == ((Optional)data.getValue(CCDataProcessors.TUNING_FORK_TARGET_UUID)).get();
        }
        return false;
    }

    default public Player getTuningForkController() {
        for (Player player : ((Mob)this).m_9236_().m_6907_()) {
            if (!this.isTuningForkControlledBy(player)) continue;
            return player;
        }
        return null;
    }

    default public boolean isTuningForkControlledBy(Player player) {
        Optional uuid = (Optional)((IDataManager)player).getValue(CCDataProcessors.CONTROLLED_GOLEM_UUID);
        return uuid.isPresent() && uuid.get() == ((Mob)this).m_20148_();
    }
}

