/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.util;

import com.mojang.datafixers.util.Pair;
import com.ordana.immersive_weathering.util.Weatherable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public interface PatchSpreader<T extends Enum<?>> {
    public Class<T> getType();

    default public boolean getWantedWeatheringState(boolean hasTicked, BlockPos pos, Level level, int maxRecursion) {
        Random posRandom = new Random(Mth.m_14057_((Vec3i)pos));
        double v = this.getUnWeatherableChance(level, pos);
        Map<Direction, Susceptibility> directions = this.getInfluenceForDirections(posRandom, pos, level);
        ArrayList<WeatheringAgent> weatheringAgents = new ArrayList<WeatheringAgent>();
        boolean needsAir = this.needsAirToSpread(level, pos);
        boolean hasAir = false;
        boolean shouldAlwaysWeather = false;
        for (Map.Entry<Direction, Susceptibility> e : directions.entrySet()) {
            BlockPos facingPos = pos.m_121945_(e.getKey());
            BlockState facingState = level.m_8055_(facingPos);
            if (!hasAir && needsAir) {
                hasAir = !facingState.m_60796_((BlockGetter)level, pos);
            }
            Pair<WeatheringAgent, Boolean> pair = this.getBlockWeatheringEffect(e.getValue(), facingState, level, facingPos, maxRecursion);
            weatheringAgents.add((WeatheringAgent)((Object)pair.getFirst()));
            if (!((Boolean)pair.getSecond()).booleanValue()) continue;
            shouldAlwaysWeather = true;
            needsAir = false;
        }
        if (needsAir && !hasAir) {
            return false;
        }
        if (hasTicked && (double)posRandom.nextFloat() < this.getUnWeatherableChance(level, pos)) {
            return false;
        }
        boolean oneSuccess = false;
        for (WeatheringAgent w : weatheringAgents) {
            if (w == WeatheringAgent.PREVENT_WEATHERING) {
                return false;
            }
            if (w != WeatheringAgent.WEATHER) continue;
            oneSuccess = true;
        }
        return oneSuccess;
    }

    default public boolean getWantedWeatheringState(boolean hasTicked, BlockPos pos, Level level) {
        return this.getWantedWeatheringState(hasTicked, pos, level, 2);
    }

    @Deprecated
    default public Map<Direction, Susceptibility> getInfluenceForDirectionsOld(BlockPos pos, Level level) {
        Random posRandom = new Random(Mth.m_14057_((Vec3i)pos));
        HashMap<Direction, Susceptibility> directions = new HashMap<Direction, Susceptibility>();
        double directionChance = this.getInterestForDirection(level, pos);
        double highInterestChange = this.getDisjointGrowthChance(level, pos);
        for (Direction d : Direction.values()) {
            if (!((double)posRandom.nextFloat() < directionChance)) continue;
            Susceptibility in = (double)posRandom.nextFloat() < highInterestChange ? Susceptibility.HIGH : Susceptibility.MEDIUM;
            directions.put(d, in);
        }
        return directions;
    }

    default public Map<Direction, Susceptibility> getInfluenceForDirections(Random posRandom, BlockPos pos, Level level) {
        HashMap<Direction, Susceptibility> directions = new HashMap<Direction, Susceptibility>();
        double directionChance = this.getInterestForDirection(level, pos);
        double highInterestChance = this.getDisjointGrowthChance(level, pos);
        int wantedDirs = this.getDirectionCount(posRandom, (float)directionChance);
        ArrayList<Direction> dirs = new ArrayList<Direction>(List.of(Direction.values()));
        Collections.shuffle(dirs, posRandom);
        for (int i = 0; i < dirs.size(); ++i) {
            Susceptibility sus = i < wantedDirs ? ((double)posRandom.nextFloat() < highInterestChance ? Susceptibility.HIGH : Susceptibility.MEDIUM) : Susceptibility.LOW;
            directions.put((Direction)dirs.get(i), sus);
        }
        return directions;
    }

    default public int getDirectionCount(Random random, float a) {
        int n = 6;
        float[] values = new float[7];
        for (int x = 0; x <= 6; ++x) {
            values[x] = -0.023809524f * ((float)x * (12.0f * a - 2.0f * a - 12.0f + 1.0f) + (float)(x * x) * (1.0f - 2.0f * a) + (2.0f * a * 6.0f - 12.0f));
        }
        float r = random.nextFloat();
        for (int i = 0; i < values.length; ++i) {
            if (!(r < values[i])) continue;
            return i;
        }
        return 0;
    }

    public double getInterestForDirection(Level var1, BlockPos var2);

    public double getDisjointGrowthChance(Level var1, BlockPos var2);

    default public Pair<WeatheringAgent, Boolean> getBlockWeatheringEffect(Susceptibility sus, BlockState state, Level level, BlockPos pos, int maxRecursion) {
        WeatheringAgent effect = WeatheringAgent.NONE;
        boolean alwaysWeather = false;
        if (sus.value >= Susceptibility.HIGH.value) {
            effect = this.getLowInfluenceWeatheringEffect(state, level, pos, maxRecursion);
        }
        if (effect == WeatheringAgent.NONE && sus.value >= Susceptibility.MEDIUM.value) {
            effect = this.getWeatheringEffect(state, level, pos);
        }
        if (effect == WeatheringAgent.NONE && sus.value >= Susceptibility.LOW.value && (effect = this.getHighInfluenceWeatheringEffect(state, level, pos)) == WeatheringAgent.WEATHER) {
            alwaysWeather = true;
        }
        return Pair.of((Object)((Object)effect), (Object)alwaysWeather);
    }

    default public WeatheringAgent getHighInfluenceWeatheringEffect(BlockState state, Level level, BlockPos pos) {
        return WeatheringAgent.NONE;
    }

    default public WeatheringAgent getLowInfluenceWeatheringEffect(BlockState state, Level level, BlockPos pos, int maxRecursion) {
        PatchSpreader p;
        Weatherable w;
        Block b = state.m_60734_();
        if (maxRecursion > 0 && b instanceof Weatherable && (w = (Weatherable)b).isWeathering(state) && (p = (PatchSpreader)w.getPatchSpreader(this.getType()).orElse(null)) != null && p.getWantedWeatheringState(false, pos, level, maxRecursion - 1)) {
            return WeatheringAgent.WEATHER;
        }
        return WeatheringAgent.NONE;
    }

    public WeatheringAgent getWeatheringEffect(BlockState var1, Level var2, BlockPos var3);

    public double getUnWeatherableChance(Level var1, BlockPos var2);

    default public boolean needsAirToSpread(Level level, BlockPos pos) {
        return false;
    }

    public static enum Susceptibility {
        LOW(1),
        MEDIUM(2),
        HIGH(3);

        private final int value;

        private Susceptibility(int effect) {
            this.value = effect;
        }
    }

    public static enum WeatheringAgent {
        NONE,
        WEATHER,
        PREVENT_WEATHERING;

    }
}

