/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.fluid_generators;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.ordana.immersive_weathering.ImmersiveWeathering;
import com.ordana.immersive_weathering.data.fluid_generators.IFluidGenerator;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import net.mehvahdjukaar.moonlight.api.misc.RegistryAccessJsonReloadListener;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class FluidGeneratorsHandler
extends RegistryAccessJsonReloadListener {
    public static final ImmutableList<Direction> POSSIBLE_FLOW_DIRECTIONS = ImmutableList.of((Object)Direction.DOWN, (Object)Direction.SOUTH, (Object)Direction.NORTH, (Object)Direction.EAST, (Object)Direction.WEST);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final FluidGeneratorsHandler RELOAD_INSTANCE = new FluidGeneratorsHandler();
    private static final Map<Fluid, ImmutableList<IFluidGenerator>> STILL_GENERATORS = new Object2ObjectOpenHashMap();
    private static final Map<Fluid, ImmutableList<IFluidGenerator>> FLOWING_GENERATORS = new Object2ObjectOpenHashMap();
    private static final Set<Fluid> HAS_GENERATOR = new HashSet<Fluid>();

    public FluidGeneratorsHandler() {
        super(GSON, "fluid_generators");
    }

    public void parse(Map<ResourceLocation, JsonElement> jsonMap, RegistryAccess registryAccess) {
        HashMap<ResourceLocation, JsonElement> map = new HashMap<ResourceLocation, JsonElement>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsonMap.entrySet()) {
            map.put(entry.getKey(), entry.getValue().deepCopy());
        }
        ArrayList generators = new ArrayList();
        for (Map.Entry entry : map.entrySet()) {
            JsonElement json = (JsonElement)entry.getValue();
            DataResult result = IFluidGenerator.CODEC.parse((DynamicOps)RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess), (Object)json);
            Optional o = result.resultOrPartial(error -> ImmersiveWeathering.LOGGER.error("Failed to read liquid generator JSON object for {} : {}", e3.getKey(), error));
            o.ifPresent(generators::add);
        }
        ImmersiveWeathering.LOGGER.info("Loaded {} liquid generators configurations", (Object)map.size());
        STILL_GENERATORS.clear();
        FLOWING_GENERATORS.clear();
        HAS_GENERATOR.clear();
        HashMap<Fluid, List> hashMap = new HashMap<Fluid, List>();
        HashMap<Fluid, List> hashMap2 = new HashMap<Fluid, List>();
        for (IFluidGenerator g : generators) {
            List list;
            HAS_GENERATOR.add(g.getFluid());
            if (g.getFluidType().isFlowing()) {
                list = hashMap.computeIfAbsent(g.getFluid(), e -> new ArrayList());
                list.add(g);
                Collections.sort(list);
            }
            if (!g.getFluidType().isStill()) continue;
            list = hashMap2.computeIfAbsent(g.getFluid(), e -> new ArrayList());
            list.add(g);
            Collections.sort(list);
        }
        hashMap.forEach((key, value) -> FLOWING_GENERATORS.put((Fluid)key, (ImmutableList<IFluidGenerator>)ImmutableList.copyOf((Collection)value)));
        hashMap2.forEach((key, value) -> STILL_GENERATORS.put((Fluid)key, (ImmutableList<IFluidGenerator>)ImmutableList.copyOf((Collection)value)));
    }

    public static Optional<Pair<BlockPos, @Nullable SoundEvent>> applyGenerators(FlowingFluid fluid, List<Direction> possibleFlowDir, BlockPos pos, Level level) {
        Fluid source = fluid.m_5613_();
        if (HAS_GENERATOR.contains(source)) {
            ImmutableList<IFluidGenerator> list = level.m_6425_(pos).m_76170_() ? STILL_GENERATORS.get(source) : FLOWING_GENERATORS.get(source);
            return FluidGeneratorsHandler.generate(possibleFlowDir, pos, level, list);
        }
        return Optional.empty();
    }

    private static Optional<Pair<BlockPos, @Nullable SoundEvent>> generate(List<Direction> possibleFlowDir, BlockPos pos, Level level, ImmutableList<IFluidGenerator> list) {
        if (list != null && !list.isEmpty() && PlatHelper.isAreaLoaded((LevelReader)level, (BlockPos)pos, (int)3)) {
            EnumMap<Direction, BlockState> neighborCache = new EnumMap<Direction, BlockState>(Direction.class);
            for (IFluidGenerator generator : list) {
                Optional<BlockPos> res = generator.tryGenerating(possibleFlowDir, pos, level, neighborCache);
                if (!res.isPresent()) continue;
                return res.map(a -> Pair.of((Object)a, (Object)generator.getSound()));
            }
        }
        return Optional.empty();
    }

    public void saveGeneartor(IFluidGenerator song) {
        File folder = PlatHelper.getGamePath().resolve("test").toFile();
        if (!folder.exists()) {
            folder.mkdir();
        }
        File exportPath = new File(folder, "template.json");
        try (FileWriter writer = new FileWriter(exportPath);){
            this.writeToFile(song, writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeToFile(IFluidGenerator obj, FileWriter writer) {
        DataResult r = IFluidGenerator.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)obj);
        r.result().ifPresent(a -> GSON.toJson((JsonElement)this.sortJson(a.getAsJsonObject()), (Appendable)writer));
    }

    private JsonObject sortJson(JsonObject jsonObject) {
        try {
            TreeMap<String, JsonElement> joToMap = new TreeMap<String, JsonElement>();
            jsonObject.entrySet().forEach(e -> {
                JsonElement j = (JsonElement)e.getValue();
                if (j instanceof JsonObject) {
                    JsonObject jo = (JsonObject)j;
                    j = this.sortJson(jo);
                }
                joToMap.put((String)e.getKey(), j);
            });
            JsonObject sortedJSON = new JsonObject();
            joToMap.forEach((arg_0, arg_1) -> ((JsonObject)sortedJSON).add(arg_0, arg_1));
            return sortedJSON;
        }
        catch (Exception exception) {
            return jsonObject;
        }
    }
}

