/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.block_growths.growths.builtin;

import com.ordana.immersive_weathering.blocks.LayerBlock;
import com.ordana.immersive_weathering.blocks.sandy.Sandy;
import com.ordana.immersive_weathering.data.block_growths.TickSource;
import com.ordana.immersive_weathering.data.block_growths.growths.builtin.BuiltinBlockGrowth;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class SandLayerGrowth
extends BuiltinBlockGrowth {
    protected SandLayerGrowth(String name, @Nullable HolderSet<Block> owners, List<TickSource> sources, float chance) {
        super(name, owners, sources, chance);
    }

    int getAge(BlockState state) {
        return (Integer)state.m_61143_((Property)this.getAgeProperty());
    }

    IntegerProperty getAgeProperty() {
        return LayerBlock.LAYERS_8;
    }

    @Override
    public void tryGrowing(BlockPos pos, BlockState state, ServerLevel level, Supplier<Holder<Biome>> biome) {
        if (this.growthChance != 1.0f && !(level.f_46441_.m_188501_() < this.growthChance)) {
            return;
        }
        BlockPos belowPos = pos.m_7495_();
        BlockState belowState = level.m_8055_(belowPos);
        Optional<BlockState> sandyBlock = Sandy.getSandy(belowState);
        if ((Integer)state.m_61143_((Property)LayerBlock.LAYERS_8) > 1 && sandyBlock.isPresent()) {
            RandomSource random = level.f_46441_;
            int rand = random.m_188503_(2);
            int rand2 = random.m_188503_(5);
            level.m_46597_(belowPos, (BlockState)((BlockState)sandyBlock.get().m_61124_((Property)Sandy.SANDINESS, (Comparable)Integer.valueOf(rand))).m_61124_((Property)Sandy.SAND_AGE, (Comparable)Integer.valueOf(rand2)));
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)LayerBlock.LAYERS_8, (Comparable)Integer.valueOf(this.getAge(state) - 1)));
        }
    }
}

