/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.savage_and_ravage.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.teamabnormals.savage_and_ravage.client.model.GrieferArmorModel;
import com.teamabnormals.savage_and_ravage.common.item.BlastProofArmorType;
import com.teamabnormals.savage_and_ravage.core.registry.SRAttributes;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class GrieferArmorItem
extends ArmorItem {
    public GrieferArmorItem(ArmorMaterial material, ArmorItem.Type slot, Item.Properties properties) {
        super(material, slot, properties);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(super.getAttributeModifiers(slot, stack));
        UUID uuid = (UUID)ArmorItem.f_265987_.get(this.f_265916_);
        builder.put((Object)((Attribute)SRAttributes.EXPLOSIVE_DAMAGE_REDUCTION.get()), (Object)new AttributeModifier(uuid, "Blast proof", (double)BlastProofArmorType.slotToType(slot).getReductionAmount(), AttributeModifier.Operation.ADDITION));
        return slot == this.m_40402_() ? builder.build() : super.getAttributeModifiers(slot, stack);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "savage_and_ravage:textures/models/armor/griefer_armor.png";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entity, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> properties) {
                return GrieferArmorModel.getModel(slot, entity);
            }
        });
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return true;
    }
}

