/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.common_classes;

import com.mojang.datafixers.util.Pair;
import java.util.Map;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class TagUtility {
    public static final ResourceLocation SILICA_TAG = PlatHelper.getPlatform().isFabric() ? TagUtility.fabricTag("silica_glass") : TagUtility.forgeTag("silica");
    public static final ResourceLocation GLASS_TAG = PlatHelper.getPlatform().isFabric() ? TagUtility.fabricTag("glass_blocks") : TagUtility.forgeTag("glass");
    public static final ResourceLocation GLASS_PANE_TAG = TagUtility.commonTag("glass_panes");
    public static final ResourceLocation GLASS_COLORLESS_TAG = PlatHelper.getPlatform().isFabric() ? TagUtility.fabricTag("colorless_glass") : TagUtility.forgeTag("glass/colorless");
    public static final ResourceLocation GLASS_PANE_COLORLESS_TAG = PlatHelper.getPlatform().isFabric() ? TagUtility.fabricTag("colorless_glass_panes") : TagUtility.forgeTag("glass_panes/colorless");

    public static ResourceLocation getATagOrCreateANew(String suffixTag, String suffixAlt, BlockType blockType, ResourceSink sink, ResourceManager manager) {
        String resLocMOD = blockType.getNamespace() + ":" + blockType.getTypeName();
        ResourceLocation RLocLogs = new ResourceLocation(resLocMOD + "_" + suffixTag);
        ResourceLocation RLocStems = new ResourceLocation(resLocMOD + "_" + suffixAlt);
        ResourceLocation RLocFolders = new ResourceLocation(blockType.getNamespace() + ":" + suffixTag + "/" + blockType.getTypeName());
        ResourceLocation RLocEC = EveryCompat.res(blockType.getAppendableId() + "_" + suffixTag);
        if (TagUtility.doTagExistFor(RLocLogs, manager)) {
            return RLocLogs;
        }
        if (TagUtility.doTagExistFor(RLocStems, manager)) {
            return RLocStems;
        }
        if (TagUtility.doTagExistFor(RLocEC, manager)) {
            return RLocEC;
        }
        if (TagUtility.doTagExistFor(RLocFolders, manager)) {
            return RLocFolders;
        }
        TagUtility.createAndAddDefaultTags(RLocEC, sink, blockType, new Block[0]);
        return RLocEC;
    }

    public static boolean createAndAddDefaultTags(ResourceLocation resLoc, ResourceSink sink, BlockType blockType, Block ... blocks) {
        if (blockType instanceof WoodType) {
            WoodType woodType = (WoodType)blockType;
            return TagUtility.createAndAddCustomTags(resLoc, sink, woodType.log, woodType.getBlockOfThis("stripped_log"), woodType.getBlockOfThis("wood"), woodType.getBlockOfThis("stripped_wood"));
        }
        return TagUtility.createAndAddCustomTags(resLoc, sink, blocks);
    }

    public static boolean createAndAddCustomTags(ResourceLocation resLoc, ResourceSink sink, Block ... blocks) {
        boolean isTagCreated = false;
        SimpleTagBuilder tagBuilder = SimpleTagBuilder.of((ResourceLocation)resLoc);
        for (Block block : blocks) {
            if (block == null) continue;
            tagBuilder.addEntry((Object)block);
            isTagCreated = true;
        }
        if (isTagCreated) {
            sink.addTag(tagBuilder, Registries.f_256747_);
            sink.addTag(tagBuilder, Registries.f_256913_);
        }
        return isTagCreated;
    }

    public static boolean createAndAddCustomTags(ResourceLocation resLoc, ResourceSink sink, Item ... items) {
        boolean isTagCreated = false;
        SimpleTagBuilder tagBuilder = SimpleTagBuilder.of((ResourceLocation)resLoc);
        for (Item item : items) {
            if (item == null) continue;
            tagBuilder.addEntry((Object)item);
            isTagCreated = true;
        }
        if (isTagCreated) {
            sink.addTag(tagBuilder, Registries.f_256913_);
        }
        return isTagCreated;
    }

    public static <T extends BlockType, B extends Block> void addTagToAllBlocks(Map<T, B> blocks, String nameStone, String modId, String tag, boolean includeBlock, boolean includeItem, ResourceSink pack) {
        TagUtility.addTagToAllBlocks(blocks, nameStone, modId, (TagKey<Block>)TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(tag)), includeBlock, includeItem, pack);
    }

    public static <T extends BlockType, B extends Block> void addTagToAllBlocks(Map<T, B> blocks, String nameStone, String modId, TagKey<Block> tag, boolean includeBlock, boolean includeItem, ResourceSink pack) {
        TagUtility.addTagToAllBlocks(blocks, nameStone, modId, tag, includeBlock, includeItem, pack, null);
    }

    public static <T extends BlockType, B extends Block> void addTagToAllBlocks(Map<T, B> blocks, String nameStone, String modId, TagKey<Block> tag, boolean includeBlock, boolean includeItem, ResourceSink pack, @Nullable String regexBlockId) {
        if (PlatHelper.isModLoaded((String)modId)) {
            boolean isTagCreated = false;
            SimpleTagBuilder tagBuilder = SimpleTagBuilder.of(tag);
            for (Map.Entry<T, B> entry : blocks.entrySet()) {
                BlockType stoneType = (BlockType)entry.getKey();
                Block block = (Block)entry.getValue();
                String blockPath = Utils.getID((Block)block).m_135815_();
                String blockId = blockPath.substring(blockPath.lastIndexOf("/") + 1);
                if (!stoneType.getTypeName().equals(nameStone) || regexBlockId != null && !blockId.matches(regexBlockId)) continue;
                tagBuilder.addEntry((Object)block);
                isTagCreated = true;
            }
            if (isTagCreated) {
                if (includeBlock) {
                    pack.addTag(tagBuilder, Registries.f_256747_);
                }
                if (includeItem) {
                    pack.addTag(tagBuilder, Registries.f_256913_);
                }
            }
        }
    }

    public static Pair<ResourceLocation, Boolean> getATagId(String idTag, String idAlt, ResourceManager manager) {
        ResourceLocation RLocId = new ResourceLocation(idTag);
        ResourceLocation RLocIdAlt = new ResourceLocation(idAlt);
        if (TagUtility.doTagExistFor(RLocId, manager)) {
            return Pair.of((Object)RLocId, (Object)true);
        }
        if (TagUtility.doTagExistFor(RLocIdAlt, manager)) {
            return Pair.of((Object)RLocIdAlt, (Object)true);
        }
        return Pair.of(null, (Object)false);
    }

    private static boolean doTagExistFor(ResourceLocation resLoc, ResourceManager manager) {
        boolean blockTag = manager.m_213713_(ResType.TAGS.getPath(resLoc.m_246208_("blocks/"))).isPresent();
        boolean itemTag = manager.m_213713_(ResType.TAGS.getPath(resLoc.m_246208_("items/"))).isPresent();
        return blockTag || itemTag;
    }

    private static ResourceLocation commonTag(String tagPath) {
        return PlatHelper.getPlatform().isFabric() ? new ResourceLocation("c", tagPath) : new ResourceLocation("forge", tagPath);
    }

    public static ResourceLocation fabricTag(String tagPath) {
        return new ResourceLocation("c", tagPath);
    }

    public static ResourceLocation forgeTag(String tagPath) {
        return new ResourceLocation("forge", tagPath);
    }
}

