/*
 * Decompiled with CFR 0.152.
 */
package com.gumillea.cosmopolitan.mixin;

import com.gumillea.cosmopolitan.core.util.CosmoItemTags;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;

@Mixin(value={CuttingBoardRecipe.class}, remap=false)
public class CuttingBoardRecipeMixin {
    @Unique
    private boolean hasMilk;
    @Unique
    private boolean hasCream;

    @Inject(method={"matches(Lnet/minecraftforge/items/wrapper/RecipeWrapper;Lnet/minecraft/world/level/Level;)Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void onMatches(RecipeWrapper inv, Level level, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            this.hasMilk = false;
            this.hasCream = false;
            ItemStack input = inv.m_8020_(0);
            if (!input.m_41619_()) {
                CompoundTag tag;
                if (input.m_204117_(CosmoItemTags.CONDENSED_MILK)) {
                    this.hasMilk = true;
                }
                if (input.m_204117_(CosmoItemTags.CREAM)) {
                    this.hasCream = true;
                }
                if ((tag = input.m_41783_()) != null) {
                    if (tag.m_128471_("has_condensed_milk")) {
                        this.hasMilk = true;
                    }
                    if (tag.m_128471_("has_cream")) {
                        this.hasCream = true;
                    }
                }
            }
        }
    }

    @Inject(method={"assemble(Lnet/minecraftforge/items/wrapper/RecipeWrapper;Lnet/minecraft/core/RegistryAccess;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="RETURN")}, cancellable=true)
    private void onAssemble(RecipeWrapper inv, RegistryAccess access, CallbackInfoReturnable<ItemStack> cir) {
        ItemStack result = (ItemStack)cir.getReturnValue();
        if (!result.m_41619_() && result.m_41720_().m_41472_()) {
            result = result.m_41777_();
            CompoundTag tag = result.m_41784_();
            if (this.hasMilk) {
                tag.m_128379_("has_condensed_milk", true);
            }
            if (this.hasCream) {
                tag.m_128379_("has_cream", true);
            }
            cir.setReturnValue((Object)result);
        }
    }

    @Inject(method={"rollResults(Lnet/minecraft/util/RandomSource;I)Ljava/util/List;"}, at={@At(value="RETURN")}, cancellable=true)
    private void onRollResults(RandomSource rand, int fortuneLevel, CallbackInfoReturnable<List<ItemStack>> cir) {
        List results = (List)cir.getReturnValue();
        if (!results.isEmpty()) {
            for (int i = 0; i < results.size(); ++i) {
                ItemStack stack = (ItemStack)results.get(i);
                if (stack.m_41619_() || !stack.m_41720_().m_41472_()) continue;
                ItemStack newStack = stack.m_41777_();
                CompoundTag tag = newStack.m_41784_();
                if (this.hasMilk) {
                    tag.m_128379_("has_condensed_milk", true);
                }
                if (this.hasCream) {
                    tag.m_128379_("has_cream", true);
                }
                results.set(i, newStack);
            }
            cir.setReturnValue((Object)results);
        }
    }
}

