/*
 * Decompiled with CFR 0.152.
 */
package com.gumillea.cosmopolitan.common.item;

import com.gumillea.cosmopolitan.CosmoConfig;
import com.gumillea.cosmopolitan.common.item.DrinkItem;
import com.gumillea.cosmopolitan.core.util.CosmoCompat;
import com.teamtea.eclipticseasons.common.core.SolarHolders;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;

public class SeasonalDrinkItem
extends DrinkItem {
    private final String season;
    private final boolean isSpring;
    private final boolean isSummer;
    private final boolean isAutumn;
    private final boolean isWinter;
    private final Supplier<List<MobEffectInstance>> SEASONAL_EFFECTS;

    public SeasonalDrinkItem(Item.Properties properties, boolean honey_drink, String season) {
        super(properties, honey_drink, false);
        this.season = season;
        this.isSpring = season.contains("spring");
        this.isSummer = season.contains("summer");
        this.isAutumn = season.contains("autumn");
        this.isWinter = season.contains("winter");
        this.SEASONAL_EFFECTS = () -> {
            if (this.isSpring) {
                return List.of(new MobEffectInstance(MobEffects.f_19616_, 1200, 0));
            }
            if (this.isSummer) {
                return List.of(new MobEffectInstance(MobEffects.f_19608_, 600, 0));
            }
            if (this.isAutumn) {
                return List.of(new MobEffectInstance(MobEffects.f_19621_, 1200, 0));
            }
            if (this.isWinter) {
                return List.of(new MobEffectInstance(MobEffects.f_19600_, 600, 0));
            }
            return List.of();
        };
    }

    @Override
    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity living) {
        block9: {
            ServerLevel serverLevel;
            block8: {
                if (level.m_5776_()) {
                    return stack;
                }
                if (this.isSpring || this.isSummer) {
                    living.m_20095_();
                }
                if (this.isAutumn || this.isWinter) {
                    living.m_146917_(0);
                }
                if (!(level instanceof ServerLevel)) {
                    return super.m_5922_(stack, level, living);
                }
                serverLevel = (ServerLevel)level;
                if (!CosmoCompat.ss) break block8;
                Season currentSeason = SeasonHelper.getSeasonState((Level)serverLevel).getSeason();
                Map<Season, Boolean> map = Map.of(Season.SPRING, this.isSpring, Season.SUMMER, this.isSummer, Season.AUTUMN, this.isAutumn, Season.WINTER, this.isWinter);
                if (!map.get(currentSeason).booleanValue()) break block9;
                for (MobEffectInstance effect : this.SEASONAL_EFFECTS.get()) {
                    living.m_7292_(new MobEffectInstance(effect));
                }
                break block9;
            }
            if (CosmoCompat.es) {
                com.teamtea.eclipticseasons.api.constant.solar.Season currentSeason = SolarHolders.getSaveData((Level)serverLevel).getSolarTerm().getSeason();
                Map<com.teamtea.eclipticseasons.api.constant.solar.Season, Boolean> map = Map.of(com.teamtea.eclipticseasons.api.constant.solar.Season.SPRING, this.isSpring, com.teamtea.eclipticseasons.api.constant.solar.Season.SUMMER, this.isSummer, com.teamtea.eclipticseasons.api.constant.solar.Season.AUTUMN, this.isAutumn, com.teamtea.eclipticseasons.api.constant.solar.Season.WINTER, this.isWinter);
                if (map.get(currentSeason).booleanValue()) {
                    for (MobEffectInstance effect : this.SEASONAL_EFFECTS.get()) {
                        living.m_7292_(new MobEffectInstance(effect));
                    }
                }
            }
        }
        return super.m_5922_(stack, level, living);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (!((Boolean)CosmoConfig.Client.EFFECT_TOOLTIP.get()).booleanValue()) {
            return;
        }
        if (this.isSpring || this.isSummer) {
            MutableComponent coldDrink = Component.m_237115_((String)"tooltip.cosmopolitan.seasonal_drink.when_consumed.cold");
            tooltip.add((Component)coldDrink.m_130940_(ChatFormatting.BLUE));
        } else {
            MutableComponent hotDrink = Component.m_237115_((String)"tooltip.cosmopolitan.seasonal_drink.when_consumed.hot");
            tooltip.add((Component)hotDrink.m_130940_(ChatFormatting.BLUE));
        }
        if (!CosmoCompat.ss && !CosmoCompat.es) {
            return;
        }
        MutableComponent seasonalEffect = Component.m_237115_((String)("tooltip.cosmopolitan.seasonal_drink.when_consumed.in_" + this.season));
        tooltip.add((Component)seasonalEffect.m_130940_(ChatFormatting.GRAY));
        for (MobEffectInstance effectinstance : this.SEASONAL_EFFECTS.get()) {
            MutableComponent effectDescription = Component.m_237113_((String)" ");
            MutableComponent effectName = Component.m_237115_((String)effectinstance.m_19576_());
            effectDescription.m_7220_((Component)effectName);
            MobEffect effect = effectinstance.m_19544_();
            if (effectinstance.m_19564_() > 0) {
                effectDescription.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)("potion.potency." + effectinstance.m_19564_())));
            }
            if (effectinstance.m_19557_() > 20) {
                effectDescription.m_130946_(" (").m_7220_(MobEffectUtil.m_267641_((MobEffectInstance)effectinstance, (float)1.0f)).m_130946_(")");
            }
            tooltip.add((Component)effectDescription.m_130940_(effect.m_19483_().m_19497_()));
        }
    }
}

