/*
 * Decompiled with CFR 0.152.
 */
package com.gumillea.cosmopolitan.common.fluid;

import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;

public class CosmoIceCreamFluidType
extends FluidType {
    private final ResourceLocation stillTexture;
    private final ResourceLocation flowingTexture;
    private final ResourceLocation tubStillTexture;
    private final ResourceLocation tubFlowingTexture;
    private static final ThreadLocal<Boolean> IN_TUB_CONTEXT = ThreadLocal.withInitial(() -> false);

    public CosmoIceCreamFluidType(String texture) {
        super(FluidType.Properties.create().sound(SoundActions.BUCKET_FILL, SoundEvents.f_12474_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_12482_).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.f_12474_));
        this.stillTexture = new ResourceLocation("cosmopolitan", "block/fluid/" + texture + "_ice_cream");
        this.flowingTexture = new ResourceLocation("cosmopolitan", "block/fluid/" + texture + "_ice_cream");
        this.tubStillTexture = new ResourceLocation("cosmopolitan", "block/fluid/tub/" + texture + "_ice_cream");
        this.tubFlowingTexture = new ResourceLocation("cosmopolitan", "block/fluid/tub/" + texture + "_ice_cream");
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return this.selectTexture(false);
            }

            public ResourceLocation getFlowingTexture() {
                return this.selectTexture(true);
            }

            private ResourceLocation selectTexture(boolean flowing) {
                if (CosmoIceCreamFluidType.isInTubContext()) {
                    return flowing ? CosmoIceCreamFluidType.this.tubFlowingTexture : CosmoIceCreamFluidType.this.tubStillTexture;
                }
                return flowing ? CosmoIceCreamFluidType.this.flowingTexture : CosmoIceCreamFluidType.this.stillTexture;
            }
        });
    }

    private static boolean isInTubContext() {
        return IN_TUB_CONTEXT.get();
    }

    public static void setTubContext(boolean inTub) {
        IN_TUB_CONTEXT.set(inTub);
    }
}

