/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.snowundertrees;

import bl4ckscor3.mod.snowundertrees.DynamicTreesHandler;
import bl4ckscor3.mod.snowundertrees.SnowUnderTrees;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class SnowUnderTreesFeature
extends Feature<NoneFeatureConfiguration> {
    public SnowUnderTreesFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        BlockPos pos = ctx.m_159777_();
        WorldGenLevel level = ctx.m_159774_();
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        for (int xi = 0; xi < 16; ++xi) {
            for (int zi = 0; zi < 16; ++zi) {
                BlockPos groundPos;
                int x = pos.m_123341_() + xi;
                int z = pos.m_123343_() + zi;
                mPos.m_122178_(x, level.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z) - 1, z);
                if (!level.m_8055_((BlockPos)mPos).m_204336_(BlockTags.f_13035_)) continue;
                mPos.m_122178_(x, level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z), z);
                if (SnowUnderTrees.isDynamicTreesLoaded() && (groundPos = DynamicTreesHandler.findGround(level, mPos)) == null) {
                    return false;
                }
                if (!SnowUnderTrees.placeSnow(level, (BlockPos)mPos)) continue;
                mPos.m_122173_(Direction.DOWN);
                BlockState stateBelow = level.m_8055_((BlockPos)mPos);
                if (!stateBelow.m_61138_((Property)SnowyDirtBlock.f_56637_)) continue;
                level.m_7731_((BlockPos)mPos, (BlockState)stateBelow.m_61124_((Property)SnowyDirtBlock.f_56637_, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
        return true;
    }
}

