/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.mob_jar;

import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.api.mob_jar.JarBehavior;
import com.hollingsworth.arsnouveau.api.util.LevelPosMap;
import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ars_nouveau")
public class WitherBehavior
extends JarBehavior<WitherBoss> {
    public static LevelPosMap WITHER_MAP = new LevelPosMap((level, pos) -> {
        MobJarTile mobJarTile;
        BlockEntity patt1235$temp = level.m_7702_(pos);
        return !(patt1235$temp instanceof MobJarTile) || !((mobJarTile = (MobJarTile)patt1235$temp).getEntity() instanceof WitherBoss);
    });

    @Override
    public void tick(MobJarTile tile) {
        Level level = tile.m_58904_();
        if (level == null) {
            return;
        }
        if (level.m_46467_() % 20L == 0L) {
            WITHER_MAP.addPosition(level, tile.m_58899_());
        }
    }

    @Override
    public void onRedstonePower(MobJarTile tile) {
        this.destroyBlocks(tile);
    }

    private void destroyBlocks(MobJarTile tile) {
        BlockPos pos = tile.m_58899_();
        WitherBoss entity = (WitherBoss)this.entityFromJar(tile);
        if (!ForgeEventFactory.getMobGriefingEvent((Level)tile.m_58904_(), (Entity)entity)) {
            return;
        }
        for (BlockPos block : BlockPos.m_121940_((BlockPos)pos.m_7918_(-1, -1, -1), (BlockPos)pos.m_7918_(1, 1, 1))) {
            BlockState bs;
            if (block.equals((Object)pos) || !(bs = tile.m_58904_().m_8055_(block)).canEntityDestroy((BlockGetter)tile.m_58904_(), block, (Entity)entity) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)entity, (BlockPos)block, (BlockState)bs)) continue;
            tile.m_58904_().m_46953_(block, true, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void livingDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        if (level.m_5776_() || entity instanceof IDispellable || entity instanceof ISummon) {
            return;
        }
        WITHER_MAP.applyForRange(level, entity.m_20183_(), 4.0, arg_0 -> WitherBehavior.lambda$livingDeath$1(level, (Entity)entity, arg_0));
    }

    private static /* synthetic */ Boolean lambda$livingDeath$1(Level level, Entity entity, BlockPos pos) {
        MobJarTile tile;
        BlockEntity patt2787$temp = level.m_7702_(pos);
        if (patt2787$temp instanceof MobJarTile && (tile = (MobJarTile)patt2787$temp).getEntity() instanceof WitherBoss) {
            ItemStack rose = new ItemStack((ItemLike)Items.f_41951_);
            BlockPos blockPos = entity.m_20183_();
            level.m_7967_((Entity)new ItemEntity(level, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), rose));
            return true;
        }
        return false;
    }
}

