/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.modification.selection.selectors;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Either;
import com.teamabnormals.blueprint.core.util.modification.selection.ConditionedResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.ResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.ResourceSelectorSerializers;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.FalseCondition;
import net.minecraftforge.common.crafting.conditions.ICondition;

public record ChoiceResourceSelector(ConditionedResourceSelector first, ConditionedResourceSelector second, ICondition condition) implements ResourceSelector<ChoiceResourceSelector>
{
    public ChoiceResourceSelector(ResourceSelector<?> first, ResourceSelector<?> second, ICondition condition) {
        this(new ConditionedResourceSelector(first), new ConditionedResourceSelector(second), condition);
    }

    @Override
    public Either<Set<ResourceLocation>, Predicate<ResourceLocation>> select() {
        return this.condition.test(ICondition.IContext.EMPTY) ? this.first.select() : this.second.select();
    }

    public Serializer getSerializer() {
        return ResourceSelectorSerializers.CHOICE;
    }

    public static final class Serializer
    implements ResourceSelector.Serializer<ChoiceResourceSelector> {
        @Override
        public JsonElement serialize(ChoiceResourceSelector selector) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("first", selector.first.serialize());
            jsonObject.add("second", selector.second.serialize());
            jsonObject.add("condition", (JsonElement)CraftingHelper.serialize((ICondition)selector.condition));
            return jsonObject;
        }

        @Override
        public ChoiceResourceSelector deserialize(JsonElement element) {
            ICondition condition;
            JsonObject jsonObject = element.getAsJsonObject();
            JsonObject conditionObject = GsonHelper.m_13918_((JsonElement)jsonObject.get("condition"), (String)"condition");
            try {
                condition = CraftingHelper.getCondition((JsonObject)conditionObject);
            }
            catch (JsonSyntaxException e) {
                return new ChoiceResourceSelector(ConditionedResourceSelector.EMPTY, ConditionedResourceSelector.deserialize("second", (JsonElement)GsonHelper.m_13918_((JsonElement)jsonObject.get("second"), (String)"second")), (ICondition)FalseCondition.INSTANCE);
            }
            return new ChoiceResourceSelector(ConditionedResourceSelector.deserialize("first", jsonObject.get("first")), ConditionedResourceSelector.deserialize("second", jsonObject.get("second")), condition);
        }
    }
}

