/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.blocks.rock_salt;

import com.ordana.spelunkery.blocks.rock_salt.RockSalt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RockSaltCrystalBlock
extends Block
implements SimpleWaterloggedBlock,
RockSalt {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    protected final VoxelShape northAabb;
    protected final VoxelShape southAabb;
    protected final VoxelShape eastAabb;
    protected final VoxelShape westAabb;
    protected final VoxelShape upAabb;
    protected final VoxelShape downAabb;

    public RockSaltCrystalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIGHT, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)ILLUMINATED, (Comparable)Boolean.valueOf(false)));
        this.upAabb = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0);
        this.downAabb = Block.m_49796_((double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
        this.northAabb = Block.m_49796_((double)3.0, (double)3.0, (double)4.0, (double)13.0, (double)13.0, (double)16.0);
        this.southAabb = Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)12.0);
        this.eastAabb = Block.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)12.0, (double)13.0, (double)13.0);
        this.westAabb = Block.m_49796_((double)4.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> this.northAabb;
            case Direction.SOUTH -> this.southAabb;
            case Direction.EAST -> this.eastAabb;
            case Direction.WEST -> this.westAabb;
            case Direction.DOWN -> this.downAabb;
            case Direction.UP -> this.upAabb;
        };
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockPos = pos.m_121945_(direction.m_122424_());
        return level.m_8055_(blockPos).m_60783_((BlockGetter)level, blockPos, direction);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        int i;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if ((i = RockSaltCrystalBlock.getDistanceAt(neighborState) - 1) != 1 || (Integer)state.m_61143_((Property)LIGHT) != i) {
            level.m_186460_(currentPos, (Block)this, 1);
        }
        return direction == ((Direction)state.m_61143_((Property)FACING)).m_122424_() && !state.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        int light = context.m_43725_().m_7146_(context.m_8083_());
        boolean bl = light > 0;
        Level levelAccessor = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        BlockState blockState = (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)LIGHT, (Comparable)Integer.valueOf(light))).m_61124_((Property)ILLUMINATED, (Comparable)Boolean.valueOf(bl))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelAccessor.m_6425_(blockPos).m_76152_() == Fluids.f_76193_))).m_61124_((Property)FACING, (Comparable)context.m_43719_());
        return RockSaltCrystalBlock.updateDistance(blockState, (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.m_7731_(pos, RockSaltCrystalBlock.updateDistance(state, (LevelAccessor)level, pos), 3);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, FACING, ILLUMINATED, LIGHT});
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
        this.onEntityStepOn(state, entity);
        super.m_141947_(world, pos, state, entity);
    }

    private static BlockState updateDistance(BlockState state, LevelAccessor level, BlockPos pos) {
        Direction[] var5;
        int i = 0;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Direction direction : var5 = Direction.values()) {
            mutableBlockPos.m_122159_((Vec3i)pos, direction);
            i = Math.max(i, RockSaltCrystalBlock.getDistanceAt(level.m_8055_((BlockPos)mutableBlockPos)) - 1);
            if (i == 16) break;
        }
        return (BlockState)((BlockState)state.m_61124_((Property)LIGHT, (Comparable)Integer.valueOf(i))).m_61124_((Property)ILLUMINATED, (Comparable)Boolean.valueOf(i > 0));
    }

    private static int getDistanceAt(BlockState neighbor) {
        if (neighbor.m_60791_() > 1) {
            return neighbor.m_60791_();
        }
        return neighbor.m_61138_((Property)ILLUMINATED) ? (Integer)neighbor.m_61143_((Property)LIGHT) : 0;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return (Integer)state.m_61143_((Property)LIGHT);
    }
}

