/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.handrails;

import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.Instancer;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import rbasamoyai.escalated.handrails.AbstractHandrailBlock;
import rbasamoyai.escalated.handrails.HandrailBlockEntity;
import rbasamoyai.escalated.handrails.HandrailInstance;
import rbasamoyai.escalated.handrails.HandrailRenderer;
import rbasamoyai.escalated.index.EscalatedInstanceTypes;
import rbasamoyai.escalated.walkways.WalkwaySlope;

public class HandrailVisual
extends AbstractBlockEntityVisual<HandrailBlockEntity>
implements SimpleDynamicVisual {
    protected final HandrailInstance leftHandrail;
    protected final HandrailInstance rightHandrail;
    private final Direction facing;
    private float v0;
    private float v1;
    private DyeColor handrailColor;

    public HandrailVisual(VisualizationContext ctx, HandrailBlockEntity blockEntity, float partialTick) {
        super(ctx, (BlockEntity)blockEntity, partialTick);
        AbstractHandrailBlock.Side side = (AbstractHandrailBlock.Side)((Object)this.blockState.m_61143_(AbstractHandrailBlock.SIDE));
        this.facing = (Direction)this.blockState.m_61143_((Property)AbstractHandrailBlock.f_54117_);
        this.handrailColor = ((HandrailBlockEntity)this.blockEntity).getHandrailColor();
        SpriteShiftEntry spriteShift = HandrailRenderer.getSpriteShift(this.handrailColor);
        this.v0 = spriteShift.getTarget().m_118411_();
        this.v1 = spriteShift.getTarget().m_118412_();
        Instancer<HandrailInstance> instancer = this.getHandrailInstancer();
        this.leftHandrail = side == AbstractHandrailBlock.Side.LEFT || side == AbstractHandrailBlock.Side.BOTH ? this.setup((HandrailInstance)instancer.createInstance(), true, spriteShift) : (HandrailInstance)this.getEmptyHandrailInstancer().createInstance();
        this.rightHandrail = side == AbstractHandrailBlock.Side.RIGHT || side == AbstractHandrailBlock.Side.BOTH ? this.setup((HandrailInstance)instancer.createInstance(), false, spriteShift) : (HandrailInstance)this.getEmptyHandrailInstancer().createInstance();
    }

    private Instancer<HandrailInstance> getHandrailInstancer() {
        AbstractHandrailBlock handrail = (AbstractHandrailBlock)this.blockState.m_60734_();
        WalkwaySlope slope = handrail.getHandrailSlope(this.blockState);
        boolean end = handrail.isEndHandrail(this.blockState);
        return this.instancerProvider().instancer(EscalatedInstanceTypes.HANDRAIL, Models.partial((PartialModel)HandrailRenderer.getHandrailModel(slope, end), (Direction)this.facing.m_122424_()));
    }

    private Instancer<HandrailInstance> getEmptyHandrailInstancer() {
        return this.instancerProvider().instancer(EscalatedInstanceTypes.HANDRAIL, Models.block((BlockState)Blocks.f_50016_.m_49966_()));
    }

    private void resetHandrailTexture() {
        AbstractHandrailBlock.Side side = (AbstractHandrailBlock.Side)((Object)this.blockState.m_61143_(AbstractHandrailBlock.SIDE));
        SpriteShiftEntry spriteShift = HandrailRenderer.getSpriteShift(this.handrailColor);
        this.v0 = spriteShift.getTarget().m_118411_();
        this.v1 = spriteShift.getTarget().m_118412_();
        if (side == AbstractHandrailBlock.Side.LEFT || side == AbstractHandrailBlock.Side.BOTH) {
            this.leftHandrail.setScrollTexture(spriteShift).setChanged();
        }
        if (side == AbstractHandrailBlock.Side.RIGHT || side == AbstractHandrailBlock.Side.BOTH) {
            this.rightHandrail.setScrollTexture(spriteShift).setChanged();
        }
    }

    private HandrailInstance setup(HandrailInstance data, boolean left, SpriteShiftEntry spriteShift) {
        Direction offset = left ? this.facing.m_122428_() : this.facing.m_122427_();
        data.setScrollTexture(spriteShift).setScrollOffset(0.0f).position((Vec3i)this.getVisualPosition()).translatePosition((float)(offset.m_122429_() * 7) / 16.0f, 0.0f, (float)(offset.m_122431_() * 7) / 16.0f);
        return data;
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        float partialTick = ctx.partialTick();
        float scroll = HandrailRenderer.getScrollOffset((HandrailBlockEntity)this.blockEntity, partialTick, this.facing, this.v0, this.v1);
        this.leftHandrail.setScrollOffset(scroll).setChanged();
        this.rightHandrail.setScrollOffset(scroll).setChanged();
    }

    public void update(float partialTick) {
        super.update(partialTick);
        if (((HandrailBlockEntity)this.blockEntity).getHandrailColor() != this.handrailColor) {
            this.handrailColor = ((HandrailBlockEntity)this.blockEntity).getHandrailColor();
            this.resetHandrailTexture();
        }
    }

    public void updateLight(float partialTick) {
        this.relight(this.pos, new FlatLit[]{this.leftHandrail});
        this.relight(this.pos, new FlatLit[]{this.rightHandrail});
    }

    protected void _delete() {
        this.leftHandrail.delete();
        this.rightHandrail.delete();
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept((Instance)this.leftHandrail);
        consumer.accept((Instance)this.rightHandrail);
    }
}

