/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common;

import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.Vec3;

public class InvigoratedEffect
extends MobEffect {
    public static final ThreadLocal<Integer> BLOCK_XP_LEVEL = new ThreadLocal();

    public InvigoratedEffect(MobEffectCategory mobEffectCategory, int i) {
        super(mobEffectCategory, i);
    }

    public static void onBlcokXpDropped(ServerLevel level, BlockPos pos, int amount) {
        Integer amp;
        if (amount > 0 && (amp = BLOCK_XP_LEVEL.get()) != null) {
            InvigoratedEffect.awardBonusXp(level, Vec3.m_82512_((Vec3i)pos), amount, amp);
        }
    }

    public static void onLivingDeath(ServerLevel serverLevel, LivingEntity entity, LivingEntity killer) {
        MobEffectInstance i = killer.m_21124_(SleepTight.INVIGORATED.get());
        if (i != null && entity.f_20889_ > 0 && !entity.m_217046_() && !(entity instanceof Player) && entity.m_6149_() && serverLevel.m_46469_().m_46207_(GameRules.f_46135_)) {
            InvigoratedEffect.awardBonusXp(serverLevel, entity.m_20182_(), entity.m_213860_(), i.m_19564_());
        }
    }

    private static void awardBonusXp(ServerLevel serverLevel, Vec3 pos, int oldXp, int amp) {
        double xp = InvigoratedEffect.getExtraXp(oldXp, amp, serverLevel.f_46441_);
        if (xp != 0.0) {
            ExperienceOrb.m_147082_((ServerLevel)serverLevel, (Vec3)pos, (int)((int)xp));
        }
    }

    private static double getExtraXp(int oldXp, int amp, RandomSource random) {
        int actual;
        double value = (double)oldXp * CommonConfigs.INVIGORATED_XP.get() * (double)(amp + 1);
        double remainder = value - (double)(actual = (int)value);
        if (remainder != 0.0 && (double)random.m_188501_() < remainder) {
            ++actual;
        }
        return actual;
    }

    public static int onBlockBreak(int i, Player player) {
        MobEffectInstance e = player.m_21124_(SleepTight.INVIGORATED.get());
        if (e != null) {
            return (int)InvigoratedEffect.getExtraXp(i, e.m_19564_(), player.m_217043_());
        }
        return 0;
    }
}

