/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.structure.piece;

import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.SubmarineEntity;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.ACStructurePieceRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACLootTableRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class AbyssalRuinsStructurePiece
extends TemplateStructurePiece {
    public AbyssalRuinsStructurePiece(StructureTemplateManager manager, ResourceLocation resourceLocation, BlockPos pos, Rotation rotation) {
        super((StructurePieceType)ACStructurePieceRegistry.ABYSSAL_RUINS.get(), 0, manager, resourceLocation, resourceLocation.toString(), AbyssalRuinsStructurePiece.makeSettings(rotation), pos);
    }

    public AbyssalRuinsStructurePiece(StructureTemplateManager manager, CompoundTag tag) {
        super((StructurePieceType)ACStructurePieceRegistry.ABYSSAL_RUINS.get(), tag, manager, x -> AbyssalRuinsStructurePiece.makeSettings(Rotation.valueOf((String)tag.m_128461_("Rotation"))));
    }

    public AbyssalRuinsStructurePiece(StructurePieceSerializationContext context, CompoundTag tag) {
        this(context.f_226956_(), tag);
    }

    private static StructurePlaceSettings makeSettings(Rotation rotation) {
        return new StructurePlaceSettings().m_74379_(rotation).m_74377_(Mirror.NONE).m_163782_(false);
    }

    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
        super.m_183620_(context, tag);
        tag.m_128359_("Rotation", this.f_73657_.m_74404_().name());
    }

    public void m_213694_(WorldGenLevel worldGenLevel, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource randomSource, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos pos) {
        int i = worldGenLevel.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, this.f_73658_.m_123341_(), this.f_73658_.m_123343_());
        this.f_73658_ = new BlockPos(this.f_73658_.m_123341_(), i, this.f_73658_.m_123343_());
        BlockPos blockpos = StructureTemplate.m_74593_((BlockPos)new BlockPos(this.f_73656_.m_163801_().m_123341_() - 1, 0, this.f_73656_.m_163801_().m_123343_() - 1), (Mirror)Mirror.NONE, (Rotation)this.f_73657_.m_74404_(), (BlockPos)BlockPos.f_121853_).m_121955_((Vec3i)this.f_73658_);
        this.f_73658_ = new BlockPos(this.f_73658_.m_123341_(), this.getHeight(this.f_73658_, (BlockGetter)worldGenLevel, blockpos), this.f_73658_.m_123343_());
        if (this.f_73658_.m_123342_() > chunkGenerator.m_6337_() - 40) {
            this.f_73658_ = this.f_73658_.m_175288_(-128);
        }
        super.m_213694_(worldGenLevel, structureManager, chunkGenerator, randomSource, boundingBox, chunkPos, pos);
    }

    private int getHeight(BlockPos blockPos, BlockGetter level, BlockPos pos) {
        int i = blockPos.m_123342_();
        int j = 512;
        int k = i - 1;
        int l = 0;
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)blockPos, (BlockPos)pos)) {
            int i1 = blockpos.m_123341_();
            int j1 = blockpos.m_123343_();
            int k1 = blockPos.m_123342_() - 1;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(i1, k1, j1);
            BlockState blockstate = level.m_8055_((BlockPos)blockpos$mutableblockpos);
            FluidState fluidstate = level.m_6425_((BlockPos)blockpos$mutableblockpos);
            while ((blockstate.m_60795_() || fluidstate.m_205070_(FluidTags.f_13131_) || blockstate.m_204336_(BlockTags.f_13047_)) && k1 > level.m_141937_() + 1) {
                blockpos$mutableblockpos.m_122178_(i1, --k1, j1);
                blockstate = level.m_8055_((BlockPos)blockpos$mutableblockpos);
                fluidstate = level.m_6425_((BlockPos)blockpos$mutableblockpos);
            }
            j = Math.min(j, k1);
            if (k1 >= k - 2) continue;
            ++l;
        }
        int l1 = Math.abs(blockPos.m_123341_() - pos.m_123341_());
        if (k - j > 2 && l > l1 - 2) {
            i = j + 1;
        }
        return i;
    }

    protected void m_213704_(String string, BlockPos pos, ServerLevelAccessor accessor, RandomSource random, BoundingBox box) {
        accessor.m_7731_(pos, Blocks.f_50627_.m_49966_(), 0);
        switch (string) {
            case "loot_chest": {
                RandomizableContainerBlockEntity.m_222766_((BlockGetter)accessor, (RandomSource)random, (BlockPos)pos.m_7495_(), (ResourceLocation)ACLootTableRegistry.ABYSSAL_RUINS_CHEST);
                break;
            }
            case "submarine": {
                this.spawnSubmarine(accessor, pos, false);
                break;
            }
            case "submarine_damaged": {
                if (!(random.m_188501_() > 0.5f)) break;
                this.spawnSubmarine(accessor, pos, true);
            }
        }
    }

    private void spawnSubmarine(ServerLevelAccessor level, BlockPos pos, boolean totaled) {
        SubmarineEntity submarine = (SubmarineEntity)((EntityType)ACEntityRegistry.SUBMARINE.get()).m_20615_((Level)level.m_6018_());
        while (level.m_8055_(pos).m_60819_().m_76178_() && !level.m_46859_(pos) && pos.m_123342_() < level.m_151558_()) {
            pos = pos.m_7494_();
        }
        Vec3 vec31 = Vec3.m_82512_((Vec3i)pos);
        submarine.m_146922_(level.m_213780_().m_188501_() * 360.0f);
        submarine.m_6034_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_);
        while (!level.m_45784_((Entity)submarine)) {
            submarine.m_146884_(submarine.m_20182_().m_82549_(new Vec3(0.0, 1.0, 0.0)));
        }
        if (totaled) {
            submarine.setDamageLevel(4);
            submarine.setOxidizationLevel(3);
        } else {
            submarine.setOxidizationLevel(2);
        }
        level.m_7967_((Entity)submarine);
    }
}

