/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ai.GingerbreadManAttackGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.GingerbreadManFleeGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.GingerbreadManOpenDoorGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.GingerbreadManStealGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.GingerbreadManStoreStolenItemsGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.GingerbreadManTargetEverythingGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.MobTargetItemGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.MobWanderThroughStructureGoal;
import com.github.alexmodguy.alexscaves.server.entity.living.LicowitchEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.PossessedByLicowitch;
import com.github.alexmodguy.alexscaves.server.entity.util.TargetsDroppedItems;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.server.entity.IDancesToJukebox;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class GingerbreadManEntity
extends Monster
implements IAnimatedEntity,
IDancesToJukebox,
PossessedByLicowitch,
TargetsDroppedItems {
    private static final EntityDataAccessor<Boolean> DANCING = SynchedEntityData.m_135353_(GingerbreadManEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(GingerbreadManEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(GingerbreadManEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CARRYING_ITEM = SynchedEntityData.m_135353_(GingerbreadManEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<UUID>> FLEEING_FROM_UUID = SynchedEntityData.m_135353_(GingerbreadManEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> POSSESSOR_LICOWITCH_ID = SynchedEntityData.m_135353_(GingerbreadManEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<BlockPos>> BARREL_POS = SynchedEntityData.m_135353_(GingerbreadManEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Integer> TEAM_COLOR = SynchedEntityData.m_135353_(GingerbreadManEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> OVEN_SPAWNED = SynchedEntityData.m_135353_(GingerbreadManEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LOST_LEFT_ARM = SynchedEntityData.m_135353_(GingerbreadManEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LOST_RIGHT_ARM = SynchedEntityData.m_135353_(GingerbreadManEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LOST_LEFT_LEG = SynchedEntityData.m_135353_(GingerbreadManEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LOST_RIGHT_LEG = SynchedEntityData.m_135353_(GingerbreadManEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final Animation ANIMATION_IDLE_WAVE_LEFT = Animation.create((int)35);
    public static final Animation ANIMATION_IDLE_WAVE_RIGHT = Animation.create((int)35);
    public static final Animation ANIMATION_IDLE_FALL_OVER = Animation.create((int)50);
    public static final Animation ANIMATION_IDLE_JUMP = Animation.create((int)20);
    public static final Animation ANIMATION_SWING_RIGHT = Animation.create((int)15);
    public static final Animation ANIMATION_SWING_LEFT = Animation.create((int)15);
    public static final int MAX_VARIANTS = 8;
    private int lSteps;
    private double lx;
    private double ly;
    private double lz;
    private double lyr;
    private double lxr;
    private double lxd;
    private double lyd;
    private double lzd;
    private int animationTick;
    private Animation currentAnimation;
    private float prevSitProgress;
    private float sitProgress;
    public float prevDanceProgress;
    public float danceProgress;
    public float prevCarryItemProgress;
    public float carryItemProgress;
    public BlockPos jukeboxPosition;
    private int sitFor = -100;
    private int despawnFromOvenCooldown = 2000;
    private int fleeFor = 0;
    private double lastStepX = 0.0;
    private double lastStepZ = 0.0;
    public int[] limbLostOrder = new int[4];

    public GingerbreadManEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.m_21508_(EquipmentSlot.MAINHAND);
        this.m_21508_(EquipmentSlot.OFFHAND);
        PathNavigation pathNavigation = this.m_21573_();
        if (pathNavigation instanceof GroundPathNavigation) {
            GroundPathNavigation groundPathNavigation = (GroundPathNavigation)pathNavigation;
            groundPathNavigation.m_26477_(true);
            groundPathNavigation.m_148214_(true);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new GingerbreadManOpenDoorGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new SitGoal());
        this.f_21345_.m_25352_(3, (Goal)new GingerbreadManFleeGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new GingerbreadManAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new GingerbreadManStealGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new GingerbreadManStoreStolenItemsGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new MobWanderThroughStructureGoal((PathfinderMob)this, 1.0, 30, ACTagRegistry.GINGERBREAD_MEN_WANDER_THROUGH, 10.0, 7.0));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 30, false));
        this.f_21345_.m_25352_(9, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42589_}), false));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        this.f_21345_.m_25352_(11, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, new MobTargetItemGoal((PathfinderMob)this, this.isOvenSpawned() ? 10 : 50, true, true, null, 5, 10, true));
        this.f_21346_.m_25352_(2, (Goal)new GingerbreadManTargetEverythingGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Husk.class, true, false));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DANCING, (Object)false);
        this.f_19804_.m_135372_(SITTING, (Object)false);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(CARRYING_ITEM, (Object)false);
        this.f_19804_.m_135372_(FLEEING_FROM_UUID, Optional.empty());
        this.f_19804_.m_135372_(POSSESSOR_LICOWITCH_ID, (Object)-1);
        this.f_19804_.m_135372_(BARREL_POS, Optional.empty());
        this.f_19804_.m_135372_(TEAM_COLOR, (Object)-1);
        this.f_19804_.m_135372_(OVEN_SPAWNED, (Object)false);
        this.f_19804_.m_135372_(LOST_LEFT_ARM, (Object)false);
        this.f_19804_.m_135372_(LOST_RIGHT_ARM, (Object)false);
        this.f_19804_.m_135372_(LOST_RIGHT_LEG, (Object)false);
        this.f_19804_.m_135372_(LOST_LEFT_LEG, (Object)false);
    }

    public float m_5610_(BlockPos pos, LevelReader levelReader) {
        return levelReader.m_8055_(pos.m_7495_()).m_60713_((Block)ACBlockRegistry.GINGERBREAD_BRICKS.get()) ? 10.0f : super.m_5610_(pos, levelReader);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.45).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22277_, 48.0);
    }

    public static boolean checkGingerbreadManSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return GingerbreadManEntity.m_219019_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevDanceProgress = this.danceProgress;
        this.prevSitProgress = this.sitProgress;
        this.prevCarryItemProgress = this.carryItemProgress;
        if (this.jukeboxPosition == null || !this.jukeboxPosition.m_203195_((Position)this.m_20182_(), 15.0) || !this.m_9236_().m_8055_(this.jukeboxPosition).m_60713_(Blocks.f_50131_)) {
            this.setDancing(false);
            this.jukeboxPosition = null;
        }
        if (this.isDancing() && this.danceProgress < 5.0f) {
            this.danceProgress += 1.0f;
        }
        if (!this.isDancing() && this.danceProgress > 0.0f) {
            this.danceProgress -= 1.0f;
        }
        if (this.isSitting() && this.sitProgress < 10.0f) {
            this.sitProgress += 1.0f;
        }
        if (!this.isSitting() && this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (this.isCarryingItem() && this.carryItemProgress < 10.0f) {
            this.carryItemProgress += 1.0f;
        }
        if (!this.isCarryingItem() && this.carryItemProgress > 0.0f) {
            this.carryItemProgress -= 1.0f;
        }
        if (!this.m_9236_().f_46443_) {
            if (this.isStillEnough() && !this.isCarryingItem() && this.f_19796_.m_188503_(150) == 0 && this.getAnimation() == NO_ANIMATION && !this.isDancing()) {
                if (this.f_19796_.m_188503_(3) == 0 && this.sitFor == 0) {
                    this.sitFor = 100 + this.f_19796_.m_188503_(80);
                } else {
                    float rand = this.f_19796_.m_188501_();
                    Animation idle = !this.isSitting() ? (rand < 0.25f ? ANIMATION_IDLE_JUMP : (rand < 0.5f ? ANIMATION_IDLE_FALL_OVER : (rand < 0.75f ? ANIMATION_IDLE_WAVE_LEFT : ANIMATION_IDLE_WAVE_RIGHT))) : (rand < 0.5f ? ANIMATION_IDLE_WAVE_LEFT : ANIMATION_IDLE_WAVE_RIGHT);
                    this.setAnimation(idle);
                }
            }
            if (this.isCarryingItem() && this.m_21120_(InteractionHand.OFF_HAND).m_41619_()) {
                this.setCarryingItem(false);
            }
        } else if (this.lSteps > 0) {
            double d5 = this.m_20185_() + (this.lx - this.m_20185_()) / (double)this.lSteps;
            double d6 = this.m_20186_() + (this.ly - this.m_20186_()) / (double)this.lSteps;
            double d7 = this.m_20189_() + (this.lz - this.m_20189_()) / (double)this.lSteps;
            this.m_146922_(Mth.m_14177_((float)((float)this.lyr)));
            this.m_146926_(this.m_146909_() + (float)(this.lxr - (double)this.m_146909_()) / (float)this.lSteps);
            --this.lSteps;
            this.m_6034_(d5, d6, d7);
        } else {
            this.m_20090_();
        }
        if (this.getAnimation() == ANIMATION_IDLE_JUMP && this.m_20096_() && this.getAnimationTick() == 5) {
            this.m_6135_();
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.sitFor > 0) {
            this.setSitting(true);
            --this.sitFor;
        } else {
            this.setSitting(false);
            if (this.sitFor < 0) {
                ++this.sitFor;
            }
        }
        if (this.fleeFor > 0) {
            --this.fleeFor;
            if (this.fleeFor == 0) {
                this.setFleeingFromUUID(null);
            }
        }
        if (this.isOvenSpawned() && this.despawnFromOvenCooldown-- < 0) {
            this.m_6074_();
            this.m_19983_(this.m_21120_(InteractionHand.MAIN_HAND));
            this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            this.m_19983_(this.m_21120_(InteractionHand.OFF_HAND));
            this.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
        }
        this.lastStepX = this.f_19854_;
        this.lastStepZ = this.f_19856_;
    }

    @Nullable
    public UUID getFleeingFromUUID() {
        return ((Optional)this.f_19804_.m_135370_(FLEEING_FROM_UUID)).orElse(null);
    }

    public void setFleeingFromUUID(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(FLEEING_FROM_UUID, Optional.ofNullable(uniqueId));
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public void stopSittingForAWhile() {
        this.sitFor = -100;
    }

    private boolean isStillEnough() {
        return this.m_20184_().m_165924_() < 0.05;
    }

    public void setJukeboxPos(BlockPos blockPos) {
        this.jukeboxPosition = blockPos;
    }

    public boolean isMovementBlocked() {
        return this.isSitting() || this.isDancing() || this.getAnimation() == ANIMATION_IDLE_FALL_OVER || this.getAnimation() == ANIMATION_IDLE_JUMP;
    }

    public void m_6818_(BlockPos pos, boolean playing) {
        this.onClientPlayMusicDisc(this.m_19879_(), pos, playing);
    }

    public boolean isDancing() {
        return (Boolean)this.f_19804_.m_135370_(DANCING);
    }

    public void setDancing(boolean bool) {
        this.f_19804_.m_135381_(DANCING, (Object)bool);
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    public void setSitting(boolean bool) {
        this.f_19804_.m_135381_(SITTING, (Object)bool);
    }

    public BlockPos getLastBarrelPos() {
        return ((Optional)this.f_19804_.m_135370_(BARREL_POS)).orElse(null);
    }

    public void setLastBarrelPos(BlockPos lastAltarPos) {
        this.f_19804_.m_135381_(BARREL_POS, Optional.ofNullable(lastAltarPos));
    }

    public boolean isCarryingItem() {
        return (Boolean)this.f_19804_.m_135370_(CARRYING_ITEM);
    }

    public void setCarryingItem(boolean bool) {
        this.f_19804_.m_135381_(CARRYING_ITEM, (Object)bool);
    }

    public boolean hasLostLimb(boolean left, boolean arm) {
        return (Boolean)this.f_19804_.m_135370_(arm ? (left ? LOST_LEFT_ARM : LOST_RIGHT_ARM) : (left ? LOST_LEFT_LEG : LOST_RIGHT_LEG));
    }

    public void setLostLimb(boolean left, boolean arm, boolean lost) {
        this.f_19804_.m_135381_(arm ? (left ? LOST_LEFT_ARM : LOST_RIGHT_ARM) : (left ? LOST_LEFT_LEG : LOST_RIGHT_LEG), (Object)lost);
    }

    public boolean hasBothLegs() {
        return !this.hasLostLimb(true, false) && !this.hasLostLimb(false, false);
    }

    public float getSitProgress(float partialTicks) {
        return (this.prevSitProgress + (this.sitProgress - this.prevSitProgress) * partialTicks) * 0.1f;
    }

    public float getDanceProgress(float partialTicks) {
        return (this.prevDanceProgress + (this.danceProgress - this.prevDanceProgress) * partialTicks) * 0.2f;
    }

    public float getCarryItemProgress(float partialTicks) {
        return (this.prevCarryItemProgress + (this.carryItemProgress - this.prevCarryItemProgress) * partialTicks) * 0.1f;
    }

    public int getGingerbreadTeamColor() {
        return (Integer)this.f_19804_.m_135370_(TEAM_COLOR);
    }

    public void setGingerbreadTeamColor(int color) {
        this.f_19804_.m_135381_(TEAM_COLOR, (Object)color);
    }

    public boolean isOvenSpawned() {
        return (Boolean)this.f_19804_.m_135370_(OVEN_SPAWNED);
    }

    public void setOvenSpawned(boolean bool) {
        this.f_19804_.m_135381_(OVEN_SPAWNED, (Object)bool);
    }

    public void setDespawnFromOvenCooldown(int cooldown) {
        this.despawnFromOvenCooldown = cooldown;
    }

    public void fleeFromFor(Entity entity, int fleeFor) {
        this.setFleeingFromUUID(entity.m_20148_());
        this.fleeFor = fleeFor;
    }

    public int getFleeFor() {
        return this.fleeFor;
    }

    public void m_267651_(boolean flying) {
        float f1 = (float)Mth.m_184648_((double)(this.m_20185_() - this.lastStepX), (double)0.0, (double)(this.m_20189_() - this.lastStepZ));
        float f2 = Math.min(f1 * 10.0f, 1.0f);
        this.f_267362_.m_267566_(f2, 0.4f);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public void m_6453_(double x, double y, double z, float yr, float xr, int steps, boolean b) {
        this.lx = x;
        this.ly = y;
        this.lz = z;
        this.lyr = yr;
        this.lxr = xr;
        this.lSteps = steps;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public void m_6001_(double lerpX, double lerpY, double lerpZ) {
        this.lxd = lerpX;
        this.lyd = lerpY;
        this.lzd = lerpZ;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_IDLE_WAVE_LEFT, ANIMATION_IDLE_WAVE_RIGHT, ANIMATION_IDLE_FALL_OVER, ANIMATION_IDLE_JUMP, ANIMATION_SWING_RIGHT};
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.setVariant(this.f_19796_.m_188503_(9));
        return super.m_6518_(level, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128379_("CarryingItem", this.isCarryingItem());
        compound.m_128379_("OvenSpawned", this.isOvenSpawned());
        compound.m_128405_("GingerbreadTeamColor", this.getGingerbreadTeamColor());
        compound.m_128405_("OvenDespawnCooldown", this.despawnFromOvenCooldown);
        compound.m_128379_("LostLeftLeg", this.hasLostLimb(true, false));
        compound.m_128379_("LostRightLeg", this.hasLostLimb(false, false));
        compound.m_128379_("LostLeftArm", this.hasLostLimb(true, true));
        compound.m_128379_("LostRightArm", this.hasLostLimb(false, true));
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.setCarryingItem(compound.m_128471_("CarryingItem"));
        this.setOvenSpawned(compound.m_128471_("OvenSpawned"));
        this.setGingerbreadTeamColor(compound.m_128451_("GingerbreadTeamColor"));
        this.despawnFromOvenCooldown = compound.m_128451_("OvenDespawnCooldown");
        this.setLostLimb(true, false, compound.m_128471_("LostLeftLeg"));
        this.setLostLimb(false, false, compound.m_128471_("LostRightLeg"));
        this.setLostLimb(true, true, compound.m_128471_("LostLeftArm"));
        this.setLostLimb(false, true, compound.m_128471_("LostRightArm"));
    }

    @Override
    public void setPossessedByLicowitchId(int entityId) {
        this.f_19804_.m_135381_(POSSESSOR_LICOWITCH_ID, (Object)entityId);
    }

    @Override
    public int getPossessedByLicowitchId() {
        return (Integer)this.f_19804_.m_135370_(POSSESSOR_LICOWITCH_ID);
    }

    public boolean m_6779_(LivingEntity living) {
        LicowitchEntity licowitch;
        if (this.getPossessedByLicowitchId() != -1 && (licowitch = this.getPossessingLicowitch(this.m_9236_())) != null && licowitch.isFriendlyFire(living)) {
            return false;
        }
        return super.m_6779_(living);
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return super.m_7301_(effectInstance) && effectInstance.m_19544_() != MobEffects.f_19612_;
    }

    public Animation getAnimationForHand(boolean reverse) {
        return this.m_21526_() ? (reverse ? ANIMATION_SWING_RIGHT : ANIMATION_SWING_LEFT) : (reverse ? ANIMATION_SWING_LEFT : ANIMATION_SWING_RIGHT);
    }

    @Override
    public void onGetItem(ItemEntity e) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(this.getAnimationForHand(false));
        }
        this.m_7938_((Entity)e, 1);
        ItemStack duplicate = e.m_32055_().m_41777_();
        duplicate.m_41764_(1);
        this.m_21008_(InteractionHand.OFF_HAND, duplicate);
        e.m_32055_().m_41774_(1);
        this.setCarryingItem(true);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ACSoundRegistry.GINGERBREAD_MAN_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.GINGERBREAD_MAN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.GINGERBREAD_MAN_DEATH.get();
    }

    public boolean m_6469_(DamageSource damageSource, float damageAmount) {
        boolean prev = super.m_6469_(damageSource, damageAmount);
        if (prev && (double)damageAmount >= 1.0) {
            if ((this.hasBothLegs() || (double)this.m_21223_() <= 0.0) && this.f_19796_.m_188499_()) {
                this.setLostLimb(this.f_19796_.m_188499_(), false, true);
            } else if (this.f_19796_.m_188503_(2) == 0) {
                this.setLostLimb(this.f_19796_.m_188499_(), true, true);
            }
        }
        return prev;
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return (this.isOvenSpawned() || stack.m_204117_(ACTagRegistry.GINGERBREAD_MAN_STEALS)) && !this.hasLostLimb(this.m_21526_(), true);
    }

    protected boolean m_6125_() {
        return super.m_6125_() && this.getPossessedByLicowitchId() == -1;
    }

    protected void m_7625_(DamageSource damageSource, boolean b) {
        if (!this.isOvenSpawned()) {
            super.m_7625_(damageSource, b);
        }
    }

    protected void m_21226_() {
        if (!this.isOvenSpawned()) {
            super.m_21226_();
        }
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        super.m_7350_(dataAccessor);
        if (LOST_LEFT_ARM.equals(dataAccessor)) {
            this.onLoseArm(true, true);
        }
        if (LOST_RIGHT_ARM.equals(dataAccessor)) {
            this.onLoseArm(false, true);
        }
        if (LOST_LEFT_LEG.equals(dataAccessor)) {
            this.onLoseArm(true, false);
        }
        if (LOST_RIGHT_LEG.equals(dataAccessor)) {
            this.onLoseArm(false, false);
        }
    }

    private void onLoseArm(boolean left, boolean arm) {
        Vec3 vec3 = arm ? new Vec3(left ? (double)0.3f : (double)-0.3f, (double)(this.m_20206_() * 0.8f), 0.0) : new Vec3(left ? (double)0.2f : (double)-0.2f, (double)(this.m_20206_() * 0.3f), 0.0);
        Vec3 vec31 = vec3.m_82524_((float)(-Math.toRadians(this.f_20883_))).m_82549_(this.m_20182_());
        ItemParticleOption itemParticleOption = new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)ACItemRegistry.GINGERBREAD_CRUMBS.get()));
        for (int i = 0; i < 5; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)itemParticleOption, vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, ((double)this.f_19796_.m_188501_() - 0.5) * 0.2, ((double)this.f_19796_.m_188501_() - 0.5) * 0.2, ((double)this.f_19796_.m_188501_() - 0.5) * 0.2);
        }
        if (!this.m_9236_().f_46443_) {
            if (!this.isOvenSpawned() && this.m_6125_() && this.f_19796_.m_188503_(2) == 0 && this.m_6084_()) {
                this.m_19983_(new ItemStack((ItemLike)ACItemRegistry.GINGERBREAD_CRUMBS.get()));
            }
            if (arm) {
                if (this.m_21526_() == left) {
                    this.m_19983_(this.m_21120_(InteractionHand.MAIN_HAND));
                    this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                }
                if (this.m_21526_() != left) {
                    this.m_19983_(this.m_21120_(InteractionHand.OFF_HAND));
                    this.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
                }
            }
        }
    }

    private class SitGoal
    extends Goal {
        public SitGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8045_() {
            return GingerbreadManEntity.this.isMovementBlocked();
        }

        public boolean m_8036_() {
            if (GingerbreadManEntity.this.m_20072_()) {
                return false;
            }
            return GingerbreadManEntity.this.isMovementBlocked();
        }

        public void m_8056_() {
            GingerbreadManEntity.this.m_21573_().m_26573_();
        }
    }
}

