/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.server.entity.ai.DeepOneAttackGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.DeepOneBarterGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.DeepOneDisappearGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.DeepOneReactToPlayerGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.DeepOneTargetHostilePlayersGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.DeepOneWanderGoal;
import com.github.alexmodguy.alexscaves.server.entity.living.DeepOneBaseEntity;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class DeepOneKnightEntity
extends DeepOneBaseEntity {
    public static final Animation ANIMATION_THROW = Animation.create((int)20);
    public static final Animation ANIMATION_BITE = Animation.create((int)8);
    public static final Animation ANIMATION_SCRATCH = Animation.create((int)22);
    public static final Animation ANIMATION_TRADE = Animation.create((int)55);
    private UUID lastThrownTrident = null;
    private boolean melee = this.f_19796_.m_188499_();
    private static final EntityDimensions SWIMMING_SIZE = new EntityDimensions(1.2f, 1.3f, false);
    public static final ResourceLocation BARTER_LOOT = new ResourceLocation("alexscaves", "gameplay/deep_one_knight_barter");

    public DeepOneKnightEntity(EntityType entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new DeepOneAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new DeepOneBarterGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new DeepOneReactToPlayerGoal(this){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && DeepOneKnightEntity.this.lastThrownTrident == null;
            }

            @Override
            public boolean m_8045_() {
                return super.m_8045_() && DeepOneKnightEntity.this.lastThrownTrident == null;
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new DeepOneDisappearGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new DeepOneWanderGoal(this, 12, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 16.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new DeepOneBaseEntity.HurtByHostileTargetGoal());
        this.f_21346_.m_25352_(2, (Goal)new DeepOneTargetHostilePlayersGoal(this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22281_, 5.0);
    }

    @Override
    public EntityDimensions getSwimmingSize() {
        return SWIMMING_SIZE;
    }

    public boolean isNoon() {
        String s = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        return s != null && (s.toLowerCase().contains("noon") || s.toLowerCase().contains("stinkyfish"));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        LivingEntity target = this.m_5448_();
        if (!(target != null && target.m_6084_() || this.m_9236_().f_46443_ || this.lastThrownTrident == null)) {
            this.pickUpTrident();
        }
    }

    @Override
    protected ResourceLocation getBarterLootTable() {
        return BARTER_LOOT;
    }

    @Override
    public boolean startDisappearBehavior(Player player) {
        this.m_21563_().m_24950_(player.m_20185_(), player.m_20188_(), player.m_20189_(), 20.0f, (float)this.m_8132_());
        if (!this.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            this.swapItemsForAnimation(new ItemStack((ItemLike)ACItemRegistry.INK_BOMB.get()));
        }
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_THROW);
        } else if (this.getAnimation() == ANIMATION_THROW && this.getAnimationTick() > 10) {
            if (this.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)ACItemRegistry.INK_BOMB.get())) {
                this.restoreSwappedItem();
            }
            return super.startDisappearBehavior(player);
        }
        return false;
    }

    protected boolean pickUpTrident() {
        Entity entity;
        if (this.lastThrownTrident != null && !this.m_9236_().f_46443_ && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.lastThrownTrident)) instanceof ThrownTrident) {
            ThrownTrident trident = (ThrownTrident)entity;
            if ((double)this.m_20270_((Entity)trident) < 2.0) {
                if (this.getAnimation() == NO_ANIMATION) {
                    this.setAnimation(ANIMATION_SCRATCH);
                }
                this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42713_));
                trident.m_142687_(Entity.RemovalReason.DISCARDED);
                this.m_21573_().m_26573_();
                this.lastThrownTrident = null;
            } else {
                this.m_21573_().m_5624_((Entity)trident, 1.5);
            }
            return true;
        }
        return false;
    }

    @Override
    public void startAttackBehavior(LivingEntity target) {
        double distance = this.m_20270_((Entity)target);
        float f = this.m_20205_() + target.m_20205_();
        boolean meleeOnly = this.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)ACItemRegistry.ORTHOLANCE.get());
        if (!(!(distance > 15.0) && this.melee || meleeOnly)) {
            this.melee = false;
            if (!this.pickUpTrident() && this.m_21120_(InteractionHand.MAIN_HAND).m_150930_(Items.f_42713_)) {
                if (this.m_142582_((Entity)target) && distance < 35.0) {
                    this.m_21573_().m_26573_();
                    if (this.getAnimation() == NO_ANIMATION) {
                        this.setAnimation(ANIMATION_THROW);
                    } else if (this.getAnimation() == ANIMATION_THROW && this.getAnimationTick() > 8) {
                        this.melee = true;
                        this.throwTrident(target);
                        this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                    }
                } else {
                    this.m_21573_().m_5624_((Entity)target, 1.2);
                }
            }
        }
        if (this.melee || meleeOnly) {
            if (distance < (double)(f + 1.0f)) {
                if (this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                    this.setAnimation(this.m_217043_().m_188499_() ? ANIMATION_SCRATCH : ANIMATION_BITE);
                    this.m_216990_((SoundEvent)ACSoundRegistry.DEEP_ONE_KNIGHT_ATTACK.get());
                }
            } else {
                this.m_21573_().m_5624_((Entity)target, 1.2);
            }
        }
        if (this.getAnimation() == ANIMATION_SCRATCH && (this.getAnimationTick() > 5 && this.getAnimationTick() < 9 || this.getAnimationTick() > 12 && this.getAnimationTick() < 16)) {
            this.checkAndDealMeleeDamage(target, 1.0f);
        }
        if (this.getAnimation() == ANIMATION_BITE && this.getAnimationTick() > 3 && this.getAnimationTick() <= 7) {
            this.checkAndDealMeleeDamage(target, 1.0f);
        }
    }

    @Override
    public Animation getTradingAnimation() {
        return ANIMATION_TRADE;
    }

    public void throwTrident(LivingEntity target) {
        ThrownTrident throwntrident = new ThrownTrident(this.m_9236_(), (LivingEntity)this, new ItemStack((ItemLike)Items.f_42713_));
        double d0 = target.m_20185_() - this.m_20185_();
        double d1 = target.m_20227_(0.3333333333333333) - throwntrident.m_20186_();
        double d2 = target.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        throwntrident.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_11821_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)throwntrident);
        this.lastThrownTrident = throwntrident.m_20148_();
    }

    @Override
    protected void checkAndDealMeleeDamage(LivingEntity target, float multiplier) {
        super.checkAndDealMeleeDamage(target, multiplier);
        this.melee = this.f_19796_.m_188499_();
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.lastThrownTrident != null) {
            compound.m_128362_("LastTridentUUID", this.lastThrownTrident);
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("LastTridentUUID")) {
            this.lastThrownTrident = compound.m_128342_("LastTridentUUID");
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        spawnGroupData = super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
        this.m_8061_(EquipmentSlot.MAINHAND, (double)this.f_19796_.m_188501_() > 0.7 ? new ItemStack((ItemLike)ACItemRegistry.ORTHOLANCE.get()) : new ItemStack((ItemLike)Items.f_42713_));
        return spawnGroupData;
    }

    @Override
    public SoundEvent getAdmireSound() {
        return (SoundEvent)ACSoundRegistry.DEEP_ONE_KNIGHT_ADMIRE.get();
    }

    protected SoundEvent m_7515_() {
        return this.soundsAngry() ? (SoundEvent)ACSoundRegistry.DEEP_ONE_KNIGHT_HOSTILE.get() : (SoundEvent)ACSoundRegistry.DEEP_ONE_KNIGHT_IDLE.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.DEEP_ONE_KNIGHT_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.DEEP_ONE_KNIGHT_DEATH.get();
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_THROW, ANIMATION_BITE, ANIMATION_SCRATCH, ANIMATION_TRADE};
    }
}

