/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.item;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.util.PossessesCamera;
import com.github.alexmodguy.alexscaves.server.message.BeholderSyncMessage;
import com.github.alexmodguy.alexscaves.server.message.PossessionKeyMessage;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import java.util.BitSet;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class BeholderEyeEntity
extends Entity
implements PossessesCamera {
    private static final int LOAD_CHUNK_DISTANCE = 2;
    private static final EntityDataAccessor<Optional<UUID>> USING_PLAYER_ID = SynchedEntityData.m_135353_(BeholderEyeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Float> Y_ROT = SynchedEntityData.m_135353_(BeholderEyeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> X_ROT = SynchedEntityData.m_135353_(BeholderEyeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private boolean loadingChunks = false;
    private boolean stopPossession;
    private boolean prevStopPossession = true;
    private float prevEyeXRot;
    private float prevEyeYRot;
    public boolean hasTakenFullControlOfCamera;

    public BeholderEyeEntity(EntityType entityType, Level level) {
        super(entityType, level);
    }

    public BeholderEyeEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType)ACEntityRegistry.BEHOLDER_EYE.get(), level);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(USING_PLAYER_ID, Optional.empty());
        this.m_20088_().m_135372_(X_ROT, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(Y_ROT, (Object)Float.valueOf(0.0f));
    }

    public void m_8119_() {
        super.m_8119_();
        Entity usingPlayer = this.getUsingPlayer();
        if (usingPlayer == null) {
            if (!this.m_9236_().f_46443_ && this.loadingChunks) {
                this.loadingChunks = false;
                this.loadChunksAround(false);
            }
            if (this.f_19797_ > 3) {
                this.m_146870_();
            }
        } else {
            if (!this.m_9236_().f_46443_ && this.hasTakenFullControlOfCamera && !this.loadingChunks) {
                this.loadingChunks = true;
                this.loadChunksAround(true);
            }
            if (usingPlayer instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)usingPlayer;
                living.f_20902_ = 0.0f;
                living.f_20901_ = 0.0f;
                living.f_20900_ = 0.0f;
            }
            if (this.m_9236_().f_46443_) {
                Player clientSidePlayer = AlexsCaves.PROXY.getClientSidePlayer();
                if (usingPlayer == clientSidePlayer && AlexsCaves.PROXY.isKeyDown(4)) {
                    AlexsCaves.sendMSGToServer(new PossessionKeyMessage(this.m_19879_(), usingPlayer.m_19879_(), 0));
                }
            } else {
                if (this.prevStopPossession != this.stopPossession) {
                    this.handleCameraServerSide(usingPlayer, !this.stopPossession);
                    this.prevStopPossession = this.stopPossession;
                }
                if (this.stopPossession) {
                    this.setUsingPlayerUUID(null);
                }
                if (usingPlayer.m_6144_()) {
                    this.stopPossession = true;
                }
            }
        }
    }

    public Vec3 m_20184_() {
        return Vec3.f_82478_;
    }

    public void m_20256_(Vec3 vec3) {
    }

    public void handleCameraServerSide(Entity usingPlayer, boolean turnOn) {
        if (usingPlayer.m_9236_().equals(this.m_9236_())) {
            AlexsCaves.sendMSGToAll(new BeholderSyncMessage(this.m_19879_(), turnOn));
            if (turnOn) {
                this.m_9236_().m_7605_((Entity)this, (byte)77);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)78);
            }
            if (turnOn) {
                this.hasTakenFullControlOfCamera = true;
            }
        } else {
            this.m_146870_();
        }
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        this.m_9236_().m_7605_((Entity)this, (byte)78);
        super.m_142687_(removalReason);
    }

    public void m_7822_(byte b) {
        if (b == 77 || b == 78) {
            Entity usingPlayer = this.getUsingPlayer();
            if (usingPlayer instanceof Player) {
                Player player = (Player)usingPlayer;
                if (b == 77) {
                    player.m_216990_((SoundEvent)ACSoundRegistry.BEHOLDER_ENTER.get());
                    AlexsCaves.PROXY.setRenderViewEntity(player, this);
                } else {
                    player.m_216990_((SoundEvent)ACSoundRegistry.BEHOLDER_EXIT.get());
                    AlexsCaves.PROXY.resetRenderViewEntity(player);
                }
            }
        } else {
            super.m_7822_(b);
        }
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128441_("UsingPlayerUUID")) {
            this.setUsingPlayerUUID(tag.m_128342_("UsingPlayerUUID"));
        }
    }

    protected void m_7380_(CompoundTag tag) {
        UUID uuid1 = this.getUsingPlayerUUID();
        if (uuid1 != null) {
            tag.m_128362_("UsingPlayerUUID", uuid1);
        }
    }

    public void setUsingPlayerUUID(UUID uuid) {
        this.f_19804_.m_135381_(USING_PLAYER_ID, Optional.ofNullable(uuid));
    }

    public UUID getUsingPlayerUUID() {
        return ((Optional)this.f_19804_.m_135370_(USING_PLAYER_ID)).orElse(null);
    }

    public Entity getUsingPlayer() {
        UUID id = this.getUsingPlayerUUID();
        if (id == null) {
            return null;
        }
        if (this.m_9236_().f_46443_) {
            return this.m_9236_().m_46003_(id);
        }
        return this.m_9236_().m_7654_().m_6846_().m_11259_(id);
    }

    public float m_146908_() {
        return ((Float)this.f_19804_.m_135370_(Y_ROT)).floatValue();
    }

    public float m_146909_() {
        return ((Float)this.f_19804_.m_135370_(X_ROT)).floatValue();
    }

    public float m_5686_(float f) {
        return f == 1.0f ? this.m_146909_() : Mth.m_14179_((float)f, (float)this.prevEyeXRot, (float)this.m_146909_());
    }

    public float m_5675_(float f) {
        return f == 1.0f ? this.m_146908_() : Mth.m_14179_((float)f, (float)this.prevEyeYRot, (float)this.m_146908_());
    }

    public void setEyeYRot(float f) {
        this.f_19804_.m_135381_(Y_ROT, (Object)Float.valueOf(f));
    }

    public void setEyeXRot(float f) {
        this.f_19804_.m_135381_(X_ROT, (Object)Float.valueOf(f));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public void onPossessionKeyPacket(Entity keyPresser, int type) {
        Entity possessed = this.getUsingPlayer();
        if (possessed != null && possessed.equals((Object)keyPresser)) {
            this.stopPossession = true;
        }
    }

    private void loadChunksAround(boolean load) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity = this.getUsingPlayer();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                ChunkPos playerChunkPos = new ChunkPos(serverPlayer.m_20183_());
                ForgeChunkManager.forceChunk((ServerLevel)serverLevel, (String)"alexscaves", (Entity)this, (int)playerChunkPos.f_45578_, (int)playerChunkPos.f_45579_, (boolean)load, (boolean)load);
            }
            ChunkPos chunkPos = new ChunkPos(this.m_20183_());
            int dist = Math.max(2, serverLevel.m_7654_().m_6846_().m_11312_() / 2);
            for (int i = -dist; i <= dist; ++i) {
                for (int j = -dist; j <= dist; ++j) {
                    Entity entity2;
                    ForgeChunkManager.forceChunk((ServerLevel)serverLevel, (String)"alexscaves", (Entity)this, (int)(chunkPos.f_45578_ + i), (int)(chunkPos.f_45579_ + j), (boolean)load, (boolean)load);
                    if (!load || !((entity2 = this.getUsingPlayer()) instanceof ServerPlayer)) continue;
                    ServerPlayer serverPlayer = (ServerPlayer)entity2;
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundLevelChunkWithLightPacket(this.m_9236_().m_6325_(chunkPos.f_45578_ + i, chunkPos.f_45579_ + j), this.m_9236_().m_5518_(), (BitSet)null, (BitSet)null));
                }
            }
        }
    }

    @Override
    public float getPossessionStrength(float partialTicks) {
        float age = (float)this.f_19797_ + partialTicks;
        if (age > 10.0f) {
            return 0.0f;
        }
        float j = age / 10.0f;
        return 1.0f - j;
    }

    @Override
    public boolean instant() {
        return true;
    }

    @Override
    public boolean isPossessionBreakable() {
        return true;
    }

    public void setOldRots() {
        this.prevEyeYRot = this.m_146908_();
        this.prevEyeXRot = this.m_146909_();
    }
}

