/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.entity.living.UnderzealotEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.VesperEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.UnderzealotSacrifice;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class UnderzealotCaptureSacrificeGoal
extends Goal {
    private UnderzealotEntity entity;
    private LivingEntity sacrifice;
    private int validTimeCheck = 0;

    public UnderzealotCaptureSacrificeGoal(UnderzealotEntity underzealot) {
        this.entity = underzealot;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity target = this.entity.m_5448_();
        long worldTime = this.entity.m_9236_().m_46467_() % 10L;
        if (this.entity.isCarrying() || this.entity.isPackFollower() || this.entity.sacrificeCooldown > 0) {
            return false;
        }
        if (!(worldTime == 0L && this.entity.m_217043_().m_188503_(3) == 0 || target != null && target.m_6084_())) {
            return false;
        }
        AABB aabb = this.entity.m_20191_().m_82400_(20.0);
        List list = this.entity.m_9236_().m_6443_(LivingEntity.class, aabb, this::isFirstValidSacrifice);
        if (!list.isEmpty()) {
            LivingEntity closest = null;
            for (LivingEntity mob : list) {
                if (closest != null && !(mob.m_20280_((Entity)this.entity) < closest.m_20280_((Entity)this.entity)) || !this.entity.m_142582_((Entity)mob)) continue;
                closest = mob;
            }
            this.sacrifice = closest;
            return this.sacrifice != null;
        }
        return false;
    }

    private boolean isFirstValidSacrifice(LivingEntity entity) {
        return this.isValidSacrifice(entity) && (entity instanceof VesperEntity || entity.m_217043_().m_188503_(4) == 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isValidSacrifice(LivingEntity entity) {
        if (!(entity instanceof UnderzealotSacrifice)) return false;
        UnderzealotSacrifice sacrifice = (UnderzealotSacrifice)entity;
        if (entity.m_20159_()) return false;
        if (!sacrifice.isValidSacrifice(this.getDistanceToGround(entity))) return false;
        return true;
    }

    private int getDistanceToGround(LivingEntity entity) {
        int downBy = 0;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(entity.m_146903_(), entity.m_146904_(), entity.m_146907_());
        while (entity.m_9236_().m_46859_((BlockPos)pos) && pos.m_123342_() > entity.m_9236_().m_141937_()) {
            pos.m_122184_(0, -1, 0);
            ++downBy;
        }
        return downBy;
    }

    public boolean m_8045_() {
        return this.sacrifice != null && this.sacrifice.m_6084_() && !this.sacrifice.m_20159_() && !this.entity.isPackFollower() && this.entity.m_20270_((Entity)this.sacrifice) < 32.0f && this.entity.sacrificeCooldown <= 0;
    }

    public void m_8041_() {
        this.entity.m_21573_().m_26573_();
    }

    public void m_8056_() {
        this.validTimeCheck = 0;
    }

    public void m_8037_() {
        double distance = this.entity.m_20270_((Entity)this.sacrifice);
        this.entity.m_21573_().m_5624_((Entity)this.sacrifice, 1.0);
        if (distance < (double)1.4f) {
            this.sacrifice.m_20329_((Entity)this.entity);
        }
        Vec3 sub = this.sacrifice.m_20182_().m_82546_(this.entity.m_20182_());
        if (!this.entity.isBuried() && sub.f_82480_ > 0.5 && sub.m_165924_() < 2.0 && this.entity.m_20096_()) {
            this.entity.m_6135_();
        }
        ++this.validTimeCheck;
        if (this.validTimeCheck % 100 == 0 && !this.isValidSacrifice(this.sacrifice)) {
            this.sacrifice = null;
        }
    }
}

