/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.entity.living.NotorEntity;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class NotorHologramGoal
extends Goal {
    private NotorEntity notor;
    private int checkForMonsterTime = 0;
    private Mob monster;
    private Vec3 moveTarget = null;
    private int hologramTime = 0;
    private static final int MAX_HOLOGRAM_TIME = 100;

    public NotorHologramGoal(NotorEntity notor) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.notor = notor;
    }

    public boolean m_8036_() {
        return this.notor.getHologramUUID() != null;
    }

    public boolean m_8045_() {
        return this.m_8036_() && (this.monster == null || this.monster.m_6084_() && this.monster.m_20270_((Entity)this.notor) < 40.0f);
    }

    public void m_8056_() {
        this.checkForMonsterTime = 0;
        this.hologramTime = 0;
        this.monster = null;
    }

    public void m_8041_() {
        this.notor.setScanningId(-1);
        this.notor.setHologramPos(null);
        this.notor.setShowingHologram(false);
        this.notor.stopScanningFor += this.notor.m_217043_().m_188503_(100) + 100;
        this.monster = null;
    }

    public void m_8037_() {
        double holoHeight;
        Entity hologram = this.notor.getHologramEntity();
        double d = holoHeight = hologram == null ? 1.0 : (double)hologram.m_20206_();
        if (this.checkForMonsterTime < 0) {
            this.checkForMonsterTime = 20 + this.notor.m_217043_().m_188503_(10);
            if (this.monster == null || !this.monster.m_6084_()) {
                Predicate<Entity> monsterAway = entity -> entity instanceof Enemy && (hologram == null || !entity.equals((Object)hologram)) && entity.m_20270_((Entity)this.notor) > 5.0f && !entity.m_20159_() && this.hasNoTarget((Entity)entity);
                List list = this.notor.m_9236_().m_6443_(Mob.class, this.notor.m_20191_().m_82377_(30.0, 12.0, 30.0), EntitySelector.f_20408_.and(monsterAway));
                list.sort(Comparator.comparingDouble(arg_0 -> ((NotorEntity)this.notor).m_20280_(arg_0)));
                if (!list.isEmpty()) {
                    this.monster = (Mob)list.get(0);
                }
            }
        } else {
            --this.checkForMonsterTime;
        }
        if (this.monster == null || !this.monster.m_6084_() || !this.hasNoTarget((Entity)this.monster)) {
            if (hologram != null) {
                for (int j = 0; (this.moveTarget == null || this.moveTarget.m_82554_(this.notor.m_20182_()) < 4.0) && j < 10; ++j) {
                    this.moveTarget = DefaultRandomPos.m_148407_((PathfinderMob)this.notor, (int)40, (int)15, (Vec3)hologram.m_20182_());
                }
            }
            if (this.moveTarget != null && this.moveTarget.m_82554_(this.notor.m_20182_()) >= 4.0) {
                this.notor.m_21573_().m_26519_(this.moveTarget.f_82479_, this.moveTarget.f_82480_, this.moveTarget.f_82481_, (double)1.2f);
            }
        } else {
            double distToMonster = this.monster.m_20270_((Entity)this.notor);
            double distMonsterToPlayer = this.monster.m_20270_((Entity)this.notor);
            if (this.hologramTime < 100) {
                if (distToMonster < 8.0 && this.notor.m_142582_((Entity)this.monster)) {
                    BlockPos gotten;
                    this.notor.m_21573_().m_26573_();
                    if (this.notor.getHologramPos() == null) {
                        BlockPos set = this.monster.m_20183_();
                        for (int i = 0; i < 15; ++i) {
                            BlockPos holoPos = this.monster.m_20183_().m_7918_(this.notor.m_217043_().m_188503_(10) - 5, (int)(this.monster.m_20206_() + 3.0f), this.notor.m_217043_().m_188503_(10) - 5);
                            while (this.notor.m_9236_().m_46859_(holoPos) && holoPos.m_123342_() > this.notor.m_9236_().m_141937_()) {
                                holoPos = holoPos.m_7495_();
                            }
                            Vec3 holoVec = Vec3.m_82512_((Vec3i)(holoPos = holoPos.m_7494_()));
                            if (this.isTargetBlocked(this.monster, holoVec) || this.isTargetBlocked((Mob)this.notor, holoVec)) continue;
                            set = holoPos;
                            break;
                        }
                        this.notor.setHologramPos(set.m_6630_((int)holoHeight));
                    }
                    Vec3 stareAt = (gotten = this.notor.getHologramPos()) == null ? this.notor.m_146892_() : Vec3.m_82512_((Vec3i)gotten).m_82520_(0.0, 0.0, 0.0);
                    this.monster.m_7618_(EntityAnchorArgument.Anchor.EYES, stareAt);
                    this.notor.m_7618_(EntityAnchorArgument.Anchor.EYES, stareAt);
                    this.monster.m_21573_().m_26573_();
                    this.notor.setShowingHologram(true);
                    ++this.hologramTime;
                } else {
                    this.notor.m_21573_().m_26519_(this.monster.m_20185_(), this.monster.m_20227_(1.0) + 1.0, this.monster.m_20189_(), (double)1.2f);
                }
            } else {
                Player player;
                this.notor.setShowingHologram(false);
                if (hologram instanceof Player && !(player = (Player)hologram).m_7500_()) {
                    this.monster.m_21573_().m_26519_(this.notor.m_20185_(), this.notor.m_20186_(), this.notor.m_20189_(), (double)1.2f);
                    this.notor.m_21573_().m_26519_(player.m_20185_(), player.m_20227_(1.0) + 2.0, player.m_20189_(), (double)1.2f);
                    this.monster.m_6710_((LivingEntity)player);
                    if (distMonsterToPlayer < Math.min(this.monster.m_21133_(Attributes.f_22277_) - 15.0, 10.0)) {
                        this.notor.setHologramUUID(null);
                    }
                } else {
                    this.notor.setHologramUUID(null);
                }
            }
        }
    }

    private boolean hasNoTarget(Entity entity) {
        if (entity instanceof Mob) {
            Mob living = (Mob)entity;
            LivingEntity target = living.m_5448_();
            return target == null || !target.m_6084_();
        }
        return true;
    }

    public boolean isTargetBlocked(Mob mob, Vec3 target) {
        Vec3 Vector3d = new Vec3(mob.m_20185_(), mob.m_20188_(), mob.m_20189_());
        return mob.m_9236_().m_45547_(new ClipContext(Vector3d, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)mob)).m_6662_() != HitResult.Type.MISS;
    }
}

