/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.entity.item.SubmarineEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.HullbreakerEntity;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class HullbreakerInspectMobGoal
extends Goal {
    private HullbreakerEntity entity;
    private Vec3 startCirclingAt;
    private LivingEntity inspectingTarget;
    private boolean clockwise;
    private int phaseTime;
    private int maxPhaseTime;
    private boolean staring = false;

    public HullbreakerInspectMobGoal(HullbreakerEntity hullbreaker) {
        this.entity = hullbreaker;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity target = this.entity.m_5448_();
        long worldTime = this.entity.m_9236_().m_46467_() % 10L;
        if (!(this.entity.m_217043_().m_188503_(60) == 0 || worldTime == 0L || target != null && target.m_6084_())) {
            return false;
        }
        AABB aabb = this.entity.m_20191_().m_82400_(80.0);
        List list = this.entity.m_9236_().m_6443_(LivingEntity.class, aabb, HullbreakerEntity.GLOWING_TARGET);
        if (!list.isEmpty()) {
            LivingEntity closest = null;
            for (LivingEntity mob : list) {
                if (closest != null && !(mob.m_20280_((Entity)this.entity) < closest.m_20280_((Entity)this.entity)) || !this.entity.m_142582_((Entity)mob) || mob.m_7306_((Entity)this.entity)) continue;
                closest = mob;
            }
            this.inspectingTarget = closest;
            return this.inspectingTarget != null;
        }
        return false;
    }

    public boolean m_8045_() {
        LivingEntity target = this.entity.m_5448_();
        return this.inspectingTarget != null && this.inspectingTarget.m_6084_() && (target == null || !target.m_6084_());
    }

    public void m_8056_() {
        this.staring = true;
        this.clockwise = this.entity.m_217043_().m_188499_();
        this.phaseTime = 0;
        this.maxPhaseTime = 60 + 40 * Math.min(0, 5 - this.entity.getInterestLevel());
    }

    public void m_8037_() {
        double distance = this.entity.m_20270_((Entity)this.inspectingTarget);
        if (this.entity.getInterestLevel() >= 5 && HullbreakerEntity.GLOWING_TARGET.test(this.inspectingTarget)) {
            if (!(this.inspectingTarget instanceof Player) || !((Player)this.inspectingTarget).m_7500_()) {
                this.entity.m_6710_(this.inspectingTarget);
            }
            this.inspectingTarget = null;
            return;
        }
        if (this.entity.m_217043_().m_188503_(20) == 0 && !HullbreakerEntity.GLOWING_TARGET.test(this.inspectingTarget)) {
            this.inspectingTarget = null;
        } else {
            if (this.entity.getAnimation() == HullbreakerEntity.ANIMATION_PUZZLE && this.entity.getAnimationTick() > 50) {
                this.phaseTime = this.maxPhaseTime;
            }
            if (this.phaseTime++ > this.maxPhaseTime) {
                this.entity.setInterestLevel(this.entity.getInterestLevel() + 1);
                this.staring = this.entity.m_217043_().m_188499_() && !this.staring;
                this.phaseTime = 0;
                this.startCirclingAt = this.inspectingTarget.m_146892_();
                int n = this.maxPhaseTime = this.staring ? 120 : 120 + 80 * Math.min(0, 5 - this.entity.getInterestLevel());
            }
            if (this.staring) {
                this.entity.m_7618_(EntityAnchorArgument.Anchor.EYES, this.inspectingTarget.m_146892_());
                if (this.isPreyWatching() && distance < 18.0) {
                    if (this.entity.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                        this.entity.setAnimation(HullbreakerEntity.ANIMATION_PUZZLE);
                    }
                    this.entity.m_21573_().m_26573_();
                } else if (this.entity.m_21573_().m_26571_()) {
                    Vec3 frontVision = this.inspectingTarget.m_146892_().m_82549_(this.inspectingTarget.m_20154_().m_82490_(12.0));
                    this.entity.m_21573_().m_26519_(frontVision.f_82479_, frontVision.f_82480_, frontVision.f_82481_, 1.0);
                }
            } else {
                if (this.startCirclingAt == null) {
                    this.startCirclingAt = this.inspectingTarget.m_146892_();
                }
                Vec3 circle = this.orbitAroundPos(this.inspectingTarget.m_146892_(), 12 + Math.min(0, 5 - this.entity.getInterestLevel()) * 3);
                this.entity.m_21573_().m_26519_(circle.f_82479_, circle.f_82480_, circle.f_82481_, (double)1.4f);
                this.entity.m_5616_(this.entity.f_20883_ + (float)(this.clockwise ? 30 : -30));
            }
            SubmarineEntity.alertSubmarineMountOf(this.inspectingTarget);
        }
    }

    public boolean isPreyWatching() {
        if (!(this.inspectingTarget instanceof Player)) {
            return true;
        }
        Entity lowestPrey = this.inspectingTarget.m_20201_();
        Vec3 vec3 = new Vec3(this.entity.m_20185_(), this.entity.m_20188_(), this.entity.m_20189_());
        Vec3 vec31 = new Vec3(lowestPrey.m_20185_(), lowestPrey.m_20188_(), lowestPrey.m_20189_());
        if (vec31.m_82554_(vec3) > 128.0) {
            return false;
        }
        return this.entity.m_9236_().m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, lowestPrey)).m_6662_() == HitResult.Type.MISS;
    }

    public void m_8041_() {
        LivingEntity target = this.entity.m_5448_();
        if (target == null || !target.m_6084_()) {
            this.entity.setInterestLevel(0);
        }
    }

    public Vec3 orbitAroundPos(Vec3 target, float circleDistance) {
        float angle = 3.0f * (float)(Math.PI * (double)(this.clockwise ? -this.phaseTime : this.phaseTime) / (double)this.maxPhaseTime);
        double extraX = circleDistance * Mth.m_14031_((float)angle);
        double extraZ = circleDistance * Mth.m_14089_((float)angle);
        return this.startCirclingAt.m_82520_(extraX, -1.0, extraZ);
    }
}

