/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.entity.living.ForsakenEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACDamageTypes;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;

public class ForsakenAttackGoal
extends Goal {
    private ForsakenEntity entity;
    private BlockPos jumpTarget = null;
    private boolean jumpEnqueued = false;
    private boolean sonicEnqueued = false;
    private int navigationCheckCooldown = 0;
    private int attemptSonicDamageIn = 0;

    public ForsakenAttackGoal(ForsakenEntity entity) {
        this.entity = entity;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity target = this.entity.m_5448_();
        return target != null && target.m_6084_();
    }

    public void m_8056_() {
        this.navigationCheckCooldown = 0;
        this.jumpEnqueued = false;
        this.sonicEnqueued = this.entity.m_217043_().m_188499_();
        this.attemptSonicDamageIn = 0;
    }

    public void m_8041_() {
        this.jumpEnqueued = false;
        this.sonicEnqueued = false;
        this.entity.setRunning(false);
    }

    public void m_8037_() {
        LivingEntity target = this.entity.m_5448_();
        if (target != null && target.m_6084_()) {
            boolean inPursuit;
            double distance = this.entity.m_20270_((Entity)target);
            double attackDistance = this.entity.m_20205_() + target.m_20205_();
            boolean bl = inPursuit = !this.isMovementFrozen();
            if (this.attemptSonicDamageIn > 0) {
                --this.attemptSonicDamageIn;
                if (this.attemptSonicDamageIn == 0 && this.entity.m_142582_((Entity)target)) {
                    target.m_6469_(ACDamageTypes.causeForsakenSonicBoomDamage(this.entity.m_9236_().m_9598_(), (Entity)this.entity), this.entity.getSonicDamageAgainst(target));
                    this.knockBackAngle(target, 1.0, 0.0f);
                }
            }
            if (this.sonicEnqueued && this.entity.m_142582_((Entity)target) && distance < 200.0) {
                this.entity.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                this.entity.setSonarId(target.m_19879_());
                this.entity.m_21573_().m_26573_();
                if (distance > 10.0 || (double)this.entity.m_217043_().m_188501_() < 0.4) {
                    this.tryAnimation(ForsakenEntity.ANIMATION_SONIC_ATTACK);
                    this.entity.m_5496_((SoundEvent)ACSoundRegistry.FORSAKEN_SCREECH.get(), this.entity.m_6121_(), this.entity.m_6100_());
                } else {
                    this.tryAnimation(ForsakenEntity.ANIMATION_SONIC_BLAST);
                    this.entity.m_5496_((SoundEvent)ACSoundRegistry.FORSAKEN_AOE.get(), this.entity.m_6121_(), this.entity.m_6100_());
                }
                if (this.entity.getAnimation() == ForsakenEntity.ANIMATION_SONIC_ATTACK) {
                    inPursuit = false;
                    if (this.entity.getAnimationTick() >= 10 && this.entity.getAnimationTick() <= 30 && this.attemptSonicDamageIn <= 0) {
                        this.attemptSonicDamageIn = (int)Math.ceil(distance * (double)0.2f);
                    }
                    if (this.entity.getAnimationTick() > 30) {
                        this.sonicEnqueued = false;
                    }
                }
                if (this.entity.getAnimation() == ForsakenEntity.ANIMATION_SONIC_BLAST) {
                    inPursuit = false;
                    if (this.entity.getAnimationTick() >= 10 && this.entity.getAnimationTick() <= 30 && this.entity.getAnimationTick() % 5 == 0) {
                        List list = this.entity.m_9236_().m_45976_(LivingEntity.class, this.entity.m_20191_().m_82377_(16.0, 8.0, 16.0));
                        for (LivingEntity living : list) {
                            if (living == this.entity || this.entity.m_7307_((Entity)living) || living.m_7307_((Entity)this.entity) || !(living.m_20270_((Entity)this.entity) <= 14.0f) || living.m_6095_().m_204039_(ACTagRegistry.FORSAKEN_IGNORES)) continue;
                            living.m_6469_(ACDamageTypes.causeForsakenSonicBoomDamage(this.entity.m_9236_().m_9598_(), (Entity)this.entity), (float)Math.ceil(this.entity.getSonicDamageAgainst(target) * 0.65f));
                        }
                    }
                    if (this.entity.getAnimationTick() > 40) {
                        this.sonicEnqueued = false;
                    }
                }
            } else if (this.jumpEnqueued) {
                if (this.jumpTarget == null) {
                    this.jumpTarget = this.findJumpTarget(target, distance > 20.0);
                } else {
                    inPursuit = false;
                    if (this.entity.isLeaping()) {
                        Vec3 vec3 = this.entity.m_20184_();
                        Vec3 vec31 = new Vec3((double)((float)this.jumpTarget.m_123341_() + 0.5f) - this.entity.m_20185_(), 0.0, (double)((float)this.jumpTarget.m_123343_() + 0.5f) - this.entity.m_20189_());
                        if (vec31.m_82556_() > 1.0E-7) {
                            vec31 = vec31.m_82490_((double)0.155f).m_82549_(vec3.m_82490_(0.2));
                        }
                        this.entity.m_20334_(vec31.f_82479_, (double)0.2f + vec31.m_82553_() * (double)0.3f, vec31.f_82481_);
                        this.jumpEnqueued = false;
                        this.jumpTarget = null;
                    } else if (this.entity.m_20096_()) {
                        this.entity.m_7618_(EntityAnchorArgument.Anchor.EYES, Vec3.m_82512_((Vec3i)this.jumpTarget));
                        this.tryAnimation(ForsakenEntity.ANIMATION_PREPARE_JUMP);
                    }
                }
            }
            if (inPursuit) {
                this.entity.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                this.entity.m_21573_().m_5624_((Entity)target, 1.0);
                if (distance < attackDistance + 1.0 && this.entity.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                    float attackType = this.entity.m_217043_().m_188501_();
                    if (attackType < 0.25f && target.m_20205_() < 2.0f) {
                        this.tryAnimation(this.entity.m_217043_().m_188499_() ? ForsakenEntity.ANIMATION_LEFT_PICKUP : ForsakenEntity.ANIMATION_RIGHT_PICKUP);
                    } else if (attackType < 0.5f) {
                        this.tryAnimation(this.entity.m_217043_().m_188499_() ? ForsakenEntity.ANIMATION_LEFT_SLASH : ForsakenEntity.ANIMATION_RIGHT_SLASH);
                    } else if (attackType < 0.75f) {
                        this.tryAnimation(ForsakenEntity.ANIMATION_GROUND_SMASH);
                    } else {
                        this.tryAnimation(ForsakenEntity.ANIMATION_BITE);
                        this.entity.m_216990_((SoundEvent)ACSoundRegistry.FORSAKEN_BITE.get());
                    }
                }
            } else {
                this.entity.m_21573_().m_26573_();
            }
            if ((distance > 20.0 && (double)this.entity.m_217043_().m_188501_() < 0.01 || this.entity.hasSonicCharge()) && !this.sonicEnqueued) {
                this.sonicEnqueued = true;
                this.entity.setSonicCharge(false);
            }
            if (distance > 30.0 && (double)this.entity.m_217043_().m_188501_() < 0.05 && !this.jumpEnqueued) {
                this.startCleanJump();
            }
            if (distance < 64.0 && distance > attackDistance && inPursuit) {
                this.entity.setRunning(true);
            } else {
                this.entity.setRunning(false);
            }
            if ((this.entity.getAnimation() == ForsakenEntity.ANIMATION_RIGHT_PICKUP || this.entity.getAnimation() == ForsakenEntity.ANIMATION_LEFT_PICKUP) && this.entity.getHeldMobId() == target.m_19879_() && this.entity.getAnimationTick() >= 30) {
                this.checkAndDealDamage(target, 1.2f, 5.0f);
            }
            if (this.entity.getAnimation() == ForsakenEntity.ANIMATION_RIGHT_SLASH && this.entity.getAnimationTick() >= 15 && this.entity.getAnimationTick() <= 18) {
                float knockbackStrength = 0.5f;
                if (this.checkAndDealDamage(target, 0.8f, 2.0f)) {
                    knockbackStrength = 3.0f;
                    this.entity.m_216990_((SoundEvent)ACSoundRegistry.FORSAKEN_GRAB.get());
                }
                this.knockBackAngle(target, knockbackStrength, -90.0f);
            }
            if (this.entity.getAnimation() == ForsakenEntity.ANIMATION_LEFT_SLASH && this.entity.getAnimationTick() >= 15 && this.entity.getAnimationTick() <= 18) {
                float knockbackStrength = 0.5f;
                if (this.checkAndDealDamage(target, 0.8f, 2.0f)) {
                    knockbackStrength = 3.0f;
                    this.entity.m_216990_((SoundEvent)ACSoundRegistry.FORSAKEN_GRAB.get());
                }
                this.knockBackAngle(target, knockbackStrength, 90.0f);
            }
            if (this.entity.getAnimation() == ForsakenEntity.ANIMATION_GROUND_SMASH && this.entity.getAnimationTick() >= 10 && this.entity.getAnimationTick() <= 15) {
                Vec3 smashPos = this.entity.m_20182_().m_82549_(new Vec3(0.0, 0.0, 3.5).m_82524_((float)(-Math.toRadians(this.entity.f_20883_))));
                List list = this.entity.m_9236_().m_45976_(LivingEntity.class, new AABB(smashPos.f_82479_ - 4.0, smashPos.f_82480_ - 2.0, smashPos.f_82481_ - 4.0, smashPos.f_82479_ + 4.0, smashPos.f_82480_ + 3.0, smashPos.f_82481_ + 4.0));
                boolean flag = false;
                for (LivingEntity living : list) {
                    if (living == this.entity || this.entity.m_7307_((Entity)living) || living.m_7307_((Entity)this.entity) || !(living.m_20238_(smashPos) <= 16.0) || living.m_6095_().m_204039_(ACTagRegistry.FORSAKEN_IGNORES) || !this.checkAndDealDamage(living, 0.8f, 3.0f) || !living.m_20096_()) continue;
                    living.m_20256_(living.m_20184_().m_82520_(0.0, 0.5, 0.0));
                    flag = true;
                }
                if (flag) {
                    this.entity.m_216990_((SoundEvent)ACSoundRegistry.FORSAKEN_GRAB.get());
                }
            }
            if (this.entity.getAnimation() == ForsakenEntity.ANIMATION_BITE && this.entity.getAnimationTick() >= 5 && this.entity.getAnimationTick() <= 8) {
                float knockbackStrength = 0.0f;
                if (this.checkAndDealDamage(target, 1.0, 1.0f)) {
                    knockbackStrength = 0.5f;
                }
                this.knockBackAngle(target, knockbackStrength, 0.0f);
            }
            if (this.navigationCheckCooldown-- < 0 && this.entity.m_20096_()) {
                this.navigationCheckCooldown = 20 + this.entity.m_217043_().m_188503_(40);
                if (!this.canReach(target)) {
                    this.startCleanJump();
                }
            }
        }
    }

    private boolean canReach(LivingEntity target) {
        int k;
        int j;
        Path path = this.entity.m_21573_().m_6570_((Entity)target, 0);
        if (path == null) {
            return false;
        }
        Node node = path.m_77395_();
        if (node == null) {
            return false;
        }
        int i = node.f_77271_ - target.m_146903_();
        return (double)(i * i + (j = node.f_77272_ - target.m_146904_()) * j + (k = node.f_77273_ - target.m_146907_()) * k) <= 3.0;
    }

    private boolean isMovementFrozen() {
        return this.entity.getAnimation() == ForsakenEntity.ANIMATION_LEFT_PICKUP || this.entity.getAnimation() == ForsakenEntity.ANIMATION_RIGHT_PICKUP;
    }

    private void startCleanJump() {
        this.jumpTarget = null;
        this.jumpEnqueued = true;
    }

    private boolean checkAndDealDamage(LivingEntity target, double multiplier, float extraRange) {
        if (this.entity.m_142582_((Entity)target) && this.entity.m_20270_((Entity)target) < this.entity.m_20205_() + target.m_20205_() + extraRange) {
            boolean b = target.m_6469_(target.m_269291_().m_269333_((LivingEntity)this.entity), (float)(multiplier * this.entity.m_21051_(Attributes.f_22281_).m_22135_()));
            if (this.entity.m_217043_().m_188503_(2) == 0) {
                this.startCleanJump();
            }
            if (!this.sonicEnqueued && this.entity.m_217043_().m_188503_(5) == 0) {
                this.sonicEnqueued = true;
            }
            return b;
        }
        return false;
    }

    private void knockBackAngle(LivingEntity target, double strength, float angle) {
        float yRot = this.entity.f_20883_ + angle;
        target.m_147240_(strength, (double)Mth.m_14031_((float)(yRot * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(yRot * ((float)Math.PI / 180)))));
    }

    private boolean tryAnimation(Animation animation) {
        if (this.entity.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
            this.entity.setAnimation(animation);
            return true;
        }
        return false;
    }

    private BlockPos findJumpTarget(LivingEntity target, boolean far) {
        int lengthOfRadius = far ? this.entity.m_217043_().m_188503_(2) + 4 : this.entity.m_217043_().m_188503_(10) + 15;
        Vec3 offset = target.m_20182_().m_82549_(new Vec3(0.0, 0.0, (double)lengthOfRadius).m_82524_((float)(Math.PI * 2 * (double)this.entity.m_217043_().m_188501_())));
        Vec3 vec3 = null;
        if (far) {
            BlockPos farPos = LandRandomPos.m_148518_((PathfinderMob)this.entity, (BlockPos)BlockPos.m_274446_((Position)offset));
            if (farPos != null) {
                vec3 = Vec3.m_82512_((Vec3i)farPos);
            }
        } else {
            vec3 = LandRandomPos.m_148492_((PathfinderMob)this.entity, (int)20, (int)10, (Vec3)offset);
        }
        if (vec3 != null) {
            BlockPos blockpos = BlockPos.m_274446_((Position)vec3);
            AABB aabb = this.entity.m_20191_().m_82383_(vec3.m_82520_(0.5, 1.0, 0.5).m_82546_(this.entity.m_20182_()));
            if (this.entity.m_9236_().m_8055_(blockpos.m_7495_()).m_60804_((BlockGetter)this.entity.m_9236_(), blockpos.m_7495_()) && this.entity.m_21439_(WalkNodeEvaluator.m_77604_((BlockGetter)this.entity.m_9236_(), (BlockPos.MutableBlockPos)blockpos.m_122032_())) == 0.0f && this.entity.m_9236_().m_5450_((Entity)this.entity, Shapes.m_83064_((AABB)aabb))) {
                return blockpos;
            }
        }
        return null;
    }
}

