/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.entity.living.AtlatitanEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class AtlatitanNibbleTreesGoal
extends MoveToBlockGoal {
    private AtlatitanEntity atlatitan;
    private boolean stopFlag = false;
    private int reachCheckTime = 50;

    public AtlatitanNibbleTreesGoal(AtlatitanEntity atlatitan, int range) {
        super((PathfinderMob)atlatitan, 1.0, range, 16);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        this.atlatitan = atlatitan;
    }

    public boolean m_8036_() {
        this.f_25603_ = this.atlatitan.m_6162_() ? 3 : 6;
        return super.m_8036_();
    }

    protected int m_6099_(PathfinderMob mob) {
        return AtlatitanNibbleTreesGoal.m_186073_((int)(200 + this.atlatitan.m_217043_().m_188503_(200)));
    }

    public double m_8052_() {
        return (int)Math.floor(14.0f * this.atlatitan.m_6134_());
    }

    protected boolean m_25625_() {
        BlockPos target = this.m_6669_();
        return target != null && this.atlatitan.m_20275_((float)target.m_123341_() + 0.5f, this.atlatitan.m_20186_(), (float)target.m_123343_() + 0.5f) < this.m_8052_();
    }

    protected BlockPos m_6669_() {
        return this.atlatitan.getStandAtTreePos(this.f_25602_);
    }

    public void m_8037_() {
        super.m_8037_();
        BlockPos target = this.m_6669_();
        if (target != null) {
            if (this.reachCheckTime > 0) {
                --this.reachCheckTime;
            } else {
                this.reachCheckTime = 50 + this.atlatitan.m_217043_().m_188503_(100);
                if (!this.canReach(target)) {
                    this.stopFlag = true;
                    this.f_25602_ = BlockPos.f_121853_;
                    return;
                }
            }
            if (this.m_25625_()) {
                if (this.atlatitan.lockTreePosition(this.f_25602_)) {
                    if (this.atlatitan.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                        this.atlatitan.setEatingPos(this.f_25602_);
                        this.atlatitan.setAnimation(AtlatitanEntity.ANIMATION_EAT_LEAVES);
                    } else if (this.atlatitan.getAnimation() == AtlatitanEntity.ANIMATION_EAT_LEAVES) {
                        if (this.atlatitan.getAnimationTick() >= 35) {
                            this.stopFlag = true;
                            this.f_25602_ = BlockPos.f_121853_;
                            return;
                        }
                        if (this.atlatitan.getAnimationTick() == 20) {
                            BlockState back = this.atlatitan.m_9236_().m_8055_(this.f_25602_);
                            this.atlatitan.setLastEatenBlock(back);
                            this.atlatitan.m_9236_().m_46953_(this.f_25602_, false, (Entity)this.atlatitan);
                            this.atlatitan.m_9236_().m_7731_(this.f_25602_, back, 3);
                        }
                    }
                }
            } else if (this.atlatitan.m_21573_().m_26571_()) {
                Vec3 vec31 = Vec3.m_82512_((Vec3i)target);
                this.atlatitan.m_21566_().m_6849_(vec31.f_82479_, this.atlatitan.m_20186_(), vec31.f_82481_, 1.0);
            }
        }
    }

    protected void m_25624_() {
        BlockPos pos = this.m_6669_();
        this.f_25598_.m_21573_().m_26519_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, this.f_25599_);
    }

    public boolean m_8045_() {
        return super.m_8045_() && !this.stopFlag;
    }

    public void m_8041_() {
        this.f_25602_ = BlockPos.f_121853_;
        super.m_8041_();
        this.stopFlag = false;
    }

    private int getHeightOfBlock(LevelReader worldIn, BlockPos pos) {
        int i = 0;
        while (pos.m_123342_() > worldIn.m_141937_() && (worldIn.m_8055_(pos).m_204336_(ACTagRegistry.RELICHEIRUS_NIBBLES) || worldIn.m_8055_(pos).m_60795_() || worldIn.m_8055_(pos).m_204336_(ACTagRegistry.RELICHEIRUS_KNOCKABLE_LOGS))) {
            pos = pos.m_7495_();
            ++i;
        }
        return i;
    }

    private boolean highEnough(LevelReader worldIn, BlockPos pos) {
        int height = this.getHeightOfBlock(worldIn, pos);
        if (this.atlatitan.m_6162_()) {
            return height <= 2;
        }
        return height > 3 && height < 20;
    }

    protected boolean m_6465_(LevelReader worldIn, BlockPos pos) {
        return worldIn.m_8055_(pos).m_204336_(ACTagRegistry.RELICHEIRUS_NIBBLES) && this.highEnough(worldIn, pos);
    }

    private boolean canReach(BlockPos target) {
        int k;
        int j;
        Path path = this.atlatitan.m_21573_().m_7864_(target, 0);
        if (path == null) {
            return false;
        }
        Node node = path.m_77395_();
        if (node == null) {
            return false;
        }
        int i = node.f_77271_ - target.m_123341_();
        return (double)(i * i + (j = node.f_77272_ - target.m_123342_()) * j + (k = node.f_77273_ - target.m_123343_()) * k) <= 3.0;
    }
}

