/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.mixin;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.MagneticLevitationRailBlock;
import com.github.alexmodguy.alexscaves.server.entity.util.MinecartAccessor;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractMinecart.class})
public abstract class AbstractMinecartMixin
extends Entity
implements MinecartAccessor {
    @Shadow
    private boolean f_38068_;
    @Shadow
    private int f_38070_;
    @Shadow
    private double f_38071_;
    @Shadow
    private double f_38072_;
    @Shadow
    private double f_38073_;
    @Shadow
    private double f_38074_;
    @Shadow
    private double f_38075_;
    private BlockPos lastMagLevCheck = null;
    private BlockPos magLevBelow = null;
    private float magLevProgress = 0.0f;
    private float prevMagLevProgress = 0.0f;

    @Shadow
    public abstract int m_38176_();

    @Shadow
    public abstract void m_38154_(int var1);

    @Shadow
    public abstract void m_38109_(float var1);

    @Shadow
    public abstract float m_38169_();

    @Shadow
    @Nullable
    public abstract Vec3 m_38179_(double var1, double var3, double var5);

    @Shadow
    private static Pair<Vec3i, Vec3i> m_38125_(RailShape p_38126_) {
        return null;
    }

    @Shadow
    protected abstract void m_7114_();

    @Shadow
    protected abstract boolean m_38129_(BlockPos var1);

    @Shadow
    public abstract boolean m_288188_();

    public AbstractMinecartMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"Lnet/minecraft/world/entity/vehicle/AbstractMinecart;tick()V"}, at={@At(value="HEAD")}, cancellable=true)
    public void ac_tick(CallbackInfo ci) {
        this.prevMagLevProgress = this.magLevProgress;
        if (this.lastMagLevCheck == null || !this.lastMagLevCheck.equals((Object)this.m_20183_())) {
            this.lastMagLevCheck = this.m_20183_();
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(this.m_20185_(), this.m_20186_(), this.m_20189_());
            boolean flag = false;
            for (int i = 0; i < 3; ++i) {
                if (this.m_9236_().m_8055_((BlockPos)mutableBlockPos).m_60713_((Block)ACBlockRegistry.MAGNETIC_LEVITATION_RAIL.get())) {
                    flag = true;
                    break;
                }
                mutableBlockPos.m_122184_(0, -1, 0);
            }
            BlockPos blockPos = this.magLevBelow = flag ? mutableBlockPos.m_7949_() : null;
        }
        if (this.magLevBelow != null) {
            BlockState magLevBlockState;
            if (this.magLevProgress < 1.0f) {
                this.magLevProgress += 0.2f;
            }
            if ((magLevBlockState = this.m_9236_().m_8055_(this.magLevBelow)).m_60713_((Block)ACBlockRegistry.MAGNETIC_LEVITATION_RAIL.get())) {
                ci.cancel();
                if (this.m_38176_() > 0) {
                    this.m_38154_(this.m_38176_() - 1);
                }
                if (this.m_38169_() > 0.0f) {
                    this.m_38109_(this.m_38169_() - 1.0f);
                }
                this.m_146871_();
                this.m_20157_();
                if (this.m_9236_().f_46443_) {
                    if (this.f_38070_ > 0) {
                        double d5 = this.m_20185_() + (this.f_38071_ - this.m_20185_()) / (double)this.f_38070_;
                        double d6 = this.m_20186_() + (this.f_38072_ - this.m_20186_()) / (double)this.f_38070_;
                        double d7 = this.m_20189_() + (this.f_38073_ - this.m_20189_()) / (double)this.f_38070_;
                        double d2 = Mth.m_14175_((double)(this.f_38074_ - (double)this.m_146908_()));
                        this.m_146922_(this.m_146908_() + (float)d2 / (float)this.f_38070_);
                        this.m_146926_(this.m_146909_() + (float)(this.f_38075_ - (double)this.m_146909_()) / (float)this.f_38070_);
                        --this.f_38070_;
                        this.m_6034_(d5, d6, d7);
                        this.m_19915_(this.m_146908_(), this.m_146909_());
                    } else {
                        this.m_20090_();
                        this.m_19915_(this.m_146908_(), this.m_146909_());
                    }
                } else {
                    double d4;
                    if (!this.m_20068_()) {
                        double d0 = this.m_20069_() ? -0.005 : -0.04;
                        this.m_20256_(this.m_20184_().m_82520_(0.0, d0, 0.0));
                    }
                    this.moveAlongMagLev(this.magLevBelow, magLevBlockState);
                    this.m_20101_();
                    this.m_146926_(0.0f);
                    double d1 = this.f_19854_ - this.m_20185_();
                    double d3 = this.f_19856_ - this.m_20189_();
                    if (d1 * d1 + d3 * d3 > 0.001) {
                        this.m_146922_((float)(Mth.m_14136_((double)d3, (double)d1) * 180.0 / Math.PI));
                        if (this.f_38068_) {
                            this.m_146922_(this.m_146908_() + 180.0f);
                        }
                    }
                    if ((d4 = (double)Mth.m_14177_((float)(this.m_146908_() - this.f_19859_))) < -170.0 || d4 >= 170.0) {
                        this.m_146922_(this.m_146908_() + 180.0f);
                        this.f_38068_ = !this.f_38068_;
                    }
                    this.m_19915_(this.m_146908_(), this.m_146909_());
                    AABB box = this.m_20191_().m_82377_((double)0.2f, 0.0, (double)0.2f);
                    if (((AbstractMinecart)this).canBeRidden() && this.m_20184_().m_165925_() > 0.01) {
                        List list = this.m_9236_().m_6249_((Entity)this, box, EntitySelector.m_20421_((Entity)this));
                        if (!list.isEmpty()) {
                            for (int l = 0; l < list.size(); ++l) {
                                Entity entity1 = (Entity)list.get(l);
                                if (!(entity1 instanceof Player || entity1 instanceof IronGolem || entity1 instanceof AbstractMinecart || this.m_20160_() || entity1.m_20159_())) {
                                    entity1.m_20329_((Entity)this);
                                    continue;
                                }
                                entity1.m_7334_((Entity)this);
                            }
                        }
                    } else {
                        for (Entity entity : this.m_9236_().m_45933_((Entity)this, box)) {
                            if (this.m_20363_(entity) || !entity.m_6094_() || !(entity instanceof AbstractMinecart)) continue;
                            entity.m_7334_((Entity)this);
                        }
                    }
                    this.m_20073_();
                    if (this.m_20077_()) {
                        this.m_20093_();
                        this.f_19789_ *= 0.5f;
                    }
                    this.f_19803_ = false;
                }
            }
            if (this.m_9236_().f_46443_ && this.f_19796_.m_188501_() < 0.4f) {
                Vec3 randomLightningFrom = this.magLevBelow.m_252807_().m_82520_((double)(this.f_19796_.m_188501_() - 0.5f), (double)-0.4f, (double)(this.f_19796_.m_188501_() - 0.5f));
                Vec3 vec3 = this.m_20182_().m_82549_(this.m_20184_()).m_82549_(new Vec3((double)(this.f_19796_.m_188501_() - 0.5f), (double)0.2f, (double)(this.f_19796_.m_188501_() - 0.5f)));
                this.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.AZURE_SHIELD_LIGHTNING.get(), randomLightningFrom.f_82479_, randomLightningFrom.f_82480_, randomLightningFrom.f_82481_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            }
        } else if (this.magLevProgress > 0.0f) {
            this.magLevProgress -= 0.2f;
            if (!this.m_288188_()) {
                this.m_20256_(this.m_20184_().m_82542_(1.5, 1.0, 1.5).m_82520_(0.0, (double)0.1f, 0.0));
            }
        }
    }

    private void moveAlongMagLev(BlockPos railPos, BlockState railState) {
        double d14;
        boolean doRailFunctions = ((AbstractMinecart)this).shouldDoRailFunctions();
        this.m_183634_();
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        Vec3 vec3 = this.m_38179_(d0, d1, d2);
        boolean flag = true;
        boolean flag1 = true;
        double d3 = ((AbstractMinecart)this).getSlopeAdjustment();
        if (this.m_20069_()) {
            d3 *= 0.2;
        }
        Vec3 vec31 = this.m_20184_();
        RailShape railshape = ((BaseRailBlock)railState.m_60734_()).getRailDirection(railState, (BlockGetter)this.m_9236_(), railPos, (AbstractMinecart)this);
        switch (railshape) {
            case ASCENDING_EAST: {
                this.m_20256_(vec31.m_82520_(-d3, 0.0, 0.0));
                d1 += 1.0;
                break;
            }
            case ASCENDING_WEST: {
                this.m_20256_(vec31.m_82520_(d3, 0.0, 0.0));
                d1 += 1.0;
                break;
            }
            case ASCENDING_NORTH: {
                this.m_20256_(vec31.m_82520_(0.0, 0.0, d3));
                d1 += 1.0;
                break;
            }
            case ASCENDING_SOUTH: {
                this.m_20256_(vec31.m_82520_(0.0, 0.0, -d3));
                d1 += 1.0;
            }
        }
        vec31 = this.m_20184_();
        Pair<Vec3i, Vec3i> pair = AbstractMinecartMixin.m_38125_(railshape);
        Vec3i vec3i = (Vec3i)pair.getFirst();
        Vec3i vec3i1 = (Vec3i)pair.getSecond();
        double d4 = vec3i1.m_123341_() - vec3i.m_123341_();
        double d5 = vec3i1.m_123343_() - vec3i.m_123343_();
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        double d7 = vec31.f_82479_ * d4 + vec31.f_82481_ * d5;
        if (d7 < 0.0) {
            d4 = -d4;
            d5 = -d5;
        }
        double d8 = Math.min(2.0, vec31.m_165924_());
        vec31 = new Vec3(d8 * d4 / d6, vec31.f_82480_, d8 * d5 / d6);
        this.m_20256_(vec31);
        Entity entity = this.m_146895_();
        if (entity instanceof Player) {
            Vec3 vec32 = entity.m_20184_();
            double d9 = vec32.m_165925_();
            double d11 = this.m_20184_().m_165925_();
            if (d9 > 1.0E-4 && d11 < 0.01) {
                this.m_20256_(this.m_20184_().m_82520_(vec32.f_82479_ * 0.1, 0.0, vec32.f_82481_ * 0.1));
                flag1 = false;
            }
        }
        if (flag1 && doRailFunctions) {
            double d22 = this.m_20184_().m_165924_();
            if (d22 < 0.03) {
                this.m_20256_(Vec3.f_82478_);
            } else {
                this.m_20256_(this.m_20184_().m_82542_(0.5, 0.0, 0.5));
            }
        }
        double d23 = (double)railPos.m_123341_() + 0.5 + (double)vec3i.m_123341_() * 0.5;
        double d10 = (double)railPos.m_123343_() + 0.5 + (double)vec3i.m_123343_() * 0.5;
        double d12 = (double)railPos.m_123341_() + 0.5 + (double)vec3i1.m_123341_() * 0.5;
        double d13 = (double)railPos.m_123343_() + 0.5 + (double)vec3i1.m_123343_() * 0.5;
        d4 = d12 - d23;
        d5 = d13 - d10;
        if (d4 == 0.0) {
            d14 = d2 - (double)railPos.m_123343_();
        } else if (d5 == 0.0) {
            d14 = d0 - (double)railPos.m_123341_();
        } else {
            double d15 = d0 - d23;
            double d16 = d2 - d10;
            d14 = (d15 * d4 + d16 * d5) * 2.0;
        }
        d0 = d23 + d4 * d14;
        d2 = d10 + d5 * d14;
        this.m_6034_(d0, d1, d2);
        Vec3 idealPos = new Vec3(this.m_20185_(), (double)((float)this.magLevBelow.m_123342_() + 1.5f) + Math.sin((double)this.f_19797_ * 0.2) * 0.5, this.m_20189_());
        this.m_20256_(this.m_20184_().m_82549_(idealPos.m_82546_(this.m_20182_()).m_82490_((double)0.2f)));
        this.moveMinecartOnMagLev(railPos);
        if (vec3i.m_123342_() != 0 && Mth.m_14107_((double)this.m_20185_()) - railPos.m_123341_() == vec3i.m_123341_() && Mth.m_14107_((double)this.m_20189_()) - railPos.m_123343_() == vec3i.m_123343_()) {
            this.m_6034_(this.m_20185_(), this.m_20186_() + (double)vec3i.m_123342_(), this.m_20189_());
        } else if (vec3i1.m_123342_() != 0 && Mth.m_14107_((double)this.m_20185_()) - railPos.m_123341_() == vec3i1.m_123341_() && Mth.m_14107_((double)this.m_20189_()) - railPos.m_123343_() == vec3i1.m_123343_()) {
            this.m_6034_(this.m_20185_(), this.m_20186_() + (double)vec3i1.m_123342_(), this.m_20189_());
        }
        Vec3 vec33 = this.m_38179_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        if (vec33 != null && vec3 != null) {
            double d17 = (vec3.f_82480_ - vec33.f_82480_) * 0.05;
            Vec3 vec34 = this.m_20184_();
            double d18 = vec34.m_165924_();
            if (d18 > 0.0) {
                this.m_20256_(vec34.m_82542_((d18 + d17) / d18, (double)0.3f, (d18 + d17) / d18));
            }
        }
        int j = Mth.m_14107_((double)this.m_20185_());
        int i = Mth.m_14107_((double)this.m_20189_());
        if (j != railPos.m_123341_() || i != railPos.m_123343_()) {
            Vec3 vec35 = this.m_20184_();
            double d26 = vec35.m_165924_();
            this.m_20334_(d26 * (double)(j - railPos.m_123341_()), vec35.f_82480_, d26 * (double)(i - railPos.m_123343_()));
        }
        if (doRailFunctions) {
            ((BaseRailBlock)railState.m_60734_()).onMinecartPass(railState, this.m_9236_(), railPos, (AbstractMinecart)this);
        }
        if (flag && doRailFunctions) {
            Vec3 vec36 = this.m_20184_();
            double d27 = vec36.m_165924_();
            if (d27 > 0.01) {
                double d19 = 1.0;
                this.m_20256_(vec36.m_82520_(vec36.f_82479_ / d27 * d19, 0.0, vec36.f_82481_ / d27 * d19));
            } else {
                Vec3 vec37 = this.m_20184_();
                double d20 = vec37.f_82479_;
                double d21 = vec37.f_82481_;
                if (railshape == RailShape.EAST_WEST) {
                    if (this.m_38129_(railPos.m_122024_())) {
                        d20 = 0.02;
                    } else if (this.m_38129_(railPos.m_122029_())) {
                        d20 = -0.02;
                    }
                } else {
                    if (railshape != RailShape.NORTH_SOUTH) {
                        return;
                    }
                    if (this.m_38129_(railPos.m_122012_())) {
                        d21 = 0.02;
                    } else if (this.m_38129_(railPos.m_122019_())) {
                        d21 = -0.02;
                    }
                }
                this.m_20334_(d20, vec37.f_82480_, d21);
            }
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/vehicle/AbstractMinecart;getPos(DDD)Lnet/minecraft/world/phys/Vec3;"}, remap=true, at={@At(value="RETURN")}, cancellable=true)
    public void ac_getPos(double x, double y, double z, CallbackInfoReturnable<Vec3> cir) {
        double magLevAmount = this.prevMagLevProgress + (this.magLevProgress - this.prevMagLevProgress) * AlexsCaves.PROXY.getPartialTicks();
        if (magLevAmount >= 0.0) {
            double yClientSide = this.f_19791_ + (this.m_20186_() - this.f_19791_) * (double)AlexsCaves.PROXY.getPartialTicks();
            Vec3 prev = (Vec3)cir.getReturnValue();
            Vec3 modified = prev == null ? this.m_20318_(AlexsCaves.PROXY.getPartialTicks()) : new Vec3(prev.f_82479_, prev.f_82480_ + (yClientSide - prev.f_82480_) * magLevAmount, prev.f_82481_);
            cir.setReturnValue((Object)modified);
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/vehicle/AbstractMinecart;getPosOffs(DDDD)Lnet/minecraft/world/phys/Vec3;"}, remap=true, at={@At(value="RETURN")}, cancellable=true)
    public void ac_getPosOffs(double x, double y, double z, double offset, CallbackInfoReturnable<Vec3> cir) {
        double magLevAmount = this.prevMagLevProgress + (this.magLevProgress - this.prevMagLevProgress) * AlexsCaves.PROXY.getPartialTicks();
        if (magLevAmount >= 0.0) {
            double yClientSide = this.f_19791_ + (this.m_20186_() - this.f_19791_) * (double)AlexsCaves.PROXY.getPartialTicks();
            Vec3 prev = (Vec3)cir.getReturnValue();
            Vec3 modified = prev == null ? this.m_20318_(AlexsCaves.PROXY.getPartialTicks()) : new Vec3(prev.f_82479_, prev.f_82480_ + (yClientSide - prev.f_82480_) * magLevAmount, prev.f_82481_);
            cir.setReturnValue((Object)modified);
        }
    }

    public void moveMinecartOnMagLev(BlockPos pos) {
        BlockState magLevState;
        Block block;
        double d24 = this.m_20160_() ? 0.75 : 1.0;
        double d25 = 0.05f;
        if (this.magLevBelow != null && (block = (magLevState = this.m_9236_().m_8055_(this.magLevBelow)).m_60734_()) instanceof MagneticLevitationRailBlock) {
            MagneticLevitationRailBlock magRailBlock = (MagneticLevitationRailBlock)block;
            d25 = magRailBlock.getRailMaxSpeed(magLevState, this.m_9236_(), pos, (AbstractMinecart)this);
        }
        Vec3 vec3d1 = this.m_20184_();
        this.m_6478_(MoverType.SELF, new Vec3(Mth.m_14008_((double)(d24 * vec3d1.f_82479_), (double)(-d25), (double)d25), vec3d1.f_82480_, Mth.m_14008_((double)(d24 * vec3d1.f_82481_), (double)(-d25), (double)d25)));
    }

    @Override
    public boolean isOnMagLevRail() {
        return this.magLevProgress >= 0.5f;
    }
}

