/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.particle;

import com.github.alexmodguy.alexscaves.client.particle.AbstractTrailParticle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MagneticOrbitParticle
extends AbstractTrailParticle {
    private static final ResourceLocation TRAIL_TEXTURE = new ResourceLocation("alexscaves", "textures/particle/trail.png");
    protected double orbitX;
    protected double orbitY;
    protected double orbitZ;
    protected double orbitDistance;
    protected Vec3 orbitOffset;
    protected boolean reverseOrbit;
    protected int orbitAxis;
    protected float orbitSpeed = 1.0f;

    public MagneticOrbitParticle(ClientLevel world, double x, double y, double z, double xd, double yd, double zd) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.trailA = 0.8f;
        this.f_107225_ = 50 + this.f_107223_.m_188503_(30);
        this.f_107226_ = 0.0f;
        this.orbitX = xd;
        this.orbitY = yd;
        this.orbitZ = zd;
        this.orbitDistance = 1.0;
        this.orbitOffset = new Vec3(this.f_107223_.m_188500_() - 0.5, this.f_107223_.m_188500_() - 0.5, this.f_107223_.m_188500_() - 0.5);
        this.reverseOrbit = this.f_107223_.m_188499_();
        this.orbitAxis = this.f_107223_.m_188503_(2);
        this.orbitSpeed = 1.0f + this.f_107223_.m_188501_() * 3.0f;
    }

    public Vec3 getOrbitPosition(float angle) {
        Vec3 center = new Vec3(this.orbitX, this.orbitY, this.orbitZ);
        Vec3 add = this.orbitOffset.m_82490_(this.orbitDistance);
        float rot = angle * (this.reverseOrbit ? -this.orbitSpeed : this.orbitSpeed) * ((float)Math.PI / 180);
        switch (this.orbitAxis) {
            case 0: {
                add = add.m_82496_(rot);
                break;
            }
            case 1: {
                add = add.m_82524_(rot);
                break;
            }
            case 2: {
                add = add.m_82535_(rot);
            }
        }
        return center.m_82549_(add);
    }

    @Override
    public void m_5989_() {
        Vec3 vec3 = this.getOrbitPosition(this.f_107224_);
        Vec3 movement = vec3.m_82492_(this.f_107212_, this.f_107213_, this.f_107214_).m_82541_().m_82490_((double)(this.orbitSpeed * 0.01f));
        this.f_107215_ += movement.f_82479_;
        this.f_107216_ += movement.f_82480_;
        this.f_107217_ += movement.f_82481_;
        float fade = 1.0f - (float)this.f_107224_ / (float)this.f_107225_;
        this.trailA = 0.8f * fade;
        super.m_5989_();
    }

    @Override
    public float getTrailHeight() {
        return 0.25f;
    }

    public int m_6355_(float f) {
        return 240;
    }

    @Override
    public ResourceLocation getTrailTexture() {
        return TRAIL_TEXTURE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class AzureFactory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            MagneticOrbitParticle particle = new MagneticOrbitParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.trailR = 0.2f + worldIn.f_46441_.m_188501_() * 0.05f;
            particle.trailG = 0.2f + worldIn.f_46441_.m_188501_() * 0.05f;
            particle.trailB = 0.9f + worldIn.f_46441_.m_188501_() * 0.1f;
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ScarletFactory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            MagneticOrbitParticle particle = new MagneticOrbitParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.trailR = 0.9f + worldIn.f_46441_.m_188501_() * 0.1f;
            particle.trailG = 0.2f + worldIn.f_46441_.m_188501_() * 0.05f;
            particle.trailB = 0.2f + worldIn.f_46441_.m_188501_() * 0.05f;
            return particle;
        }
    }
}

