/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.transmission;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.content.kinetics.RotationPropagator;
import com.simibubi.create.content.kinetics.base.AbstractEncasedShaftBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.transmission.SplitShaftBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.ticks.TickPriority;

public class GearshiftBlock
extends AbstractEncasedShaftBlock
implements IBE<SplitShaftBlockEntity> {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public GearshiftBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED});
        super.m_7926_(builder);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(context.m_43725_().m_276867_(context.m_8083_())));
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.f_46443_) {
            return;
        }
        boolean previouslyPowered = (Boolean)state.m_61143_((Property)POWERED);
        if (previouslyPowered != worldIn.m_276867_(pos)) {
            this.detachKinetics(worldIn, pos, true);
            worldIn.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
        }
    }

    @Override
    public Class<SplitShaftBlockEntity> getBlockEntityClass() {
        return SplitShaftBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends SplitShaftBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.GEARSHIFT.get();
    }

    public void detachKinetics(Level worldIn, BlockPos pos, boolean reAttachNextTick) {
        BlockEntity be = worldIn.m_7702_(pos);
        if (be == null || !(be instanceof KineticBlockEntity)) {
            return;
        }
        RotationPropagator.handleRemoved(worldIn, pos, (KineticBlockEntity)be);
        if (reAttachNextTick) {
            worldIn.m_186464_(pos, (Block)this, 1, TickPriority.EXTREMELY_HIGH);
        }
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        BlockEntity be = worldIn.m_7702_(pos);
        if (be == null || !(be instanceof KineticBlockEntity)) {
            return;
        }
        KineticBlockEntity kte = (KineticBlockEntity)be;
        RotationPropagator.handleAdded((Level)worldIn, pos, kte);
    }
}

