/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.mechanicalArm;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.api.registry.CreateBuiltInRegistries;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.crafter.MechanicalCrafterBlock;
import com.simibubi.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.simibubi.create.content.kinetics.deployer.DeployerBlock;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPointType;
import com.simibubi.create.content.kinetics.saw.SawBlock;
import com.simibubi.create.content.logistics.chute.AbstractChuteBlock;
import com.simibubi.create.content.logistics.funnel.AbstractFunnelBlock;
import com.simibubi.create.content.logistics.funnel.BeltFunnelBlock;
import com.simibubi.create.content.logistics.funnel.FunnelBlock;
import com.simibubi.create.content.logistics.funnel.FunnelBlockEntity;
import com.simibubi.create.content.logistics.tunnel.BeltTunnelBlock;
import com.simibubi.create.content.processing.basin.BasinBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import java.util.Optional;
import javax.annotation.Nullable;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class AllArmInteractionPointTypes {
    private static <T extends ArmInteractionPointType> void register(String name, T type) {
        Registry.m_122965_(CreateBuiltInRegistries.ARM_INTERACTION_POINT_TYPE, (ResourceLocation)Create.asResource(name), type);
    }

    public static void init() {
    }

    static {
        AllArmInteractionPointTypes.register("basin", new BasinType());
        AllArmInteractionPointTypes.register("belt", new BeltType());
        AllArmInteractionPointTypes.register("blaze_burner", new BlazeBurnerType());
        AllArmInteractionPointTypes.register("chute", new ChuteType());
        AllArmInteractionPointTypes.register("crafter", new CrafterType());
        AllArmInteractionPointTypes.register("crushing_wheels", new CrushingWheelsType());
        AllArmInteractionPointTypes.register("deployer", new DeployerType());
        AllArmInteractionPointTypes.register("depot", new DepotType());
        AllArmInteractionPointTypes.register("funnel", new FunnelType());
        AllArmInteractionPointTypes.register("millstone", new MillstoneType());
        AllArmInteractionPointTypes.register("packager", new PackagerType());
        AllArmInteractionPointTypes.register("saw", new SawType());
        AllArmInteractionPointTypes.register("campfire", new CampfireType());
        AllArmInteractionPointTypes.register("composter", new ComposterType());
        AllArmInteractionPointTypes.register("jukebox", new JukeboxType());
        AllArmInteractionPointTypes.register("respawn_anchor", new RespawnAnchorType());
    }

    public static class BasinType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return BasinBlock.isBasin((LevelReader)level, pos);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new ArmInteractionPoint(this, level, pos, state);
        }
    }

    public static class BeltType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return AllBlocks.BELT.has(state) && !(level.m_8055_(pos.m_7494_()).m_60734_() instanceof BeltTunnelBlock) && BeltBlock.canTransportObjects(state);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new BeltPoint(this, level, pos, state);
        }
    }

    public static class BlazeBurnerType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return AllBlocks.BLAZE_BURNER.has(state);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new BlazeBurnerPoint(this, level, pos, state);
        }
    }

    public static class ChuteType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return AbstractChuteBlock.isChute(state);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new TopFaceArmInteractionPoint(this, level, pos, state);
        }
    }

    public static class CrafterType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return AllBlocks.MECHANICAL_CRAFTER.has(state);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new CrafterPoint(this, level, pos, state);
        }
    }

    public static class CrushingWheelsType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return AllBlocks.CRUSHING_WHEEL_CONTROLLER.has(state);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new CrushingWheelPoint(this, level, pos, state);
        }
    }

    public static class DeployerType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return AllBlocks.DEPLOYER.has(state);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new DeployerPoint(this, level, pos, state);
        }
    }

    public static class DepotType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return AllBlocks.DEPOT.has(state) || AllBlocks.WEIGHTED_EJECTOR.has(state) || AllBlocks.TRACK_STATION.has(state);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new DepotPoint(this, level, pos, state);
        }
    }

    public static class FunnelType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return !(!(state.m_60734_() instanceof AbstractFunnelBlock) || state.m_61138_((Property)FunnelBlock.EXTRACTING) && (Boolean)state.m_61143_((Property)FunnelBlock.EXTRACTING) != false || state.m_61138_(BeltFunnelBlock.SHAPE) && state.m_61143_(BeltFunnelBlock.SHAPE) == BeltFunnelBlock.Shape.PUSHING);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new FunnelPoint(this, level, pos, state);
        }
    }

    public static class MillstoneType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return AllBlocks.MILLSTONE.has(state);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new ArmInteractionPoint(this, level, pos, state);
        }
    }

    public static class PackagerType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return AllBlocks.PACKAGER.has(state) || AllBlocks.REPACKAGER.has(state);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new ArmInteractionPoint(this, level, pos, state);
        }
    }

    public static class SawType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return AllBlocks.MECHANICAL_SAW.has(state) && state.m_61143_((Property)SawBlock.FACING) == Direction.UP && ((KineticBlockEntity)level.m_7702_(pos)).getSpeed() != 0.0f;
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new DepotPoint(this, level, pos, state);
        }
    }

    public static class CampfireType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return state.m_60734_() instanceof CampfireBlock;
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new CampfirePoint(this, level, pos, state);
        }
    }

    public static class ComposterType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return state.m_60713_(Blocks.f_50715_);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new ComposterPoint(this, level, pos, state);
        }
    }

    public static class JukeboxType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return state.m_60713_(Blocks.f_50131_);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new JukeboxPoint(this, level, pos, state);
        }
    }

    public static class RespawnAnchorType
    extends ArmInteractionPointType {
        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return state.m_60713_(Blocks.f_50724_);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new RespawnAnchorPoint(this, level, pos, state);
        }
    }

    public static class CrushingWheelPoint
    extends DepositOnlyArmInteractionPoint {
        public CrushingWheelPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        protected Vec3 getInteractionPositionVector() {
            return Vec3.m_82528_((Vec3i)this.pos).m_82520_(0.5, 1.0, 0.5);
        }
    }

    public static class RespawnAnchorPoint
    extends DepositOnlyArmInteractionPoint {
        public RespawnAnchorPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        protected Vec3 getInteractionPositionVector() {
            return Vec3.m_82528_((Vec3i)this.pos).m_82520_(0.5, 1.0, 0.5);
        }

        @Override
        public ItemStack insert(ItemStack stack, boolean simulate) {
            if (!stack.m_150930_(Items.f_42054_)) {
                return stack;
            }
            if (this.cachedState.m_61145_((Property)RespawnAnchorBlock.f_55833_).orElse(4) == 4) {
                return stack;
            }
            if (!simulate) {
                RespawnAnchorBlock.m_269573_(null, (Level)this.level, (BlockPos)this.pos, (BlockState)this.cachedState);
            }
            ItemStack remainder = stack.m_41777_();
            remainder.m_41774_(1);
            return remainder;
        }
    }

    public static class JukeboxPoint
    extends TopFaceArmInteractionPoint {
        public JukeboxPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        public int getSlotCount() {
            return 1;
        }

        @Override
        public ItemStack insert(ItemStack stack, boolean simulate) {
            if (!(stack.m_41720_() instanceof RecordItem)) {
                return stack;
            }
            if (this.cachedState.m_61145_((Property)JukeboxBlock.f_54254_).orElse(true).booleanValue()) {
                return stack;
            }
            BlockEntity blockEntity = this.level.m_7702_(this.pos);
            if (!(blockEntity instanceof JukeboxBlockEntity)) {
                return stack;
            }
            JukeboxBlockEntity jukeboxBE = (JukeboxBlockEntity)blockEntity;
            if (!jukeboxBE.m_272036_().m_41619_()) {
                return stack;
            }
            ItemStack remainder = stack.m_41777_();
            ItemStack toInsert = remainder.m_41620_(1);
            if (!simulate) {
                jukeboxBE.m_6836_(0, toInsert);
            }
            return remainder;
        }

        @Override
        public ItemStack extract(int slot, int amount, boolean simulate) {
            if (!this.cachedState.m_61145_((Property)JukeboxBlock.f_54254_).orElse(false).booleanValue()) {
                return ItemStack.f_41583_;
            }
            BlockEntity blockEntity = this.level.m_7702_(this.pos);
            if (!(blockEntity instanceof JukeboxBlockEntity)) {
                return ItemStack.f_41583_;
            }
            JukeboxBlockEntity jukeboxBE = (JukeboxBlockEntity)blockEntity;
            if (!simulate) {
                return jukeboxBE.m_7407_(slot, amount);
            }
            return jukeboxBE.m_272036_();
        }
    }

    public static class ComposterPoint
    extends ArmInteractionPoint {
        public ComposterPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        protected Vec3 getInteractionPositionVector() {
            return Vec3.m_82528_((Vec3i)this.pos).m_82520_(0.5, 0.8125, 0.5);
        }

        @Override
        public void updateCachedState() {
            BlockState oldState = this.cachedState;
            super.updateCachedState();
            if (oldState != this.cachedState) {
                this.cachedHandler.invalidate();
            }
        }

        @Override
        @Nullable
        protected IItemHandler getHandler() {
            return null;
        }

        protected WorldlyContainer getContainer() {
            ComposterBlock composterBlock = (ComposterBlock)Blocks.f_50715_;
            return composterBlock.m_5840_(this.cachedState, (LevelAccessor)this.level, this.pos);
        }

        @Override
        public ItemStack insert(ItemStack stack, boolean simulate) {
            SidedInvWrapper handler = new SidedInvWrapper(this.getContainer(), Direction.UP);
            return ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)simulate);
        }

        @Override
        public ItemStack extract(int slot, int amount, boolean simulate) {
            SidedInvWrapper handler = new SidedInvWrapper(this.getContainer(), Direction.DOWN);
            return handler.extractItem(slot, amount, simulate);
        }

        @Override
        public int getSlotCount() {
            return 2;
        }
    }

    public static class CampfirePoint
    extends DepositOnlyArmInteractionPoint {
        public CampfirePoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        public ItemStack insert(ItemStack stack, boolean simulate) {
            BlockEntity blockEntity = this.level.m_7702_(this.pos);
            if (!(blockEntity instanceof CampfireBlockEntity)) {
                return stack;
            }
            CampfireBlockEntity campfireBE = (CampfireBlockEntity)blockEntity;
            Optional recipe = campfireBE.m_59051_(stack);
            if (recipe.isEmpty()) {
                return stack;
            }
            if (simulate) {
                boolean hasSpace = false;
                for (ItemStack campfireStack : campfireBE.m_59065_()) {
                    if (!campfireStack.m_41619_()) continue;
                    hasSpace = true;
                    break;
                }
                if (!hasSpace) {
                    return stack;
                }
                ItemStack remainder = stack.m_41777_();
                remainder.m_41774_(1);
                return remainder;
            }
            ItemStack remainder = stack.m_41777_();
            campfireBE.m_238284_(null, remainder, ((CampfireCookingRecipe)recipe.get()).m_43753_());
            return remainder;
        }
    }

    public static class FunnelPoint
    extends DepositOnlyArmInteractionPoint {
        public FunnelPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        protected Vec3 getInteractionPositionVector() {
            Direction funnelFacing = FunnelBlock.getFunnelFacing(this.cachedState);
            Vec3i normal = funnelFacing != null ? funnelFacing.m_122436_() : Vec3i.f_123288_;
            return VecHelper.getCenterOf((Vec3i)this.pos).m_82549_(Vec3.m_82528_((Vec3i)normal).m_82490_((double)-0.15f));
        }

        @Override
        protected Direction getInteractionDirection() {
            Direction funnelFacing = FunnelBlock.getFunnelFacing(this.cachedState);
            return funnelFacing != null ? funnelFacing.m_122424_() : Direction.UP;
        }

        @Override
        public void updateCachedState() {
            BlockState oldState = this.cachedState;
            super.updateCachedState();
            if (oldState != this.cachedState) {
                this.cachedAngles = null;
            }
        }

        @Override
        public ItemStack insert(ItemStack stack, boolean simulate) {
            BlockEntity blockEntity;
            FilteringBehaviour filtering = BlockEntityBehaviour.get((BlockGetter)this.level, this.pos, FilteringBehaviour.TYPE);
            InvManipulationBehaviour inserter = BlockEntityBehaviour.get((BlockGetter)this.level, this.pos, InvManipulationBehaviour.TYPE);
            if (this.cachedState.m_61145_((Property)BlockStateProperties.f_61448_).orElse(false).booleanValue()) {
                return stack;
            }
            if (inserter == null) {
                return stack;
            }
            if (filtering != null && !filtering.test(stack)) {
                return stack;
            }
            if (simulate) {
                inserter.simulate();
            }
            ItemStack insert = inserter.insert(stack);
            if (!simulate && insert.m_41613_() != stack.m_41613_() && (blockEntity = this.level.m_7702_(this.pos)) instanceof FunnelBlockEntity) {
                FunnelBlockEntity funnelBlockEntity = (FunnelBlockEntity)blockEntity;
                funnelBlockEntity.onTransfer(stack);
                if (funnelBlockEntity.hasFlap()) {
                    funnelBlockEntity.flap(true);
                }
            }
            return insert;
        }
    }

    public static class DepotPoint
    extends ArmInteractionPoint {
        public DepotPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        protected Vec3 getInteractionPositionVector() {
            return Vec3.m_82528_((Vec3i)this.pos).m_82520_(0.5, 0.875, 0.5);
        }
    }

    public static class DeployerPoint
    extends ArmInteractionPoint {
        public DeployerPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        protected Direction getInteractionDirection() {
            return this.cachedState.m_61145_((Property)DeployerBlock.FACING).orElse(Direction.UP).m_122424_();
        }

        @Override
        protected Vec3 getInteractionPositionVector() {
            return super.getInteractionPositionVector().m_82549_(Vec3.m_82528_((Vec3i)this.getInteractionDirection().m_122436_()).m_82490_((double)0.65f));
        }

        @Override
        public void updateCachedState() {
            BlockState oldState = this.cachedState;
            super.updateCachedState();
            if (oldState != this.cachedState) {
                this.cachedAngles = null;
            }
        }
    }

    public static class CrafterPoint
    extends ArmInteractionPoint {
        public CrafterPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        protected Direction getInteractionDirection() {
            return this.cachedState.m_61145_(MechanicalCrafterBlock.HORIZONTAL_FACING).orElse(Direction.SOUTH).m_122424_();
        }

        @Override
        protected Vec3 getInteractionPositionVector() {
            return super.getInteractionPositionVector().m_82549_(Vec3.m_82528_((Vec3i)this.getInteractionDirection().m_122436_()).m_82490_(0.5));
        }

        @Override
        public void updateCachedState() {
            BlockState oldState = this.cachedState;
            super.updateCachedState();
            if (oldState != this.cachedState) {
                this.cachedAngles = null;
            }
        }

        @Override
        public ItemStack extract(int slot, int amount, boolean simulate) {
            BlockEntity be = this.level.m_7702_(this.pos);
            if (!(be instanceof MechanicalCrafterBlockEntity)) {
                return ItemStack.f_41583_;
            }
            MechanicalCrafterBlockEntity crafter = (MechanicalCrafterBlockEntity)be;
            MechanicalCrafterBlockEntity.Inventory inventory = crafter.getInventory();
            inventory.allowExtraction();
            ItemStack extract = super.extract(slot, amount, simulate);
            inventory.forbidExtraction();
            return extract;
        }
    }

    public static class BlazeBurnerPoint
    extends DepositOnlyArmInteractionPoint {
        public BlazeBurnerPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        public ItemStack insert(ItemStack stack, boolean simulate) {
            ItemStack input = stack.m_41777_();
            InteractionResultHolder<ItemStack> res = BlazeBurnerBlock.tryInsert(this.cachedState, this.level, this.pos, input, false, false, simulate);
            ItemStack remainder = (ItemStack)res.m_19095_();
            if (input.m_41619_()) {
                return remainder;
            }
            if (!simulate) {
                Containers.m_18992_((Level)this.level, (double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_(), (ItemStack)remainder);
            }
            return input;
        }
    }

    public static class BeltPoint
    extends DepotPoint {
        public BeltPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        public void keepAlive() {
            super.keepAlive();
            BeltBlockEntity beltBE = BeltHelper.getSegmentBE((LevelAccessor)this.level, this.pos);
            if (beltBE == null) {
                return;
            }
            TransportedItemStackHandlerBehaviour transport = beltBE.getBehaviour(TransportedItemStackHandlerBehaviour.TYPE);
            if (transport == null) {
                return;
            }
            MutableBoolean found = new MutableBoolean(false);
            transport.handleProcessingOnAllItems(tis -> {
                if (found.isTrue()) {
                    return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
                }
                tis.lockedExternally = true;
                found.setTrue();
                return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
            });
        }
    }

    public static class TopFaceArmInteractionPoint
    extends ArmInteractionPoint {
        public TopFaceArmInteractionPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        protected Vec3 getInteractionPositionVector() {
            return Vec3.m_82528_((Vec3i)this.pos).m_82520_(0.5, 1.0, 0.5);
        }
    }

    public static class DepositOnlyArmInteractionPoint
    extends ArmInteractionPoint {
        public DepositOnlyArmInteractionPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        public void cycleMode() {
        }

        @Override
        public ItemStack extract(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        @Override
        public int getSlotCount() {
            return 0;
        }
    }
}

