/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.datagen;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.yirmiri.dungeonsdelight.core.registry.DDBlocks;
import vectorwing.farmersdelight.common.block.CabinetBlock;

public class DDBlockstateGen
extends BlockStateProvider {
    public DDBlockstateGen(PackOutput output, ExistingFileHelper helper) {
        super(output, "dungeonsdelight", helper);
    }

    protected void registerStatesAndModels() {
        this.cubeAllWithItem((Block)DDBlocks.WORMWOOD_PLANKS.get());
        this.stairsWithItem((StairBlock)DDBlocks.WORMWOOD_STAIRS.get(), (Block)DDBlocks.WORMWOOD_PLANKS.get());
        this.slabWithItem((SlabBlock)DDBlocks.WORMWOOD_SLAB.get(), (Block)DDBlocks.WORMWOOD_PLANKS.get());
        this.doorBlock((DoorBlock)DDBlocks.WORMWOOD_DOOR.get(), "wormwood", new ResourceLocation("dungeonsdelight:block/wormwood_door_bottom"), new ResourceLocation("dungeonsdelight:block/wormwood_door_top"));
        this.fenceWithItem((FenceBlock)DDBlocks.WORMWOOD_FENCE.get(), (Block)DDBlocks.WORMWOOD_PLANKS.get());
        this.fenceGateWithItem((FenceGateBlock)DDBlocks.WORMWOOD_FENCE_GATE.get(), (Block)DDBlocks.WORMWOOD_PLANKS.get());
        this.pressurePlateWithItem((PressurePlateBlock)DDBlocks.WORMWOOD_PRESSURE_PLATE.get(), (Block)DDBlocks.WORMWOOD_PLANKS.get());
        this.buttonWithItem((ButtonBlock)DDBlocks.WORMWOOD_BUTTON.get(), (Block)DDBlocks.WORMWOOD_PLANKS.get());
        this.trapdoorWithItem((TrapDoorBlock)DDBlocks.WORMWOOD_TRAPDOOR.get(), (Block)DDBlocks.WORMWOOD_TRAPDOOR.get());
        this.cubeAllWithItem((Block)DDBlocks.WORMWOOD_MOSAIC.get());
        this.stairsWithItem((StairBlock)DDBlocks.WORMWOOD_MOSAIC_STAIRS.get(), (Block)DDBlocks.WORMWOOD_MOSAIC.get());
        this.slabWithItem((SlabBlock)DDBlocks.WORMWOOD_MOSAIC_SLAB.get(), (Block)DDBlocks.WORMWOOD_MOSAIC.get());
        this.cabinetBlock((CabinetBlock)DDBlocks.WORMWOOD_CABINET.get(), "wormwood");
        this.cubeAllWithItem((Block)DDBlocks.SCULK_MAYO_BLOCK.get());
        this.cubeAllWithItem((Block)DDBlocks.WORMROOTS_BLOCK.get());
        this.specialCrateBlock((Block)DDBlocks.ROTBULB_CRATE.get(), "rotbulb");
        this.topBottomSideBlock((Block)DDBlocks.STAINED_SCRAP_BLOCK.get(), "stained_scrap_block");
        this.cubeAllWithItem((Block)DDBlocks.CUT_STAINED_SCRAP.get());
        this.stairsWithItem((StairBlock)DDBlocks.CUT_STAINED_SCRAP_STAIRS.get(), (Block)DDBlocks.CUT_STAINED_SCRAP.get());
        this.slabWithItem((SlabBlock)DDBlocks.CUT_STAINED_SCRAP_SLAB.get(), (Block)DDBlocks.CUT_STAINED_SCRAP.get());
        this.specialCrateBlock((Block)DDBlocks.POISONOUS_POTATO_CRATE.get(), "poisonous_potato");
        this.specialCrateBlock((Block)DDBlocks.ROTTEN_TOMATO_CRATE.get(), "rotten_tomato");
    }

    private String key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }

    private void cubeAllWithItem(Block block) {
        this.simpleBlockWithItem(block, this.cubeAll(block));
    }

    private void stairsWithItem(StairBlock block, Block blockTexture) {
        this.stairsBlock(block, this.blockTexture(blockTexture));
        this.simpleBlockItem((Block)block, (ModelFile)this.models().stairs(this.key((Block)block), this.blockTexture(blockTexture), this.blockTexture(blockTexture), this.blockTexture(blockTexture)));
    }

    private void slabWithItem(SlabBlock block, Block blockTexture) {
        this.slabBlock(block, this.blockTexture(blockTexture), this.blockTexture(blockTexture));
        this.simpleBlockItem((Block)block, (ModelFile)this.models().slab(this.key((Block)block), this.blockTexture(blockTexture), this.blockTexture(blockTexture), this.blockTexture(blockTexture)));
    }

    public void barsBlock(Block block, ResourceLocation pane, ResourceLocation edge) {
        this.paneBlockWithRenderType((IronBarsBlock)block, pane, edge, "cutout");
    }

    private void fenceWithItem(FenceBlock block, Block blockTexture) {
        this.fenceBlock(block, this.blockTexture(blockTexture));
        this.simpleBlockItem((Block)block, (ModelFile)this.models().fenceInventory(this.key((Block)block), this.blockTexture(blockTexture)));
    }

    private void fenceGateWithItem(FenceGateBlock block, Block blockTexture) {
        this.fenceGateBlock(block, this.blockTexture(blockTexture));
        this.simpleBlockItem((Block)block, (ModelFile)this.models().fenceGate(this.key((Block)block), this.blockTexture(blockTexture)));
    }

    private void pressurePlateWithItem(PressurePlateBlock block, Block blockTexture) {
        this.pressurePlateBlock(block, this.blockTexture(blockTexture));
        this.simpleBlockItem((Block)block, (ModelFile)this.models().pressurePlate(this.key((Block)block), this.blockTexture(blockTexture)));
    }

    private void buttonWithItem(ButtonBlock block, Block blockTexture) {
        this.buttonBlock(block, this.blockTexture(blockTexture));
    }

    private void trapdoorWithItem(TrapDoorBlock block, Block blockTexture) {
        this.trapdoorBlock(block, this.blockTexture(blockTexture), true);
        this.simpleBlockItem((Block)block, (ModelFile)this.models().trapdoorOrientableBottom(this.key((Block)block), this.blockTexture(blockTexture)));
    }

    public void topBottomSideBlock(Block block, String id) {
        this.simpleBlock(block, (ModelFile)this.models().cubeBottomTop(this.key(block), new ResourceLocation("dungeonsdelight", "block/" + id + "_side"), new ResourceLocation("dungeonsdelight", "block/" + id + "_bottom"), new ResourceLocation("dungeonsdelight", "block/" + id + "_top")));
    }

    public void specialCrateBlock(Block block, String cropName) {
        this.simpleBlock(block, (ModelFile)this.models().cubeBottomTop(this.key(block), new ResourceLocation("dungeonsdelight", "block/" + cropName + "_crate_side"), new ResourceLocation("dungeonsdelight", "block/" + cropName + "_crate_bottom"), new ResourceLocation("dungeonsdelight", "block/" + cropName + "_crate_top")));
    }

    public void cabinetBlock(CabinetBlock block, String woodType) {
        this.horizontalBlock((Block)block, state -> {
            String suffix = (Boolean)state.m_61143_((Property)CabinetBlock.OPEN) != false ? "_open" : "";
            return this.models().orientable(this.key((Block)block) + suffix, new ResourceLocation("dungeonsdelight", "block/" + woodType + "_cabinet_side"), new ResourceLocation("dungeonsdelight", "block/" + woodType + "_cabinet_front" + suffix), new ResourceLocation("dungeonsdelight", "block/" + woodType + "_cabinet_top"));
        });
    }
}

