/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.util;

import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.yirmiri.dungeonsdelight.core.init.DDDamageTypes;
import net.yirmiri.dungeonsdelight.core.registry.DDEffects;
import vectorwing.farmersdelight.common.registry.ModDamageTypes;
import vectorwing.farmersdelight.common.registry.ModEffects;

public class DDUtil {
    public static final List<MobEffect> NORMAL_EFFECTS = List.of(MobEffects.f_19600_, MobEffects.f_19603_, MobEffects.f_19617_, (MobEffect)ModEffects.NOURISHMENT.get(), (MobEffect)ModEffects.COMFORT.get(), MobEffects.f_19598_);
    public static final List<MobEffect> MONSTER_EFFECTS = List.of((MobEffect)DDEffects.DECISIVE.get(), (MobEffect)DDEffects.POUNCING.get(), (MobEffect)DDEffects.EXUDATION.get(), (MobEffect)DDEffects.VORACITY.get(), (MobEffect)DDEffects.TENACITY.get(), (MobEffect)DDEffects.BURROW_GUT.get());

    public static void skullHeartBlast(Level level, LivingEntity player, Entity attacked) {
        if (player.m_21023_((MobEffect)DDEffects.EXUDATION.get())) {
            level.m_6443_(LivingEntity.class, attacked.m_20191_().m_82400_(8.0 + (double)player.m_21124_((MobEffect)DDEffects.EXUDATION.get()).m_19564_()), DDUtil.getKnockbackPredicate(player, attacked, true)).forEach(entity -> {
                entity.m_6469_(ModDamageTypes.getSimpleDamageSource((Level)level, DDDamageTypes.SKULL_HEART_BLAST), 8.0f);
                Vec3 vec3d = entity.m_20182_().m_82546_(attacked.m_20182_());
                Vec3 vec3d2 = vec3d.m_82541_().m_82542_(0.75, 0.75, 0.75);
                entity.m_20334_(vec3d2.f_82479_, 0.25, vec3d2.f_82481_);
            });
        }
    }

    public static void applyEffectSwap(LivingEntity living, MobEffect oldEffect, MobEffect newEffect) {
        if (living.m_21023_(oldEffect)) {
            int duration = living.m_21124_(oldEffect).m_19557_();
            living.m_21195_(oldEffect);
            living.m_7292_(new MobEffectInstance(newEffect, duration, 0));
        }
    }

    public static void spreadParticles(ParticleOptions particle, Entity entity, Random random) {
        for (int i = 0; i < 5; ++i) {
            double d0 = random.nextGaussian() * 0.02;
            double d1 = random.nextGaussian() * 0.02;
            double d2 = random.nextGaussian() * 0.02;
            entity.m_9236_().m_7106_(particle, entity.m_20208_(1.0), entity.m_20187_() + 1.0, entity.m_20262_(1.0), d0, d1, d2);
        }
    }

    private static Predicate<LivingEntity> getKnockbackPredicate(LivingEntity player, Entity attacked, boolean dontEffectPlayers) {
        return entity -> {
            boolean notPlayer;
            TamableAnimal tamableAnimal;
            boolean notSpectator = !entity.m_5833_();
            boolean notAttacked = entity != player && entity != attacked;
            boolean notTeammate = !player.m_7307_((Entity)entity);
            boolean notTamed = !(entity instanceof TamableAnimal) || !(tamableAnimal = (TamableAnimal)entity).m_21824_() || !player.m_20148_().equals(tamableAnimal.m_21805_());
            boolean distance = (double)attacked.m_20270_((Entity)entity) <= Math.pow(3.5, 2.0);
            boolean bl = notPlayer = !(entity instanceof Player);
            if (dontEffectPlayers) {
                return notSpectator && notAttacked && notTeammate && notTamed && distance && notPlayer;
            }
            return notSpectator && notAttacked && notTeammate && notTamed && distance;
        };
    }
}

