/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.block.entity.container;

import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.yirmiri.dungeonsdelight.common.block.entity.MonsterPotBlockEntity;
import net.yirmiri.dungeonsdelight.core.registry.DDBlocks;
import net.yirmiri.dungeonsdelight.core.registry.DDRecipeRegistries;

public class MonsterFoodServingRecipe
extends CustomRecipe {
    public MonsterFoodServingRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer container, Level level) {
        ItemStack monsterPotStack = ItemStack.f_41583_;
        ItemStack containerStack = ItemStack.f_41583_;
        ItemStack secondStack = ItemStack.f_41583_;
        for (int index = 0; index < container.m_6643_(); ++index) {
            ItemStack mealStack;
            ItemStack selectedStack = container.m_8020_(index);
            if (selectedStack.m_41619_()) continue;
            if (monsterPotStack.m_41619_() && !(mealStack = MonsterPotBlockEntity.getMealFromItem(selectedStack)).m_41619_()) {
                monsterPotStack = selectedStack;
                containerStack = MonsterPotBlockEntity.getContainerFromItem(selectedStack);
                continue;
            }
            if (secondStack.m_41619_()) {
                secondStack = selectedStack;
                continue;
            }
            return false;
        }
        return !monsterPotStack.m_41619_() && !secondStack.m_41619_() && secondStack.m_150930_(containerStack.m_41720_());
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess access) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack selectedStack = container.m_8020_(i);
            if (selectedStack.m_41619_() || !selectedStack.m_150930_(((Block)DDBlocks.MONSTER_POT.get()).m_5456_())) continue;
            ItemStack resultStack = MonsterPotBlockEntity.getMealFromItem(selectedStack).m_41777_();
            resultStack.m_41764_(1);
            return resultStack;
        }
        return ItemStack.f_41583_;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        NonNullList remainders = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < remainders.size(); ++i) {
            ItemStack selectedStack = container.m_8020_(i);
            if (selectedStack.hasCraftingRemainingItem()) {
                remainders.set(i, (Object)selectedStack.getCraftingRemainingItem());
                continue;
            }
            if (!selectedStack.m_150930_(((Block)DDBlocks.MONSTER_POT.get()).m_5456_())) continue;
            MonsterPotBlockEntity.takeServingFromItem(selectedStack);
            ItemStack newCookingPotStack = selectedStack.m_41777_();
            newCookingPotStack.m_41764_(1);
            remainders.set(i, (Object)newCookingPotStack);
            break;
        }
        return remainders;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)DDRecipeRegistries.MONSTER_FOOD_SERVING.get();
    }
}

