/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.block;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.yirmiri.dungeonsdelight.core.init.DDTags;
import net.yirmiri.dungeonsdelight.core.registry.DDSounds;
import vectorwing.farmersdelight.common.tag.ModTags;

public class WormouthBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final BooleanProperty FULL = BooleanProperty.m_61465_((String)"full");
    public static final BooleanProperty COOLDOWN = BooleanProperty.m_61465_((String)"cooldown");
    public static final IntegerProperty BITES = IntegerProperty.m_61631_((String)"bites", (int)0, (int)3);

    public WormouthBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FULL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)COOLDOWN, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)FULL);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource source) {
        if (((Boolean)state.m_61143_((Property)FULL)).booleanValue() && level.m_45524_(pos.m_7494_(), 0) >= 9 && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (source.m_188503_(5) == 0 ? 1 : 0) != 0)) {
            BlockState blockstate = (BlockState)state.m_61124_((Property)FULL, (Comparable)Boolean.valueOf(false));
            level.m_7731_(pos, blockstate, 2);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)blockstate));
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        int currentBites = (Integer)state.m_61143_((Property)BITES);
        ItemStack heldItem = player.m_21120_(hand);
        if (!(level.f_46443_ || heldItem.getFoodProperties((LivingEntity)player) == null || ((Boolean)state.m_61143_((Property)FULL)).booleanValue() || ((Boolean)state.m_61143_((Property)COOLDOWN)).booleanValue())) {
            ResourceLocation lootTableId = heldItem.m_204117_(DDTags.ItemT.MONSTER_FOODS) && heldItem.m_204117_(ModTags.MEALS) && !heldItem.m_204117_(DDTags.ItemT.WORMMOUTH_BLACKLIST) ? new ResourceLocation("dungeonsdelight", "gameplay/preferred_food") : new ResourceLocation("dungeonsdelight", "gameplay/disliked_food");
            LootParams.Builder builder = new LootParams.Builder((ServerLevel)level).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287286_(LootContextParams.f_81455_, (Object)player);
            ObjectArrayList lootData = level.m_7654_().m_278653_().m_278676_(lootTableId).m_287195_(builder.m_287235_(LootContextParamSets.f_81410_));
            if (!lootData.isEmpty()) {
                WormouthBlock.spitItemStack(level, pos.m_123341_(), (double)pos.m_123342_() - 0.6, pos.m_123343_(), (ItemStack)lootData.get(level.f_46441_.m_188503_(lootData.size())));
                if (heldItem.hasCraftingRemainingItem()) {
                    Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)((double)pos.m_123342_() - 0.6), (double)pos.m_123343_(), (ItemStack)new ItemStack((ItemLike)heldItem.getCraftingRemainingItem().m_41720_()));
                }
            }
            if (!player.m_7500_()) {
                heldItem.m_41774_(1);
            }
            level.m_5594_(null, pos, (SoundEvent)DDSounds.MONSTER_YAM_HURT.get(), SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123759_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 5, 0.2, 0.1, 0.2, 0.02);
            if (!lootData.isEmpty()) {
                BlockState cooldownState;
                if (currentBites >= 3 && level.f_46441_.m_216332_(1, 2) == 2) {
                    cooldownState = (BlockState)((BlockState)state.m_61124_((Property)FULL, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BITES, (Comparable)Integer.valueOf(0));
                } else {
                    cooldownState = (BlockState)((BlockState)state.m_61124_((Property)COOLDOWN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BITES, (Comparable)Integer.valueOf(Math.min(currentBites + 1, 3)));
                    level.m_186460_(pos, (Block)this, 10);
                }
                level.m_7731_(pos, cooldownState, 2);
                level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)cooldownState));
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public static void spitItemStack(Level level, double v, double v1, double v2, ItemStack stack) {
        double width = EntityType.f_20461_.m_20678_();
        double v3 = 1.0 - width;
        double v4 = width / 2.0;
        double v5 = Math.floor(v) + level.f_46441_.m_188500_() * v3 + v4;
        double v6 = Math.floor(v1) + level.f_46441_.m_188500_() * v3;
        double v7 = Math.floor(v2) + level.f_46441_.m_188500_() * v3 + v4;
        while (!stack.m_41619_()) {
            ItemEntity itemEntity = new ItemEntity(level, v5, v6, v7, stack.m_41620_(level.f_46441_.m_188503_(21) + 10));
            itemEntity.m_20334_(level.f_46441_.m_216328_(0.0, 0.005), 0.0, level.f_46441_.m_216328_(0.0, 0.005));
            level.m_7967_((Entity)itemEntity);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)COOLDOWN, (Comparable)Boolean.valueOf(false)), 2);
    }

    public void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FULL, COOLDOWN, BITES});
    }
}

