/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.fzzy_config.validation.number;

import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.fzzyhmstrs.fzzy_config.Fzzy_configKt;
import me.fzzyhmstrs.fzzy_config.entry.EntryValidator;
import me.fzzyhmstrs.fzzy_config.screen.widget.LayoutClickableWidget;
import me.fzzyhmstrs.fzzy_config.screen.widget.LayoutWidget;
import me.fzzyhmstrs.fzzy_config.screen.widget.TextureIds;
import me.fzzyhmstrs.fzzy_config.screen.widget.ValidationBackedNumberFieldWidget;
import me.fzzyhmstrs.fzzy_config.screen.widget.custom.CustomButtonWidget;
import me.fzzyhmstrs.fzzy_config.util.FcText;
import me.fzzyhmstrs.fzzy_config.util.ValidationResult;
import me.fzzyhmstrs.fzzy_config.validation.ValidatedField;
import me.fzzyhmstrs.fzzy_config.validation.misc.ChoiceValidator;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 8*\u0012\b\u0000\u0010\u0003*\u00020\u0001*\b\u0012\u0004\u0012\u00028\u00000\u00022\b\u0012\u0004\u0012\u00028\u00000\u0004:\u000489:;B)\b\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ%\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\rH\u0017\u00a2\u0006\u0004\b\u0010\u0010\u0011J%\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\rH\u0017\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u001d\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\u0006\u0010\f\u001a\u00020\u0013H$\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0019\u001a\u00020\u00182\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0019\u0010\u001e\u001a\u00020\u001d2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u0017\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b \u0010!J\u000f\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b#\u0010$J\u000f\u0010%\u001a\u00028\u0000H%\u00a2\u0006\u0004\b%\u0010&J\u000f\u0010'\u001a\u00028\u0000H%\u00a2\u0006\u0004\b'\u0010&J!\u0010)\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f0(H\u0004\u00a2\u0006\u0004\b)\u0010*J'\u0010,\u001a\u00020\u00182\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\b\u0010+\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0004\b,\u0010-R\u001a\u0010\u0006\u001a\u00028\u00008\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010.\u001a\u0004\b/\u0010&R\u001a\u0010\u0007\u001a\u00028\u00008\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010.\u001a\u0004\b0\u0010&R\u001a\u0010\t\u001a\u00020\b8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\t\u00101\u001a\u0004\b2\u00103R\u001e\u00107\u001a\u0004\u0018\u00018\u00008$@$X\u00a4\u000e\u00a2\u0006\f\u001a\u0004\b4\u0010&\"\u0004\b5\u00106\u0082\u0001\u0006<=>?@A\u00a8\u0006B"}, d2={"Lme/fzzyhmstrs/fzzy_config/validation/number/ValidatedNumber;", "", "", "T", "Lme/fzzyhmstrs/fzzy_config/validation/ValidatedField;", "defaultValue", "minValue", "maxValue", "Lme/fzzyhmstrs/fzzy_config/validation/number/ValidatedNumber$WidgetType;", "widgetType", "<init>", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Lme/fzzyhmstrs/fzzy_config/validation/number/ValidatedNumber$WidgetType;)V", "input", "Lme/fzzyhmstrs/fzzy_config/entry/EntryValidator$ValidationType;", "type", "Lme/fzzyhmstrs/fzzy_config/util/ValidationResult;", "correctEntry", "(Ljava/lang/Number;Lme/fzzyhmstrs/fzzy_config/entry/EntryValidator$ValidationType;)Lme/fzzyhmstrs/fzzy_config/util/ValidationResult;", "validateEntry", "", "convert", "(D)Lme/fzzyhmstrs/fzzy_config/util/ValidationResult;", "Lme/fzzyhmstrs/fzzy_config/validation/misc/ChoiceValidator;", "choicePredicate", "Lnet/minecraft/client/gui/components/AbstractWidget;", "widgetEntry", "(Lme/fzzyhmstrs/fzzy_config/validation/misc/ChoiceValidator;)Lnet/minecraft/client/gui/components/AbstractWidget;", "", "fallback", "Lnet/minecraft/network/chat/MutableComponent;", "description", "(Ljava/lang/String;)Lnet/minecraft/network/chat/MutableComponent;", "genericDescription", "()Lnet/minecraft/network/chat/MutableComponent;", "", "hasDescription", "()Z", "minBound", "()Ljava/lang/Number;", "maxBound", "Ljava/util/function/Function;", "validator", "()Ljava/util/function/Function;", "incr", "prepareTextboxWithButtons", "(Lme/fzzyhmstrs/fzzy_config/validation/misc/ChoiceValidator;Ljava/lang/Number;)Lnet/minecraft/client/gui/components/AbstractWidget;", "Ljava/lang/Number;", "getMinValue", "getMaxValue", "Lme/fzzyhmstrs/fzzy_config/validation/number/ValidatedNumber$WidgetType;", "getWidgetType", "()Lme/fzzyhmstrs/fzzy_config/validation/number/ValidatedNumber$WidgetType;", "getIncrement", "setIncrement", "(Ljava/lang/Number;)V", "increment", "Companion", "WidgetType", "ConfirmButtonSliderWidget", "ConfirmButtonTextFieldWidget", "Lme/fzzyhmstrs/fzzy_config/validation/number/ValidatedByte;", "Lme/fzzyhmstrs/fzzy_config/validation/number/ValidatedDouble;", "Lme/fzzyhmstrs/fzzy_config/validation/number/ValidatedFloat;", "Lme/fzzyhmstrs/fzzy_config/validation/number/ValidatedInt;", "Lme/fzzyhmstrs/fzzy_config/validation/number/ValidatedLong;", "Lme/fzzyhmstrs/fzzy_config/validation/number/ValidatedShort;", "fzzy_config"})
public abstract class ValidatedNumber<T extends Number>
extends ValidatedField<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final T minValue;
    @NotNull
    private final T maxValue;
    @NotNull
    private final WidgetType widgetType;

    private ValidatedNumber(T defaultValue, T minValue, T maxValue, WidgetType widgetType) {
        super(defaultValue, null, 2, null);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.widgetType = widgetType;
        if (((Comparable)this.minValue).compareTo(this.maxValue) >= 0) {
            throw new IllegalStateException("Min value " + this.minValue + " can't be >= Max value " + this.maxValue);
        }
    }

    @NotNull
    protected final T getMinValue() {
        return this.minValue;
    }

    @NotNull
    protected final T getMaxValue() {
        return this.maxValue;
    }

    @NotNull
    protected final WidgetType getWidgetType() {
        return this.widgetType;
    }

    @Nullable
    protected abstract T getIncrement();

    protected abstract void setIncrement(@Nullable T var1);

    @Override
    @ApiStatus.Internal
    @NotNull
    public ValidationResult<T> correctEntry(@NotNull T input, @NotNull EntryValidator.ValidationType type) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (((Comparable)input).compareTo(this.minValue) < 0) {
            return ValidationResult.Companion.error$default(ValidationResult.Companion, this.minValue, ValidationResult.Errors.INSTANCE.getOUT_OF_BOUNDS(), "Validated number [" + input + "] below the valid range [" + this.minValue + "] to [" + this.maxValue + "]", null, 8, null);
        }
        if (((Comparable)input).compareTo(this.maxValue) > 0) {
            return ValidationResult.Companion.error$default(ValidationResult.Companion, this.maxValue, ValidationResult.Errors.INSTANCE.getOUT_OF_BOUNDS(), "Validated number [" + input + "] above the valid range [" + this.minValue + "] to [" + this.maxValue + "]", null, 8, null);
        }
        return ValidationResult.Companion.success(input);
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public ValidationResult<T> validateEntry(@NotNull T input, @NotNull EntryValidator.ValidationType type) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (((Comparable)input).compareTo(this.minValue) < 0) {
            return ValidationResult.Companion.error$default(ValidationResult.Companion, input, ValidationResult.Errors.INSTANCE.getOUT_OF_BOUNDS(), "Validated number [" + input + "] below the valid range [" + this.minValue + "] to [" + this.maxValue + "]", null, 8, null);
        }
        if (((Comparable)input).compareTo(this.maxValue) > 0) {
            return ValidationResult.Companion.error$default(ValidationResult.Companion, input, ValidationResult.Errors.INSTANCE.getOUT_OF_BOUNDS(), "Validated number [" + input + "] above the valid range [" + this.minValue + "] to [" + this.maxValue + "]", null, 8, null);
        }
        return ValidationResult.Companion.success(input);
    }

    @NotNull
    protected abstract ValidationResult<T> convert(double var1);

    @Override
    @ApiStatus.Internal
    @NotNull
    public AbstractWidget widgetEntry(@NotNull ChoiceValidator<T> choicePredicate) {
        Intrinsics.checkNotNullParameter(choicePredicate, (String)"choicePredicate");
        return switch (WhenMappings.$EnumSwitchMapping$0[this.widgetType.ordinal()]) {
            case 1 -> new ConfirmButtonSliderWidget<Number>(this, (Number)this.getIncrement(), (Number)this.minValue, (Number)this.maxValue, (ChoiceValidator<Number>)choicePredicate, arg_0 -> ValidatedNumber.widgetEntry$lambda$0(this, arg_0), arg_0 -> ValidatedNumber.widgetEntry$lambda$1(this, arg_0));
            case 2 -> (AbstractWidget)new ConfirmButtonTextFieldWidget(this, choicePredicate, this.validator(), arg_0 -> ValidatedNumber.widgetEntry$lambda$2(this, arg_0), 0, false, 0.0, 112, null);
            case 3 -> this.prepareTextboxWithButtons(choicePredicate, this.getIncrement());
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public MutableComponent description(@Nullable String fallback) {
        return I18n.m_118936_((String)this.descriptionKey()) ? super.description(fallback) : this.genericDescription();
    }

    private final MutableComponent genericDescription() {
        MutableComponent mutableComponent;
        if (((Comparable)this.minValue).compareTo(this.minBound()) == 0) {
            if (((Comparable)this.maxValue).compareTo(this.maxBound()) == 0) {
                mutableComponent = FcText.INSTANCE.translate("fc.validated_field.number.desc.fallback.any", new Object[0]);
            } else {
                Object[] objectArray = new Object[]{this.maxValue};
                mutableComponent = FcText.INSTANCE.translate("fc.validated_field.number.desc.fallback.min", objectArray);
            }
        } else if (((Comparable)this.maxValue).compareTo(this.maxBound()) == 0) {
            Object[] objectArray = new Object[]{this.minValue};
            mutableComponent = FcText.INSTANCE.translate("fc.validated_field.number.desc.fallback.max", objectArray);
        } else {
            Object[] objectArray = new Object[]{this.minValue, this.maxValue};
            mutableComponent = FcText.INSTANCE.translate("fc.validated_field.number.desc.fallback", objectArray);
        }
        return mutableComponent;
    }

    @Override
    public boolean hasDescription() {
        return true;
    }

    @ApiStatus.Internal
    @NotNull
    protected abstract T minBound();

    @ApiStatus.Internal
    @NotNull
    protected abstract T maxBound();

    @NotNull
    protected final Function<Double, ValidationResult<T>> validator() {
        return arg_0 -> ValidatedNumber.validator$lambda$3(this, arg_0);
    }

    private final AbstractWidget prepareTextboxWithButtons(ChoiceValidator<T> choicePredicate, T incr) {
        T t = incr;
        double increment = t != null ? ((Number)t).doubleValue() : Math.max((((Number)this.maxValue).doubleValue() - ((Number)this.minValue).doubleValue()) / 100.0, ValidatedNumber.prepareTextboxWithButtons$isIntType(this) ? Math.max(1.0, ValidatedNumber.prepareTextboxWithButtons$split(((Number)this.maxValue).doubleValue() - ((Number)this.minValue).doubleValue())) : Math.min(1.0, ValidatedNumber.prepareTextboxWithButtons$split(((Number)this.maxValue).doubleValue() - ((Number)this.minValue).doubleValue())));
        LayoutWidget layout = new LayoutWidget(null, null, 0, 0, 0, 0, 3, null);
        ConfirmButtonTextFieldWidget<Number> numberWidget = new ConfirmButtonTextFieldWidget<Number>(this, choicePredicate, this.validator(), arg_0 -> ValidatedNumber.prepareTextboxWithButtons$lambda$4(this, arg_0), 99, false, increment);
        UnaryOperator unaryOperator = ValidatedNumber::prepareTextboxWithButtons$lambda$5;
        UnaryOperator<Integer> unaryOperator2 = UnaryOperator.identity();
        Intrinsics.checkNotNullExpressionValue(unaryOperator2, (String)"identity(...)");
        layout.pushSpacing(unaryOperator, unaryOperator2);
        LayoutWidget.Position[] positionArray = new LayoutWidget.Position[]{LayoutWidget.Position.Impl.getLEFT(), LayoutWidget.Position.Impl.getALIGN_LEFT_AND_JUSTIFY()};
        layout.add("textbox", (LayoutElement)numberWidget, positionArray);
        layout.popSpacing();
        positionArray = new LayoutWidget.Position[]{LayoutWidget.Position.Impl.getRIGHT(), LayoutWidget.Position.Impl.getALIGN_RIGHT(), LayoutWidget.Position.Impl.getHORIZONTAL_TO_TOP_EDGE()};
        layout.add("up", (LayoutElement)CustomButtonWidget.Companion.builder((Component)FcText.INSTANCE.translate("fc.button.up", new Object[0]), arg_0 -> ValidatedNumber.prepareTextboxWithButtons$lambda$6(this, increment, arg_0)).noMessage().narrationAppender(arg_0 -> ValidatedNumber.prepareTextboxWithButtons$lambda$7(numberWidget, arg_0)).size(11, 10).active(!Intrinsics.areEqual(this.maxValue, this.minValue)).textures(TextureIds.INSTANCE.getINCREMENT_UP(), TextureIds.INSTANCE.getINCREMENT_UP_DISABLED(), TextureIds.INSTANCE.getINCREMENT_UP_HIGHLIGHTED()).build(), positionArray);
        positionArray = new LayoutWidget.Position[]{LayoutWidget.Position.Impl.getBELOW(), LayoutWidget.Position.Impl.getALIGN_RIGHT(), LayoutWidget.Position.Impl.getVERTICAL_TO_LEFT_EDGE()};
        layout.add("down", (LayoutElement)CustomButtonWidget.Companion.builder((Component)FcText.INSTANCE.translate("fc.button.down", new Object[0]), arg_0 -> ValidatedNumber.prepareTextboxWithButtons$lambda$8(this, increment, arg_0)).noMessage().size(11, 10).active(!Intrinsics.areEqual(this.maxValue, this.minValue)).textures(TextureIds.INSTANCE.getINCREMENT_DOWN(), TextureIds.INSTANCE.getINCREMENT_DOWN_DISABLED(), TextureIds.INSTANCE.getINCREMENT_DOWN_HIGHLIGHTED()).build(), positionArray);
        return new LayoutClickableWidget(0, 0, 110, 20, layout);
    }

    private static final Number widgetEntry$lambda$0(ValidatedNumber this$0, Double d) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        return (Number)this$0.convert(d).get();
    }

    private static final void widgetEntry$lambda$1(ValidatedNumber this$0, Number it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.setAndUpdate(it);
    }

    private static final void widgetEntry$lambda$2(ValidatedNumber this$0, Number it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.setAndUpdate(it);
    }

    private static final ValidationResult validator$lambda$3(ValidatedNumber this$0, Double d) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        ValidationResult.ErrorEntry.Mutable mutable = ValidationResult.Companion.createMutable("Number validation found errors");
        ValidationResult result = ValidationResult.Companion.attachTo(this$0.convert(d), mutable);
        ValidationResult<Number> result2 = ValidationResult.Companion.attachTo(this$0.correctEntry((T)((Number)result.get()), EntryValidator.ValidationType.STRONG), mutable);
        return ValidationResult.Companion.ofMutable(result2.get(), mutable);
    }

    private static final <T extends Number> boolean prepareTextboxWithButtons$isIntType(ValidatedNumber<T> this$0) {
        return this$0.maxValue instanceof Integer || this$0.maxValue instanceof Long || this$0.maxValue instanceof Short || this$0.maxValue instanceof Byte;
    }

    private static final double prepareTextboxWithButtons$split(double range) {
        double d;
        for (d = range; d < 16.0; d *= 100.0) {
        }
        return (int)(d = Math.rint(d)) % 16 == 0 ? range / 16.0 : ((int)d % 12 == 0 ? range / 12.0 : range / 10.0);
    }

    private static final void prepareTextboxWithButtons$lambda$4(ValidatedNumber this$0, Number it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.setAndUpdate(it);
    }

    private static final Integer prepareTextboxWithButtons$lambda$5(Integer n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"<unused var>");
        return 1;
    }

    private static final void prepareTextboxWithButtons$lambda$6(ValidatedNumber this$0, double $increment, CustomButtonWidget it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Number n = (Number)this$0.convert(Mth.m_14008_((double)(((Number)this$0.get()).doubleValue() + $increment), (double)((Number)this$0.minValue).doubleValue(), (double)((Number)this$0.maxValue).doubleValue())).get();
        this$0.setAndUpdate(n);
    }

    private static final void prepareTextboxWithButtons$lambda$7(ConfirmButtonTextFieldWidget $numberWidget, NarrationElementOutput builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        $numberWidget.appendValueNarrations(builder);
    }

    private static final void prepareTextboxWithButtons$lambda$8(ValidatedNumber this$0, double $increment, CustomButtonWidget it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Number n = (Number)this$0.convert(Mth.m_14008_((double)(((Number)this$0.get()).doubleValue() - $increment), (double)((Number)this$0.minValue).doubleValue(), (double)((Number)this$0.maxValue).doubleValue())).get();
        this$0.setAndUpdate(n);
    }

    public /* synthetic */ ValidatedNumber(Number defaultValue, Number minValue, Number maxValue, WidgetType widgetType, DefaultConstructorMarker $constructor_marker) {
        this(defaultValue, minValue, maxValue, widgetType);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\b\u001a\u00028\u0002\"\u0004\b\u0001\u0010\u0004\"\u000e\b\u0002\u0010\u0006*\b\u0012\u0004\u0012\u00028\u00010\u0005*\u00028\u00022\u0006\u0010\u0007\u001a\u00028\u0001\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lme/fzzyhmstrs/fzzy_config/validation/number/ValidatedNumber$Companion;", "", "<init>", "()V", "T", "Lme/fzzyhmstrs/fzzy_config/validation/number/ValidatedNumber;", "F", "increment", "withIncrement", "(Lme/fzzyhmstrs/fzzy_config/validation/number/ValidatedNumber;Ljava/lang/Object;)Lme/fzzyhmstrs/fzzy_config/validation/number/ValidatedNumber;", "fzzy_config"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T, F extends ValidatedNumber<T>> F withIncrement(@NotNull F $this$withIncrement, T increment) {
            Intrinsics.checkNotNullParameter($this$withIncrement, (String)"<this>");
            $this$withIncrement.setIncrement((Number)((Number)increment));
            return $this$withIncrement;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0004\u0018\u0000 R*\b\b\u0001\u0010\u0002*\u00020\u00012\u00020\u0003:\u0001RB_\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00018\u0001\u0012\u0006\u0010\u0007\u001a\u00028\u0001\u0012\u0006\u0010\b\u001a\u00028\u0001\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\t\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00028\u00010\u000b\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0017J/\u0010!\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001eH\u0014\u00a2\u0006\u0004\b!\u0010\"J\u000f\u0010#\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b#\u0010$J\u000f\u0010%\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b%\u0010$J3\u0010*\u001a\u00020 2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00192\b\u0010'\u001a\u0004\u0018\u00010&2\u0006\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u001bH\u0014\u00a2\u0006\u0004\b*\u0010+J\u000f\u0010-\u001a\u00020,H\u0014\u00a2\u0006\u0004\b-\u0010.J\u0017\u00101\u001a\u00020 2\u0006\u00100\u001a\u00020/H\u0014\u00a2\u0006\u0004\b1\u00102J'\u00106\u001a\u00020\u00152\u0006\u00103\u001a\u00020\u001b2\u0006\u00104\u001a\u00020\u001b2\u0006\u00105\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b6\u00107J\u0017\u00108\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b8\u00109J\u0017\u0010;\u001a\u00020 2\u0006\u0010:\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b;\u00109J\u001f\u0010<\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b<\u0010=J/\u0010@\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010>\u001a\u00020\f2\u0006\u0010?\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b@\u0010AJ\u0019\u0010D\u001a\u00020 2\b\u0010C\u001a\u0004\u0018\u00010BH\u0016\u00a2\u0006\u0004\bD\u0010EJ\u001f\u0010F\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\fH\u0016\u00a2\u0006\u0004\bF\u0010=R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010GR\u0014\u0010\u0007\u001a\u00028\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010HR\u0014\u0010\b\u001a\u00028\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010HR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010IR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00028\u00010\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010JR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010KR\u0016\u0010L\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bL\u0010MR\u0016\u0010N\u001a\u00028\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bN\u0010HR\u0016\u0010:\u001a\u00028\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b:\u0010HR\u0014\u0010O\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bO\u0010PR\u0016\u0010Q\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bQ\u0010M\u00a8\u0006S"}, d2={"Lme/fzzyhmstrs/fzzy_config/validation/number/ValidatedNumber$ConfirmButtonSliderWidget;", "", "T", "Lnet/minecraft/client/gui/components/AbstractWidget;", "Ljava/util/function/Supplier;", "wrappedValue", "incr", "minValue", "maxValue", "Lme/fzzyhmstrs/fzzy_config/validation/misc/ChoiceValidator;", "validator", "Ljava/util/function/Function;", "", "converter", "Ljava/util/function/Consumer;", "valueApplier", "<init>", "(Ljava/util/function/Supplier;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Lme/fzzyhmstrs/fzzy_config/validation/misc/ChoiceValidator;Ljava/util/function/Function;Ljava/util/function/Consumer;)V", "range", "split", "(D)D", "", "isIntType", "()Z", "isChanged", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "", "mouseX", "mouseY", "", "delta", "", "renderButton", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "getYImage", "()I", "getTextureV", "Lnet/minecraft/client/gui/Font;", "textRenderer", "xMargin", "color", "drawScrollableText", "(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/Font;II)V", "Lnet/minecraft/network/chat/MutableComponent;", "getNarrationMessage", "()Lnet/minecraft/network/chat/MutableComponent;", "Lnet/minecraft/client/gui/narration/NarrationElementOutput;", "builder", "appendClickableNarrations", "(Lnet/minecraft/client/gui/narration/NarrationElementOutput;)V", "keyCode", "scanCode", "modifiers", "keyPressed", "(III)Z", "setValueFromMouse", "(D)V", "value", "setValue", "onClick", "(DD)V", "deltaX", "deltaY", "onDrag", "(DDDD)V", "Lnet/minecraft/client/sounds/SoundManager;", "soundManager", "playDownSound", "(Lnet/minecraft/client/sounds/SoundManager;)V", "onRelease", "Ljava/util/function/Supplier;", "Ljava/lang/Number;", "Lme/fzzyhmstrs/fzzy_config/validation/misc/ChoiceValidator;", "Ljava/util/function/Function;", "Ljava/util/function/Consumer;", "confirmActive", "Z", "cachedWrappedValue", "increment", "D", "isValid", "Companion", "fzzy_config"})
    protected static final class ConfirmButtonSliderWidget<T extends Number>
    extends AbstractWidget {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Supplier<T> wrappedValue;
        @NotNull
        private final T minValue;
        @NotNull
        private final T maxValue;
        @NotNull
        private final ChoiceValidator<T> validator;
        @NotNull
        private final Function<Double, T> converter;
        @NotNull
        private final Consumer<T> valueApplier;
        private boolean confirmActive;
        @NotNull
        private T cachedWrappedValue;
        @NotNull
        private T value;
        private final double increment;
        private boolean isValid;
        @NotNull
        private static final ResourceLocation TEXTURE = Fzzy_configKt.simpleId("textures/gui/slider.png");
        @NotNull
        private static final DecimalFormat DECIMAL_FORMAT;

        public ConfirmButtonSliderWidget(@NotNull Supplier<T> wrappedValue, @Nullable T incr, @NotNull T minValue, @NotNull T maxValue, @NotNull ChoiceValidator<T> validator, @NotNull Function<Double, T> converter, @NotNull Consumer<T> valueApplier) {
            Intrinsics.checkNotNullParameter(wrappedValue, (String)"wrappedValue");
            Intrinsics.checkNotNullParameter(minValue, (String)"minValue");
            Intrinsics.checkNotNullParameter(maxValue, (String)"maxValue");
            Intrinsics.checkNotNullParameter(validator, (String)"validator");
            Intrinsics.checkNotNullParameter(converter, (String)"converter");
            Intrinsics.checkNotNullParameter(valueApplier, (String)"valueApplier");
            String string = DECIMAL_FORMAT.format(wrappedValue.get());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            super(0, 0, 110, 20, (Component)FcText.INSTANCE.lit(string));
            this.wrappedValue = wrappedValue;
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.validator = validator;
            this.converter = converter;
            this.valueApplier = valueApplier;
            T t = this.wrappedValue.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            this.cachedWrappedValue = (Number)t;
            T t2 = this.wrappedValue.get();
            Intrinsics.checkNotNullExpressionValue(t2, (String)"get(...)");
            this.value = (Number)t2;
            T t3 = incr;
            this.increment = t3 != null ? ((Number)t3).doubleValue() : Math.max((((Number)this.maxValue).doubleValue() - ((Number)this.minValue).doubleValue()) / 102.0, this.isIntType() ? Math.max(1.0, this.split(((Number)this.maxValue).doubleValue() - ((Number)this.minValue).doubleValue())) : Math.min(1.0, this.split(((Number)this.maxValue).doubleValue() - ((Number)this.minValue).doubleValue())));
            T t4 = this.wrappedValue.get();
            Intrinsics.checkNotNullExpressionValue(t4, (String)"get(...)");
            this.isValid = this.validator.validateEntry(t4, EntryValidator.ValidationType.STRONG).isValid();
        }

        private final double split(double range) {
            double d;
            for (d = range; d < 16.0; d *= 100.0) {
            }
            return (int)(d = Math.rint(d)) % 16 == 0 ? range / 16.0 : ((int)d % 12 == 0 ? range / 12.0 : range / 10.0);
        }

        private final boolean isIntType() {
            return this.maxValue instanceof Integer || this.maxValue instanceof Long || this.maxValue instanceof Short || this.maxValue instanceof Byte;
        }

        private final boolean isChanged() {
            return !Intrinsics.areEqual(this.value, this.wrappedValue.get());
        }

        protected void m_87963_(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            T t = this.wrappedValue.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            Number testValue = (Number)t;
            if (!Intrinsics.areEqual(this.cachedWrappedValue, (Object)testValue)) {
                this.value = testValue;
                this.cachedWrappedValue = testValue;
                String string = DECIMAL_FORMAT.format(this.value);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                this.m_93666_((Component)FcText.INSTANCE.lit(string));
            }
            this.confirmActive = this.isChanged() && this.isValid;
            Minecraft minecraftClient = Minecraft.m_91087_();
            context.m_280246_(1.0f, 1.0f, 1.0f, this.f_93625_);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            double progress = Mth.m_14112_((double)((Number)this.value).doubleValue(), (double)((Number)this.minValue).doubleValue(), (double)((Number)this.maxValue).doubleValue());
            context.m_280027_(TEXTURE, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), 20, 4, 200, 20, 0, this.getYImage());
            context.m_280027_(TEXTURE, this.m_252754_() + (int)(progress * (double)(this.f_93618_ - 8)), this.m_252907_(), 8, 20, 20, 4, 200, 20, 0, this.getTextureV());
            context.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            this.m_280372_(context, minecraftClient.f_91062_, 2, 0xFFFFFF | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
        }

        private final int getYImage() {
            int i = this.m_93696_() ? 1 : 0;
            return i * 20;
        }

        private final int getTextureV() {
            int i = this.f_93622_ || this.m_93696_() ? 3 : 2;
            return i * 20;
        }

        protected void m_280372_(@Nullable GuiGraphics context, @Nullable Font textRenderer, int xMargin, int color) {
            int i = this.m_252754_() + xMargin;
            int j = this.m_252754_() + this.m_5711_() - xMargin;
            AbstractWidget.m_280138_((GuiGraphics)context, (Font)textRenderer, (Component)this.m_6035_(), (int)i, (int)this.m_252907_(), (int)j, (int)(this.m_252907_() + this.m_93694_()), (int)color);
        }

        @NotNull
        protected MutableComponent m_5646_() {
            Object[] objectArray = new Object[]{this.m_6035_()};
            return FcText.INSTANCE.translatable("gui.narrate.slider", objectArray);
        }

        protected void m_168797_(@NotNull NarrationElementOutput builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            builder.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
            if (this.f_93623_) {
                if (this.m_93696_()) {
                    Component[] componentArray = new Component[]{FcText.INSTANCE.translate("fc.validated_field.number.slider.usage", new Object[0]), FcText.INSTANCE.translate("fc.validated_field.number.slider.usage2", new Object[0])};
                    builder.m_169149_(NarratedElementType.USAGE, componentArray);
                } else {
                    builder.m_169146_(NarratedElementType.USAGE, (Component)FcText.INSTANCE.translate("fc.validated_field.number.slider.usage.unfocused", new Object[0]));
                }
            }
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            boolean bl;
            boolean bl2 = bl = keyCode == 263;
            if (bl || keyCode == 262) {
                double f = bl ? -this.increment : this.increment;
                double ff = Mth.m_14008_((double)(((Number)this.value).doubleValue() + f), (double)((Number)this.minValue).doubleValue(), (double)((Number)this.maxValue).doubleValue());
                this.setValue(ff);
                this.isValid = this.validator.validateEntry(this.value, EntryValidator.ValidationType.STRONG).isValid();
                if (this.isChanged() && this.isValid) {
                    this.cachedWrappedValue = this.value;
                    this.valueApplier.accept(this.value);
                    this.confirmActive = this.isChanged() && this.isValid;
                }
                return true;
            }
            return false;
        }

        private final void setValueFromMouse(double mouseX) {
            this.setValue(Mth.m_144851_((double)((mouseX - (double)(this.m_252754_() + 4)) / (double)(this.f_93618_ - 8)), (double)0.0, (double)1.0, (double)((Number)this.minValue).doubleValue(), (double)((Number)this.maxValue).doubleValue()));
        }

        private final void setValue(double value) {
            this.value = (Number)this.converter.apply(value);
            String string = DECIMAL_FORMAT.format(this.value);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            this.m_93666_((Component)FcText.INSTANCE.lit(string));
        }

        public void m_5716_(double mouseX, double mouseY) {
            this.setValueFromMouse(mouseX);
        }

        protected void m_7212_(double mouseX, double mouseY, double deltaX, double deltaY) {
            this.setValueFromMouse(mouseX);
            super.m_7212_(mouseX, mouseY, deltaX, deltaY);
        }

        public void m_7435_(@Nullable SoundManager soundManager) {
        }

        public void m_7691_(double mouseX, double mouseY) {
            this.isValid = this.validator.validateEntry(this.value, EntryValidator.ValidationType.STRONG).isValid();
            if (this.isChanged() && this.isValid) {
                this.cachedWrappedValue = this.value;
                this.valueApplier.accept(this.value);
                this.confirmActive = this.isChanged() && this.isValid;
            }
            super.m_7435_(Minecraft.m_91087_().m_91106_());
        }

        private static final void DECIMAL_FORMAT$lambda$0(DecimalFormat format) {
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            format.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT));
        }

        static {
            Object object = Util.m_137469_((Object)new DecimalFormat("#.##"), ConfirmButtonSliderWidget::DECIMAL_FORMAT$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"make(...)");
            DECIMAL_FORMAT = (DecimalFormat)object;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lme/fzzyhmstrs/fzzy_config/validation/number/ValidatedNumber$ConfirmButtonSliderWidget$Companion;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "TEXTURE", "Lnet/minecraft/resources/ResourceLocation;", "Ljava/text/DecimalFormat;", "DECIMAL_FORMAT", "Ljava/text/DecimalFormat;", "fzzy_config"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0004\u0018\u0000*\b\b\u0001\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00010\u0003Bi\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\n0\b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\f\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0012\u001a\u00020\t\u00a2\u0006\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lme/fzzyhmstrs/fzzy_config/validation/number/ValidatedNumber$ConfirmButtonTextFieldWidget;", "", "T", "Lme/fzzyhmstrs/fzzy_config/screen/widget/ValidationBackedNumberFieldWidget;", "Ljava/util/function/Supplier;", "wrappedValue", "Lme/fzzyhmstrs/fzzy_config/validation/misc/ChoiceValidator;", "choiceValidator", "Ljava/util/function/Function;", "", "Lme/fzzyhmstrs/fzzy_config/util/ValidationResult;", "validationProvider", "Ljava/util/function/Consumer;", "valueApplier", "", "width", "", "renderStatus", "increment", "<init>", "(Ljava/util/function/Supplier;Lme/fzzyhmstrs/fzzy_config/validation/misc/ChoiceValidator;Ljava/util/function/Function;Ljava/util/function/Consumer;IZD)V", "fzzy_config"})
    protected static final class ConfirmButtonTextFieldWidget<T extends Number>
    extends ValidationBackedNumberFieldWidget<T> {
        public ConfirmButtonTextFieldWidget(@NotNull Supplier<T> wrappedValue, @NotNull ChoiceValidator<T> choiceValidator, @NotNull Function<Double, ValidationResult<T>> validationProvider, @NotNull Consumer<T> valueApplier, int width, boolean renderStatus, double increment) {
            Intrinsics.checkNotNullParameter(wrappedValue, (String)"wrappedValue");
            Intrinsics.checkNotNullParameter(choiceValidator, (String)"choiceValidator");
            Intrinsics.checkNotNullParameter(validationProvider, (String)"validationProvider");
            Intrinsics.checkNotNullParameter(valueApplier, (String)"valueApplier");
            super(width, 20, wrappedValue, choiceValidator, validationProvider, valueApplier, renderStatus, increment);
        }

        public /* synthetic */ ConfirmButtonTextFieldWidget(Supplier supplier2, ChoiceValidator choiceValidator, Function function, Consumer consumer2, int n, boolean bl, double d, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x10) != 0) {
                n = 110;
            }
            if ((n2 & 0x20) != 0) {
                bl = true;
            }
            if ((n2 & 0x40) != 0) {
                d = 0.0;
            }
            this(supplier2, choiceValidator, function, consumer2, n, bl, d);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WidgetType.values().length];
            try {
                nArray[WidgetType.SLIDER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WidgetType.TEXTBOX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WidgetType.TEXTBOX_WITH_BUTTONS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lme/fzzyhmstrs/fzzy_config/validation/number/ValidatedNumber$WidgetType;", "", "<init>", "(Ljava/lang/String;I)V", "SLIDER", "TEXTBOX", "TEXTBOX_WITH_BUTTONS", "fzzy_config"})
    public static final class WidgetType
    extends Enum<WidgetType> {
        public static final /* enum */ WidgetType SLIDER = new WidgetType();
        public static final /* enum */ WidgetType TEXTBOX = new WidgetType();
        public static final /* enum */ WidgetType TEXTBOX_WITH_BUTTONS = new WidgetType();
        private static final /* synthetic */ WidgetType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static WidgetType[] values() {
            return (WidgetType[])$VALUES.clone();
        }

        public static WidgetType valueOf(String value) {
            return Enum.valueOf(WidgetType.class, value);
        }

        @NotNull
        public static EnumEntries<WidgetType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = widgetTypeArray = new WidgetType[]{WidgetType.SLIDER, WidgetType.TEXTBOX, WidgetType.TEXTBOX_WITH_BUTTONS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

