/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation.property;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import mod.azure.azurelib.rewrite.animation.easing.AzEasingType;
import mod.azure.azurelib.rewrite.animation.property.codec.AzAnimationPropertiesCodec;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AzAnimationProperties {
    public static final Function<FriendlyByteBuf, AzAnimationProperties> DECODER = AzAnimationPropertiesCodec.DECODER;
    public static final BiConsumer<FriendlyByteBuf, AzAnimationProperties> ENCODER = AzAnimationPropertiesCodec.ENCODER;
    public static final AzAnimationProperties DEFAULT = new AzAnimationProperties(1.0, null, Float.valueOf(0.0f));
    public static final AzAnimationProperties EMPTY = new AzAnimationProperties(null, null, null);
    @Nullable
    protected final Double animationSpeed;
    @Nullable
    protected final AzEasingType easingType;
    @Nullable
    protected final Float transitionLength;

    public AzAnimationProperties(@Nullable Double animationSpeed, @Nullable AzEasingType easingType, @Nullable Float transitionLength) {
        this.animationSpeed = animationSpeed;
        this.easingType = easingType;
        this.transitionLength = transitionLength;
    }

    public boolean hasAnimationSpeed() {
        return this.animationSpeed != null;
    }

    public boolean hasEasingType() {
        return this.easingType != null;
    }

    public boolean hasTransitionLength() {
        return this.transitionLength != null;
    }

    public AzAnimationProperties withAnimationSpeed(double animationSpeed) {
        return new AzAnimationProperties(animationSpeed, this.easingType, this.transitionLength);
    }

    public AzAnimationProperties withEasingType(@NotNull AzEasingType easingType) {
        return new AzAnimationProperties(this.animationSpeed, easingType, this.transitionLength);
    }

    public AzAnimationProperties withTransitionLength(float transitionLength) {
        return new AzAnimationProperties(this.animationSpeed, this.easingType, Float.valueOf(transitionLength));
    }

    public double animationSpeed() {
        return this.animationSpeed == null ? DEFAULT.animationSpeed() : this.animationSpeed.doubleValue();
    }

    public AzEasingType easingType() {
        return this.easingType;
    }

    public float transitionLength() {
        return this.transitionLength == null ? DEFAULT.transitionLength() : this.transitionLength.floatValue();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AzAnimationProperties that = (AzAnimationProperties)object;
        return Objects.equals(this.animationSpeed, that.animationSpeed) && Objects.equals(this.easingType, that.easingType) && Objects.equals(this.transitionLength, that.transitionLength);
    }

    public int hashCode() {
        return Objects.hash(this.animationSpeed, this.easingType, this.transitionLength);
    }
}

