/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.world.generator.multichunk;

import java.util.Random;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.chunk.ChunkGenerator;
import org.violetmoon.zeta.config.type.ClusterSizeConfig;
import org.violetmoon.zeta.config.type.DimensionConfig;
import org.violetmoon.zeta.util.BooleanSuppliers;
import org.violetmoon.zeta.world.generator.multichunk.ClusterShape;
import org.violetmoon.zeta.world.generator.multichunk.MultiChunkFeatureGenerator;

public abstract class ClusterBasedGenerator
extends MultiChunkFeatureGenerator {
    public final ClusterShape.Provider shapeProvider;

    public ClusterBasedGenerator(DimensionConfig dimConfig, ClusterSizeConfig sizeConfig, long seedXor) {
        this(dimConfig, BooleanSuppliers.TRUE, sizeConfig, seedXor);
    }

    public ClusterBasedGenerator(DimensionConfig dimConfig, BooleanSupplier condition, ClusterSizeConfig sizeConfig, long seedXor) {
        super(dimConfig, condition, seedXor);
        this.shapeProvider = new ClusterShape.Provider(sizeConfig, seedXor);
    }

    @Override
    public int getFeatureRadius() {
        return this.shapeProvider.getRadius();
    }

    @Override
    public void generateChunkPart(BlockPos src, ChunkGenerator generator, Random random, BlockPos chunkCorner, WorldGenRegion world) {
        ClusterShape shape = this.shapeProvider.around(src);
        IGenerationContext context = this.createContext(src, generator, random, chunkCorner, world);
        this.forEachChunkBlock((LevelReader)world, chunkCorner, shape.getLowerBound(), shape.getUpperBound(), pos -> {
            if (context.canPlaceAt((BlockPos)pos) && shape.isInside((BlockPos)pos)) {
                context.consume((BlockPos)pos);
            }
        });
    }

    public abstract IGenerationContext createContext(BlockPos var1, ChunkGenerator var2, Random var3, BlockPos var4, WorldGenRegion var5);

    public static interface IGenerationContext {
        public boolean canPlaceAt(BlockPos var1);

        public void consume(BlockPos var1);
    }
}

