/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.config.type;

import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.config.ConfigFlagManager;
import org.violetmoon.zeta.config.type.BiomeTagConfig;
import org.violetmoon.zeta.config.type.IBiomeConfig;
import org.violetmoon.zeta.config.type.IConfigType;
import org.violetmoon.zeta.config.type.StrictBiomeConfig;
import org.violetmoon.zeta.module.ZetaModule;

public class CompoundBiomeConfig
implements IBiomeConfig,
IConfigType {
    @Config(description="Biome tags for which this should spawn in. Must match both this and 'biomes' to spawn.")
    public BiomeTagConfig tags;
    @Config(description="Biome names this should spawn in. Must match both this and 'types' to spawn.")
    public StrictBiomeConfig biomes;

    private CompoundBiomeConfig(BiomeTagConfig tags, StrictBiomeConfig biomes) {
        this.tags = tags;
        this.biomes = biomes;
    }

    @SafeVarargs
    public static CompoundBiomeConfig fromBiomeTags(boolean isBlacklist, TagKey<Biome> ... typesIn) {
        return new CompoundBiomeConfig(new BiomeTagConfig(isBlacklist, typesIn), CompoundBiomeConfig.noSBC());
    }

    public static CompoundBiomeConfig fromBiomeTagStrings(boolean isBlacklist, String ... typesIn) {
        return new CompoundBiomeConfig(BiomeTagConfig.fromStrings(isBlacklist, typesIn), CompoundBiomeConfig.noSBC());
    }

    public static CompoundBiomeConfig fromBiomeReslocs(boolean isBlacklist, String ... typesIn) {
        return new CompoundBiomeConfig(CompoundBiomeConfig.noBTC(), new StrictBiomeConfig(isBlacklist, typesIn));
    }

    public static CompoundBiomeConfig all() {
        return new CompoundBiomeConfig(CompoundBiomeConfig.noBTC(), CompoundBiomeConfig.noSBC());
    }

    private static BiomeTagConfig noBTC() {
        return new BiomeTagConfig(true, new TagKey[0]);
    }

    private static StrictBiomeConfig noSBC() {
        return new StrictBiomeConfig(true, new String[0]);
    }

    @Override
    public void onReload(ZetaModule module, ConfigFlagManager flagManager) {
        this.tags.onReload(module, flagManager);
        this.biomes.onReload(module, flagManager);
    }

    @Override
    public boolean canSpawn(Holder<Biome> b) {
        return b != null && this.tags.canSpawn(b) && this.biomes.canSpawn(b);
    }
}

